/***

    P R O C E S S I N G . J S - 1.4.1-API
    a port of the Processing visualization language

    Processing.js is licensed under the MIT License, see LICENSE.
    For a list of copyright holders, please refer to AUTHORS.

    http://processingjs.org

***/

(function(m,v,p,d){var i=function(){};var t=function(){if("console" in m){return function(I){m.console.log("Processing.js: "+I)}}return i}();var s=function(I){var J=new XMLHttpRequest;J.open("GET",I,false);if(J.overrideMimeType){J.overrideMimeType("text/plain")}J.setRequestHeader("If-Modified-Since","Fri, 01 Jan 1960 00:00:00 GMT");J.send(null);if(J.status!==200&&J.status!==0){throw"XMLHttpRequest failed, status code "+J.status}return J.responseText};var H="document" in this&&!("fake" in this.document);v.head=v.head||v.getElementsByTagName("head")[0];function j(I,J){if(I in m){return m[I]}if(typeof m[J]==="function"){return m[J]}return function(L){if(L instanceof Array){return L}if(typeof L==="number"){var K=[];K.length=L;return K}}}if(v.documentMode>=9&&!v.doctype){throw"The doctype directive is missing. The recommended doctype in Internet Explorer is the HTML5 doctype: <!DOCTYPE html>"}var e=j("Float32Array","WebGLFloatArray"),n=j("Int32Array","WebGLIntArray"),x=j("Uint16Array","WebGLUnsignedShortArray"),r=j("Uint8Array","WebGLUnsignedByteArray");var k={X:0,Y:1,Z:2,R:3,G:4,B:5,A:6,U:7,V:8,NX:9,NY:10,NZ:11,EDGE:12,SR:13,SG:14,SB:15,SA:16,SW:17,TX:18,TY:19,TZ:20,VX:21,VY:22,VZ:23,VW:24,AR:25,AG:26,AB:27,DR:3,DG:4,DB:5,DA:6,SPR:28,SPG:29,SPB:30,SHINE:31,ER:32,EG:33,EB:34,BEEN_LIT:35,VERTEX_FIELD_COUNT:36,P2D:1,JAVA2D:1,WEBGL:2,P3D:2,OPENGL:2,PDF:0,DXF:0,OTHER:0,WINDOWS:1,MAXOSX:2,LINUX:3,EPSILON:0.0001,MAX_FLOAT:3.4028235e+38,MIN_FLOAT:-3.4028235e+38,MAX_INT:2147483647,MIN_INT:-2147483648,PI:p.PI,TWO_PI:2*p.PI,HALF_PI:p.PI/2,THIRD_PI:p.PI/3,QUARTER_PI:p.PI/4,DEG_TO_RAD:p.PI/180,RAD_TO_DEG:180/p.PI,WHITESPACE:" \t\n\r\u000c\u00a0",RGB:1,ARGB:2,HSB:3,ALPHA:4,CMYK:5,TIFF:0,TARGA:1,JPEG:2,GIF:3,BLUR:11,GRAY:12,INVERT:13,OPAQUE:14,POSTERIZE:15,THRESHOLD:16,ERODE:17,DILATE:18,REPLACE:0,BLEND:1<<0,ADD:1<<1,SUBTRACT:1<<2,LIGHTEST:1<<3,DARKEST:1<<4,DIFFERENCE:1<<5,EXCLUSION:1<<6,MULTIPLY:1<<7,SCREEN:1<<8,OVERLAY:1<<9,HARD_LIGHT:1<<10,SOFT_LIGHT:1<<11,DODGE:1<<12,BURN:1<<13,ALPHA_MASK:4278190080,RED_MASK:16711680,GREEN_MASK:65280,BLUE_MASK:255,CUSTOM:0,ORTHOGRAPHIC:2,PERSPECTIVE:3,POINT:2,POINTS:2,LINE:4,LINES:4,TRIANGLE:8,TRIANGLES:9,TRIANGLE_STRIP:10,TRIANGLE_FAN:11,QUAD:16,QUADS:16,QUAD_STRIP:17,POLYGON:20,PATH:21,RECT:30,ELLIPSE:31,ARC:32,SPHERE:40,BOX:41,GROUP:0,PRIMITIVE:1,GEOMETRY:3,VERTEX:0,BEZIER_VERTEX:1,CURVE_VERTEX:2,BREAK:3,CLOSESHAPE:4,OPEN:1,CLOSE:2,CORNER:0,CORNERS:1,RADIUS:2,CENTER_RADIUS:2,CENTER:3,DIAMETER:3,CENTER_DIAMETER:3,BASELINE:0,TOP:101,BOTTOM:102,NORMAL:1,NORMALIZED:1,IMAGE:2,MODEL:4,SHAPE:5,SQUARE:"butt",ROUND:"round",PROJECT:"square",MITER:"miter",BEVEL:"bevel",AMBIENT:0,DIRECTIONAL:1,SPOT:3,BACKSPACE:8,TAB:9,ENTER:10,RETURN:13,ESC:27,DELETE:127,CODED:65535,SHIFT:16,CONTROL:17,ALT:18,CAPSLK:20,PGUP:33,PGDN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,NUMLK:144,META:157,INSERT:155,ARROW:"default",CROSS:"crosshair",HAND:"pointer",MOVE:"move",TEXT:"text",WAIT:"wait",NOCURSOR:"url('data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=='), auto",DISABLE_OPENGL_2X_SMOOTH:1,ENABLE_OPENGL_2X_SMOOTH:-1,ENABLE_OPENGL_4X_SMOOTH:2,ENABLE_NATIVE_FONTS:3,DISABLE_DEPTH_TEST:4,ENABLE_DEPTH_TEST:-4,ENABLE_DEPTH_SORT:5,DISABLE_DEPTH_SORT:-5,DISABLE_OPENGL_ERROR_REPORT:6,ENABLE_OPENGL_ERROR_REPORT:-6,ENABLE_ACCURATE_TEXTURES:7,DISABLE_ACCURATE_TEXTURES:-7,HINT_COUNT:10,SINCOS_LENGTH:720,PRECISIONB:15,PRECISIONF:1<<15,PREC_MAXVAL:(1<<15)-1,PREC_ALPHA_SHIFT:24-15,PREC_RED_SHIFT:16-15,NORMAL_MODE_AUTO:0,NORMAL_MODE_SHAPE:1,NORMAL_MODE_VERTEX:2,MAX_LIGHTS:8};function b(K){if(typeof K==="string"){var J=0;for(var I=0;I<K.length;++I){J=J*31+K.charCodeAt(I)&4294967295}return J}if(typeof K!=="object"){return K&4294967295}if(K.hashCode instanceof Function){return K.hashCode()}if(K.$id===d){K.$id=p.floor(p.random()*65536)-32768<<16|p.floor(p.random()*65536)}return K.$id}function u(J,I){if(J===null||I===null){return J===null&&I===null}if(typeof J==="string"){return J===I}if(typeof J!=="object"){return J===I}if(J.equals instanceof Function){return J.equals(I)}return J===I}var f=function(J){if(J.iterator instanceof Function){return J.iterator()}if(J instanceof Array){var I=-1;this.hasNext=function(){return ++I<J.length};this.next=function(){return J[I]}}else{throw"Unable to iterate: "+J}};var o=function(){function J(L){var K=0;this.hasNext=function(){return K<L.length};this.next=function(){return L[K++]};this.remove=function(){L.splice(K,1)}}function I(K){var L;if(K instanceof I){L=K.toArray()}else{L=[];if(typeof K==="number"){L.length=K>0?K:0}}this.get=function(M){return L[M]};this.contains=function(M){return this.indexOf(M)>-1};this.indexOf=function(O){for(var N=0,M=L.length;N<M;++N){if(u(O,L[N])){return N}}return -1};this.lastIndexOf=function(N){for(var M=L.length-1;M>=0;--M){if(u(N,L[M])){return M}}return -1};this.add=function(){if(arguments.length===1){L.push(arguments[0])}else{if(arguments.length===2){var M=arguments[0];if(typeof M==="number"){if(M>=0&&M<=L.length){L.splice(M,0,arguments[1])}else{throw M+" is not a valid index"}}else{throw typeof M+" is not a number"}}else{throw"Please use the proper number of parameters."}}};this.addAll=function(N,M){var O;if(typeof N==="number"){if(N<0||N>L.length){throw"Index out of bounds for addAll: "+N+" greater or equal than "+L.length}O=new f(M);while(O.hasNext()){L.splice(N++,0,O.next())}}else{O=new f(N);while(O.hasNext()){L.push(O.next())}}};this.set=function(){if(arguments.length===2){var M=arguments[0];if(typeof M==="number"){if(M>=0&&M<L.length){L.splice(M,1,arguments[1])}else{throw M+" is not a valid index."}}else{throw typeof M+" is not a number"}}else{throw"Please use the proper number of parameters."}};this.size=function(){return L.length};this.clear=function(){L.length=0};this.remove=function(M){if(typeof M==="number"){return L.splice(M,1)[0]}M=this.indexOf(M);if(M>-1){L.splice(M,1);return true}return false};this.removeAll=function(Q){var N,M,P,O=new I;O.addAll(this);this.clear();for(N=0,M=0;N<O.size();N++){P=O.get(N);if(!Q.contains(P)){this.add(M++,P)}}if(this.size()<O.size()){return true}return false};this.isEmpty=function(){return !L.length};this.clone=function(){return new I(this)};this.toArray=function(){return L.slice(0)};this.iterator=function(){return new J(L)}}return I}();var E=function(){function I(){if(arguments.length===1&&arguments[0] instanceof I){return arguments[0].clone()}var R=arguments.length>0?arguments[0]:16;var S=arguments.length>1?arguments[1]:0.75;var L=[];L.length=R;var N=0;var J=this;function P(U){var T=b(U)%L.length;return T<0?L.length+T:T}function M(){if(N<=S*L.length){return}var W=[];for(var V=0;V<L.length;++V){if(L[V]!==d){W=W.concat(L[V])}}var X=L.length*2;L=[];L.length=X;for(var U=0;U<W.length;++U){var T=P(W[U].key);var Y=L[T];if(Y===d){L[T]=Y=[]}Y.push(W[U])}}function K(Y,Z){var T=0;var X=-1;var W=false;var V;function U(){while(!W){++X;if(T>=L.length){W=true}else{if(L[T]===d||X>=L[T].length){X=-1;++T}else{return}}}}this.hasNext=function(){return !W};this.next=function(){V=Y(L[T][X]);U();return V};this.remove=function(){if(V!==d){Z(V);--X;U()}};U()}function Q(T,U,V){this.clear=function(){J.clear()};this.contains=function(W){return U(W)};this.containsAll=function(X){var W=X.iterator();while(W.hasNext()){if(!this.contains(W.next())){return false}}return true};this.isEmpty=function(){return J.isEmpty()};this.iterator=function(){return new K(T,V)};this.remove=function(W){if(this.contains(W)){V(W);return true}return false};this.removeAll=function(Z){var W=Z.iterator();var Y=false;while(W.hasNext()){var X=W.next();if(this.contains(X)){V(X);Y=true}}return true};this.retainAll=function(aa){var Y=this.iterator();var X=[];while(Y.hasNext()){var Z=Y.next();if(!aa.contains(Z)){X.push(Z)}}for(var W=0;W<X.length;++W){V(X[W])}return X.length>0};this.size=function(){return J.size()};this.toArray=function(){var W=[];var X=this.iterator();while(X.hasNext()){W.push(X.next())}return W}}function O(T){this._isIn=function(U){return U===J&&T.removed===d};this.equals=function(U){return u(T.key,U.getKey())};this.getKey=function(){return T.key};this.getValue=function(){return T.value};this.hashCode=function(U){return b(T.key)};this.setValue=function(V){var U=T.value;T.value=V;return U}}this.clear=function(){N=0;L=[];L.length=R};this.clone=function(){var T=new I;T.putAll(this);return T};this.containsKey=function(V){var T=P(V);var W=L[T];if(W===d){return false}for(var U=0;U<W.length;++U){if(u(W[U].key,V)){return true}}return false};this.containsValue=function(V){for(var U=0;U<L.length;++U){var W=L[U];if(W===d){continue}for(var T=0;T<W.length;++T){if(u(W[T].value,V)){return true}}}return false};this.entrySet=function(){return new Q(function(T){return new O(T)},function(T){return T instanceof O&&T._isIn(J)},function(T){return J.remove(T.getKey())})};this.get=function(V){var T=P(V);var W=L[T];if(W===d){return null}for(var U=0;U<W.length;++U){if(u(W[U].key,V)){return W[U].value}}return null};this.isEmpty=function(){return N===0};this.keySet=function(){return new Q(function(T){return T.key},function(T){return J.containsKey(T)},function(T){return J.remove(T)})};this.values=function(){return new Q(function(T){return T.value},function(T){return J.containsValue(T)},function(T){return J.removeByValue(T)})};this.put=function(V,X){var T=P(V);var Y=L[T];if(Y===d){++N;L[T]=[{key:V,value:X}];M();return null}for(var U=0;U<Y.length;++U){if(u(Y[U].key,V)){var W=Y[U].value;Y[U].value=X;return W}}++N;Y.push({key:V,value:X});M();return null};this.putAll=function(T){var U=T.entrySet().iterator();while(U.hasNext()){var V=U.next();this.put(V.getKey(),V.getValue())}};this.remove=function(V){var T=P(V);var X=L[T];if(X===d){return null}for(var U=0;U<X.length;++U){if(u(X[U].key,V)){--N;var W=X[U].value;X[U].removed=true;if(X.length>1){X.splice(U,1)}else{L[T]=d}return W}}return null};this.removeByValue=function(V){var X,U,T,W;for(X in L){if(L.hasOwnProperty(X)){for(U=0,T=L[X].length;U<T;U++){W=L[X][U];if(W.value===V){L[X].splice(U,1);return true}}}}return false};this.size=function(){return N}}return I}();var l=function(){function I(L,N,M){this.x=L||0;this.y=N||0;this.z=M||0}I.dist=function(M,L){return M.dist(L)};I.dot=function(M,L){return M.dot(L)};I.cross=function(M,L){return M.cross(L)};I.angleBetween=function(M,L){return p.acos(M.dot(L)/(M.mag()*L.mag()))};I.prototype={set:function(L,N,M){if(arguments.length===1){this.set(L.x||L[0]||0,L.y||L[1]||0,L.z||L[2]||0)}else{this.x=L;this.y=N;this.z=M}},get:function(){return new I(this.x,this.y,this.z)},mag:function(){var L=this.x,N=this.y,M=this.z;return p.sqrt(L*L+N*N+M*M)},add:function(L,N,M){if(arguments.length===1){this.x+=L.x;this.y+=L.y;this.z+=L.z}else{this.x+=L;this.y+=N;this.z+=M}},sub:function(L,N,M){if(arguments.length===1){this.x-=L.x;this.y-=L.y;this.z-=L.z}else{this.x-=L;this.y-=N;this.z-=M}},mult:function(L){if(typeof L==="number"){this.x*=L;this.y*=L;this.z*=L}else{this.x*=L.x;this.y*=L.y;this.z*=L.z}},div:function(L){if(typeof L==="number"){this.x/=L;this.y/=L;this.z/=L}else{this.x/=L.x;this.y/=L.y;this.z/=L.z}},dist:function(O){var N=this.x-O.x,M=this.y-O.y,L=this.z-O.z;return p.sqrt(N*N+M*M+L*L)},dot:function(L,N,M){if(arguments.length===1){return this.x*L.x+this.y*L.y+this.z*L.z}return this.x*L+this.y*N+this.z*M},cross:function(M){var L=this.x,O=this.y,N=this.z;return new I(O*M.z-M.y*N,N*M.x-M.z*L,L*M.y-M.x*O)},normalize:function(){var L=this.mag();if(L>0){this.div(L)}},limit:function(L){if(this.mag()>L){this.normalize();this.mult(L)}},heading2D:function(){return -p.atan2(-this.y,this.x)},toString:function(){return"["+this.x+", "+this.y+", "+this.z+"]"},array:function(){return[this.x,this.y,this.z]}};function J(L){return function(O,N){var M=O.get();M[L](N);return M}}for(var K in I.prototype){if(I.prototype.hasOwnProperty(K)&&!I.hasOwnProperty(K)){I[K]=J(K)}}return I}();function C(){}C.prototype=k;var c=new C;c.ArrayList=o;c.HashMap=E;c.PVector=l;c.ObjectIterator=f;c.PConstants=k;c.defineProperty=function(J,I,K){if("defineProperty" in Object){Object.defineProperty(J,I,K)}else{if(K.hasOwnProperty("get")){J.__defineGetter__(I,K.get)}if(K.hasOwnProperty("set")){J.__defineSetter__(I,K.set)}}};function B(J,I,M){if(!J.hasOwnProperty(I)||typeof J[I]!=="function"){J[I]=M;return}var L=J[I];if("$overloads" in L){L.$defaultOverload=M;return}if(!("$overloads" in M)&&L.length===M.length){return}var O,K;if("$overloads" in M){O=M.$overloads.slice(0);O[L.length]=L;K=M.$defaultOverload}else{O=[];O[M.length]=M;O[L.length]=L;K=L}var N=function(){var P=N.$overloads[arguments.length]||("$methodArgsIndex" in N&&arguments.length>N.$methodArgsIndex?N.$overloads[N.$methodArgsIndex]:null)||N.$defaultOverload;return P.apply(this,arguments)};N.$overloads=O;if("$methodArgsIndex" in M){N.$methodArgsIndex=M.$methodArgsIndex}N.$defaultOverload=K;N.name=I;J[I]=N}function y(L,K){function M(N){c.defineProperty(L,N,{get:function(){return K[N]},set:function(O){K[N]=O},enumerable:true})}var J=[];for(var I in K){if(typeof K[I]==="function"){B(L,I,K[I])}else{if(I.charAt(0)!=="$"&&!(I in L)){J.push(I)}}}while(J.length>0){M(J.shift())}L.$super=K}c.extendClassChain=function(J){var K=[J];for(var I=J.$upcast;I;I=I.$upcast){y(I,J);K.push(I);J=I}while(K.length>0){K.pop().$self=J}};c.extendStaticMembers=function(I,J){y(I,J)};c.extendInterfaceMembers=function(I,J){y(I,J)};c.addMethod=function(L,K,N,M){var I=L[K];if(I||M){var J=N.length;if("$overloads" in I){I.$overloads[J]=N}else{var O=function(){var Q=O.$overloads[arguments.length]||("$methodArgsIndex" in O&&arguments.length>O.$methodArgsIndex?O.$overloads[O.$methodArgsIndex]:null)||O.$defaultOverload;return Q.apply(this,arguments)};var P=[];if(I){P[I.length]=I}P[J]=N;O.$overloads=P;O.$defaultOverload=I||N;if(M){O.$methodArgsIndex=J}O.name=K;L[K]=O}}else{L[K]=N}};function a(I){if(typeof I!=="string"){return false}return["byte","int","char","color","float","long","double"].indexOf(I)!==-1}c.createJavaArray=function(N,O){var J=null,K=null;if(typeof N==="string"){if(N==="boolean"){K=false}else{if(a(N)){K=0}}}if(typeof O[0]==="number"){var I=0|O[0];if(O.length<=1){J=[];J.length=I;for(var M=0;M<I;++M){J[M]=K}}else{J=[];var P=O.slice(1);for(var L=0;L<I;++L){J.push(c.createJavaArray(N,P))}}}return J};var q={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};(function(J){var M=("open() createOutput() createInput() BufferedReader selectFolder() dataPath() createWriter() selectOutput() beginRecord() saveStream() endRecord() selectInput() saveBytes() createReader() beginRaw() endRaw() PrintWriter delay()").split(" "),L=M.length,I,N;function K(O){return function(){throw"Processing.js does not support "+O+"."}}while(L--){I=M[L];N=I.replace("()","");J[N]=K(I)}})(c);c.defineProperty(c,"screenWidth",{get:function(){return m.innerWidth}});c.defineProperty(c,"screenHeight",{get:function(){return m.innerHeight}});c.defineProperty(c,"online",{get:function(){return true}});var A=[];var h={};var F=function(I){A.splice(h[I],1);delete h[I]};var w=function(I){if(I.externals.canvas.id===d||!I.externals.canvas.id.length){I.externals.canvas.id="__processing"+A.length}h[I.externals.canvas.id]=A.length;A.push(I)};function z(S){var L=250,Z=S.size/L,I=v.createElement("canvas");I.width=2*L;I.height=2*L;I.style.opacity=0;var R=S.getCSSDefinition(L+"px","normal"),T=I.getContext("2d");T.font=R;var X="dbflkhyjqpg";I.width=T.measureText(X).width;T.font=R;var O=v.createElement("div");O.style.position="absolute";O.style.opacity=0;O.style.fontFamily='"'+S.name+'"';O.style.fontSize=L+"px";O.innerHTML=X+"<br/>"+X;v.body.appendChild(O);var P=I.width,W=I.height,Q=W/2;T.fillStyle="white";T.fillRect(0,0,P,W);T.fillStyle="black";T.fillText(X,0,Q);var K=T.getImageData(0,0,P,W).data;var U=0,N=P*4,V=K.length;while(++U<V&&K[U]===255){i()}var M=p.round(U/N);U=V-1;while(--U>0&&K[U]===255){i()}var Y=p.round(U/N);S.ascent=Z*(Q-M);S.descent=Z*(Y-Q);if(v.defaultView.getComputedStyle){var J=v.defaultView.getComputedStyle(O,null).getPropertyValue("height");J=Z*J.replace("px","");if(J>=S.size*2){S.leading=p.round(J/2)}}v.body.removeChild(O);if(S.caching){return T}}function g(I,J){if(I===d){I=""}this.name=I;if(J===d){J=0}this.size=J;this.glyph=false;this.ascent=0;this.descent=0;this.leading=1.2*J;var M=I.indexOf(" Italic Bold");if(M!==-1){I=I.substring(0,M)}this.style="normal";var L=I.indexOf(" Italic");if(L!==-1){I=I.substring(0,L);this.style="italic"}this.weight="normal";var K=I.indexOf(" Bold");if(K!==-1){I=I.substring(0,K);this.weight="bold"}this.family="sans-serif";if(I!==d){switch(I){case"sans-serif":case"serif":case"monospace":case"fantasy":case"cursive":this.family=I;break;default:this.family='"'+I+'", sans-serif';break}}this.context2d=z(this);this.css=this.getCSSDefinition();if(this.context2d){this.context2d.font=this.css}}g.prototype.caching=true;g.prototype.getCSSDefinition=function(K,I){if(K===d){K=this.size+"px"}if(I===d){I=this.leading+"px"}var J=[this.style,"normal",this.weight,K+"/"+I,this.family];return J.join(" ")};g.prototype.measureTextWidth=function(I){return this.context2d.measureText(I).width};g.prototype.measureTextWidthFallback=function(K){var J=v.createElement("canvas"),I=J.getContext("2d");I.font=this.css;return I.measureText(K).width};g.PFontCache={length:0};g.get=function(L,M){M=(M*10+0.5|0)/10;var J=g.PFontCache,I=L+"/"+M;if(!J[I]){J[I]=new g(L,M);J.length++;if(J.length===50){g.prototype.measureTextWidth=g.prototype.measureTextWidthFallback;g.prototype.caching=false;var K;for(K in J){if(K!=="length"){J[K].context2d=null}}return new g(L,M)}if(J.length===400){g.PFontCache={};g.get=g.getFallback;return new g(L,M)}}return J[I]};g.getFallback=function(I,J){return new g(I,J)};g.list=function(){return["sans-serif","serif","monospace","fantasy","cursive"]};g.preloading={template:{},initialized:false,initialize:function(){var K=function(){var M="#E3KAI2wAgT1MvMg7Eo3VmNtYX7ABi3CxnbHlm7Abw3kaGVhZ7ACs3OGhoZWE7A53CRobXR47AY3AGbG9jYQ7G03Bm1heH7ABC3CBuYW1l7Ae3AgcG9zd7AI3AE#B3AQ2kgTY18PPPUACwAg3ALSRoo3#yld0xg32QAB77#E777773B#E3C#I#Q77773E#Q7777777772CMAIw7AB77732B#M#Q3wAB#g3B#E#E2BB//82BB////w#B7#gAEg3E77x2B32B#E#Q#MTcBAQ32gAe#M#QQJ#E32M#QQJ#I#g32Q77#";var L=function(N){return"AAAAAAAA".substr(~~N?7-N:6)};return M.replace(/[#237]/g,L)};var I=v.createElement("style");I.setAttribute("type","text/css");I.innerHTML='@font-face {\n  font-family: "PjsEmptyFont";\n  src: url(\'data:application/x-font-ttf;base64,'+K()+"')\n       format('truetype');\n}";v.head.appendChild(I);var J=v.createElement("span");J.style.cssText='position: absolute; top: 0; left: 0; opacity: 0; font-family: "PjsEmptyFont", fantasy;';J.innerHTML="AAAAAAAA";v.body.appendChild(J);this.template=J;this.initialized=true},getElementWidth:function(I){return v.defaultView.getComputedStyle(I,"").getPropertyValue("width")},timeAttempted:0,pending:function(M){if(!this.initialized){this.initialize()}var K,I,L=this.getElementWidth(this.template);for(var J=0;J<this.fontList.length;J++){K=this.fontList[J];I=this.getElementWidth(K);if(this.timeAttempted<4000&&I===L){this.timeAttempted+=M;return true}else{v.body.removeChild(K);this.fontList.splice(J--,1);this.timeAttempted=0}}if(this.fontList.length===0){return false}return true},fontList:[],addedList:{},add:function(I){if(!this.initialized){this.initialize()}var M=typeof I==="object"?I.fontFace:I,L=typeof I==="object"?I.url:I;if(this.addedList[M]){return}var K=v.createElement("style");K.setAttribute("type","text/css");K.innerHTML="@font-face{\n  font-family: '"+M+"';\n  src:  url('"+L+"');\n}\n";v.head.appendChild(K);this.addedList[M]=true;var J=v.createElement("span");J.style.cssText="position: absolute; top: 0; left: 0; opacity: 0;";J.style.fontFamily='"'+M+'", "PjsEmptyFont", fantasy';J.innerHTML="AAAAAAAA";v.body.appendChild(J);this.fontList.push(J)}};c.PFont=g;var D=this.Processing=function(a9,a5){if(!(this instanceof D)){throw"called Processing constructor as if it were a function: missing 'new'."}var Z,cQ=a9===d&&a5===d;if(cQ){Z=v.createElement("canvas")}else{Z=typeof a9==="string"?v.getElementById(a9):a9}if(!(Z instanceof HTMLCanvasElement)){throw"called Processing constructor without passing canvas element reference or id."}function dr(d5){D.debug("Unimplemented - "+d5)}var cR=this;cR.externals={canvas:Z,context:d,sketch:d};cR.name="Processing.js Instance";cR.use3DContext=false;cR.focused=false;cR.breakShape=false;cR.glyphTable={};cR.pmouseX=0;cR.pmouseY=0;cR.mouseX=0;cR.mouseY=0;cR.mouseButton=0;cR.mouseScroll=0;cR.mouseClicked=d;cR.mouseDragged=d;cR.mouseMoved=d;cR.mousePressed=d;cR.mouseReleased=d;cR.mouseScrolled=d;cR.mouseOver=d;cR.mouseOut=d;cR.touchStart=d;cR.touchEnd=d;cR.touchMove=d;cR.touchCancel=d;cR.key=d;cR.keyCode=d;cR.keyPressed=i;cR.keyReleased=i;cR.keyTyped=i;cR.draw=d;cR.setup=d;cR.__mousePressed=false;cR.__keyPressed=false;cR.__frameRate=60;cR.frameCount=0;cR.width=100;cR.height=100;var d3,cL,dT,by=true,aC=true,bj=[1,1,1,1],aW=4294967295,al=true,b9=true,cV=[0,0,0,1],cq=4278190080,bY=true,dR=1,ar=false,dJ=false,ax=true,bZ=0,bF=0,cI=3,a3=0,a2=0,a1=0,aX=0,dP=60,au=1000/dP,U="default",cf=Z.style.cursor,dM=20,ce=0,d1=[],aE=0,L=20,cH=false,aZ=-3355444,ct=20,bP=255,bE=255,bD=255,bB=255,cU=false,aF=false,dI=0,d0=0,cT=1,ba=null,br=null,a0=false,dk=Date.now(),dn=dk,K=0,cz,cY,aL,aG,bu,b8,P,dx={attributes:{},locations:{}},ds,dL,bO,bc,cE,df,aw,bX,bb,b3,an,aB,bx,aq,aa,c2,bN,cn={width:0,height:0},dZ=2,dO=false,cC,X,M,I=37,cW=0,cD=4,T="Arial",dV=12,aY=9,dv=2,d2=14,R=g.get(T,dV),ae,ci=null,dQ=false,dY,bU=1000,ab=[],dD=null,dS=[16,17,18,20,33,34,35,36,37,38,39,40,144,155,112,113,114,115,116,117,118,119,120,121,122,123,157];var Y,dj,aP,bS;if(v.defaultView&&v.defaultView.getComputedStyle){Y=parseInt(v.defaultView.getComputedStyle(Z,null)["paddingLeft"],10)||0;dj=parseInt(v.defaultView.getComputedStyle(Z,null)["paddingTop"],10)||0;aP=parseInt(v.defaultView.getComputedStyle(Z,null)["borderLeftWidth"],10)||0;bS=parseInt(v.defaultView.getComputedStyle(Z,null)["borderTopWidth"],10)||0}var dG=0;var bG=0,bH=0,bo=[],bn=[],bm=[],ac=new e(720),bg=new e(720),cA,cv;var bQ,cc,dE,aO,ah,c5,W,c6,ak=false,cd=false,cF=60*(p.PI/180),dg=cR.width/2,de=cR.height/2,dd=de/p.tan(cF/2),aV=dd/10,ap=dd*10,b0=cR.width/cR.height;var a6=[],b6=[],cX=0,dK=false,V=false,dp=true;var N=0;var bh=[];var dc=new e([0.5,0.5,-0.5,0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,0.5,-0.5,0.5,0.5,-0.5,0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,0.5,-0.5,0.5,0.5,0.5,0.5,0.5,0.5,-0.5,0.5,0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,0.5,-0.5,0.5,-0.5,-0.5,0.5,-0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,-0.5,0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,0.5,-0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,0.5,-0.5,-0.5,-0.5,-0.5,0.5,0.5,0.5,0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,0.5,0.5,0.5,0.5]);var bC=new e([0.5,0.5,0.5,0.5,-0.5,0.5,0.5,0.5,-0.5,0.5,-0.5,-0.5,-0.5,0.5,-0.5,-0.5,-0.5,-0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,0.5,0.5,0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,0.5,-0.5,0.5,0.5,0.5,0.5,0.5,0.5,-0.5,0.5,0.5,-0.5,-0.5,0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,0.5,-0.5,-0.5,0.5,0.5,-0.5,0.5]);var da=new e([0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,-1,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0]);var af=new e([0,0,0,0,1,0,1,1,0,1,0,0]);var ad=new e([0,0,1,0,0,1,0,0,1,0,0,1]);var aJ="varying vec4 vFrontColor;attribute vec3 aVertex;attribute vec4 aColor;uniform mat4 uView;uniform mat4 uProjection;uniform float uPointSize;void main(void) {  vFrontColor = aColor;  gl_PointSize = uPointSize;  gl_Position = uProjection * uView * vec4(aVertex, 1.0);}";var bL="#ifdef GL_ES\nprecision highp float;\n#endif\nvarying vec4 vFrontColor;uniform bool uSmooth;void main(void){  if(uSmooth == true){    float dist = distance(gl_PointCoord, vec2(0.5));    if(dist > 0.5){      discard;    }  }  gl_FragColor = vFrontColor;}";var dz="varying vec4 vFrontColor;attribute vec3 aVertex;attribute vec2 aTextureCoord;uniform vec4 uColor;uniform mat4 uModel;uniform mat4 uView;uniform mat4 uProjection;uniform float uPointSize;varying vec2 vTextureCoord;void main(void) {  gl_PointSize = uPointSize;  vFrontColor = uColor;  gl_Position = uProjection * uView * uModel * vec4(aVertex, 1.0);  vTextureCoord = aTextureCoord;}";var aR="#ifdef GL_ES\nprecision highp float;\n#endif\nvarying vec4 vFrontColor;varying vec2 vTextureCoord;uniform sampler2D uSampler;uniform int uIsDrawingText;uniform bool uSmooth;void main(void){  if(uSmooth == true){    float dist = distance(gl_PointCoord, vec2(0.5));    if(dist > 0.5){      discard;    }  }  if(uIsDrawingText == 1){    float alpha = texture2D(uSampler, vTextureCoord).a;    gl_FragColor = vec4(vFrontColor.rgb * alpha, alpha);  }  else{    gl_FragColor = vFrontColor;  }}";var bv=/Windows/.test(navigator.userAgent);var di="varying vec4 vFrontColor;attribute vec3 aVertex;attribute vec3 aNormal;attribute vec4 aColor;attribute vec2 aTexture;varying   vec2 vTexture;uniform vec4 uColor;uniform bool uUsingMat;uniform vec3 uSpecular;uniform vec3 uMaterialEmissive;uniform vec3 uMaterialAmbient;uniform vec3 uMaterialSpecular;uniform float uShininess;uniform mat4 uModel;uniform mat4 uView;uniform mat4 uProjection;uniform mat4 uNormalTransform;uniform int uLightCount;uniform vec3 uFalloff;struct Light {  int type;  vec3 color;  vec3 position;  vec3 direction;  float angle;  vec3 halfVector;  float concentration;};uniform Light uLights0;uniform Light uLights1;uniform Light uLights2;uniform Light uLights3;uniform Light uLights4;uniform Light uLights5;uniform Light uLights6;uniform Light uLights7;Light getLight(int index){  if(index == 0) return uLights0;  if(index == 1) return uLights1;  if(index == 2) return uLights2;  if(index == 3) return uLights3;  if(index == 4) return uLights4;  if(index == 5) return uLights5;  if(index == 6) return uLights6;  return uLights7;}void AmbientLight( inout vec3 totalAmbient, in vec3 ecPos, in Light light ) {  float d = length( light.position - ecPos );  float attenuation = 1.0 / ( uFalloff[0] + ( uFalloff[1] * d ) + ( uFalloff[2] * d * d ));  totalAmbient += light.color * attenuation;}void DirectionalLight( inout vec3 col, inout vec3 spec, in vec3 vertNormal, in vec3 ecPos, in Light light ) {  float powerFactor = 0.0;  float nDotVP = max(0.0, dot( vertNormal, normalize(-light.position) ));  float nDotVH = max(0.0, dot( vertNormal, normalize(-light.position-normalize(ecPos) )));  if( nDotVP != 0.0 ){    powerFactor = pow( nDotVH, uShininess );  }  col += light.color * nDotVP;  spec += uSpecular * powerFactor;}void PointLight( inout vec3 col, inout vec3 spec, in vec3 vertNormal, in vec3 ecPos, in Light light ) {  float powerFactor;   vec3 VP = light.position - ecPos;  float d = length( VP );   VP = normalize( VP );  float attenuation = 1.0 / ( uFalloff[0] + ( uFalloff[1] * d ) + ( uFalloff[2] * d * d ));  float nDotVP = max( 0.0, dot( vertNormal, VP ));  vec3 halfVector = normalize( VP - normalize(ecPos) );  float nDotHV = max( 0.0, dot( vertNormal, halfVector ));  if( nDotVP == 0.0 ) {    powerFactor = 0.0;  }  else {    powerFactor = pow( nDotHV, uShininess );  }  spec += uSpecular * powerFactor * attenuation;  col += light.color * nDotVP * attenuation;}void SpotLight( inout vec3 col, inout vec3 spec, in vec3 vertNormal, in vec3 ecPos, in Light light ) {  float spotAttenuation;  float powerFactor = 0.0;  vec3 VP = light.position - ecPos;  vec3 ldir = normalize( -light.direction );  float d = length( VP );  VP = normalize( VP );  float attenuation = 1.0 / ( uFalloff[0] + ( uFalloff[1] * d ) + ( uFalloff[2] * d * d ) );  float spotDot = dot( VP, ldir );"+(bv?"  spotAttenuation = 1.0; ":"  if( spotDot > cos( light.angle ) ) {    spotAttenuation = pow( spotDot, light.concentration );  }  else{    spotAttenuation = 0.0;  }  attenuation *= spotAttenuation;")+"  float nDotVP = max( 0.0, dot( vertNormal, VP ) );  vec3 halfVector = normalize( VP - normalize(ecPos) );  float nDotHV = max( 0.0, dot( vertNormal, halfVector ) );  if( nDotVP != 0.0 ) {    powerFactor = pow( nDotHV, uShininess );  }  spec += uSpecular * powerFactor * attenuation;  col += light.color * nDotVP * attenuation;}void main(void) {  vec3 finalAmbient = vec3( 0.0 );  vec3 finalDiffuse = vec3( 0.0 );  vec3 finalSpecular = vec3( 0.0 );  vec4 col = uColor;  if ( uColor[0] == -1.0 ){    col = aColor;  }  vec3 norm = normalize(vec3( uNormalTransform * vec4( aNormal, 0.0 ) ));  vec4 ecPos4 = uView * uModel * vec4(aVertex, 1.0);  vec3 ecPos = (vec3(ecPos4))/ecPos4.w;  if( uLightCount == 0 ) {    vFrontColor = col + vec4(uMaterialSpecular, 1.0);  }  else {    for( int i = 0; i < 8; i++ ) {      Light l = getLight(i);      if( i >= uLightCount ){        break;      }      if( l.type == 0 ) {        AmbientLight( finalAmbient, ecPos, l );      }      else if( l.type == 1 ) {        DirectionalLight( finalDiffuse, finalSpecular, norm, ecPos, l );      }      else if( l.type == 2 ) {        PointLight( finalDiffuse, finalSpecular, norm, ecPos, l );      }      else {        SpotLight( finalDiffuse, finalSpecular, norm, ecPos, l );      }    }   if( uUsingMat == false ) {     vFrontColor = vec4(       vec3( col ) * finalAmbient +       vec3( col ) * finalDiffuse +       vec3( col ) * finalSpecular,       col[3] );   }   else{     vFrontColor = vec4(        uMaterialEmissive +        (vec3(col) * uMaterialAmbient * finalAmbient ) +        (vec3(col) * finalDiffuse) +        (uMaterialSpecular * finalSpecular),        col[3] );    }  }  vTexture.xy = aTexture.xy;  gl_Position = uProjection * uView * uModel * vec4( aVertex, 1.0 );}";var aA="#ifdef GL_ES\nprecision highp float;\n#endif\nvarying vec4 vFrontColor;uniform sampler2D uSampler;uniform bool uUsingTexture;varying vec2 vTexture;void main(void){  if( uUsingTexture ){    gl_FragColor = vec4(texture2D(uSampler, vTexture.xy)) * vFrontColor;  }  else{    gl_FragColor = vFrontColor;  }}";function dX(d7,d6,d9,d8){var d5=dx.locations[d7];if(d5===d){d5=d3.getUniformLocation(d6,d9);dx.locations[d7]=d5}if(d5!==null){if(d8.length===4){d3.uniform4fv(d5,d8)}else{if(d8.length===3){d3.uniform3fv(d5,d8)}else{if(d8.length===2){d3.uniform2fv(d5,d8)}else{d3.uniform1f(d5,d8)}}}}}function dU(d7,d6,d9,d8){var d5=dx.locations[d7];if(d5===d){d5=d3.getUniformLocation(d6,d9);dx.locations[d7]=d5}if(d5!==null){if(d8.length===4){d3.uniform4iv(d5,d8)}else{if(d8.length===3){d3.uniform3iv(d5,d8)}else{if(d8.length===2){d3.uniform2iv(d5,d8)}else{d3.uniform1i(d5,d8)}}}}}function a4(d9,d7,ea,d8,d6){var d5=dx.locations[d9];if(d5===d){d5=d3.getUniformLocation(d7,ea);dx.locations[d9]=d5}if(d5!==-1){if(d6.length===16){d3.uniformMatrix4fv(d5,d8,d6)}else{if(d6.length===9){d3.uniformMatrix3fv(d5,d8,d6)}else{d3.uniformMatrix2fv(d5,d8,d6)}}}}function c7(d9,d7,ea,d6,d8){var d5=dx.attributes[d9];if(d5===d){d5=d3.getAttribLocation(d7,ea);dx.attributes[d9]=d5}if(d5!==-1){d3.bindBuffer(d3.ARRAY_BUFFER,d8);d3.vertexAttribPointer(d5,d6,d3.FLOAT,false,0,0);d3.enableVertexAttribArray(d5)}}function cb(d7,d6,d8){var d5=dx.attributes[d7];if(d5===d){d5=d3.getAttribLocation(d6,d8);dx.attributes[d7]=d5}if(d5!==-1){d3.disableVertexAttribArray(d5)}}var bA=function(d7,d9,d6){var ea=d7.createShader(d7.VERTEX_SHADER);d7.shaderSource(ea,d9);d7.compileShader(ea);if(!d7.getShaderParameter(ea,d7.COMPILE_STATUS)){throw d7.getShaderInfoLog(ea)}var d8=d7.createShader(d7.FRAGMENT_SHADER);d7.shaderSource(d8,d6);d7.compileShader(d8);if(!d7.getShaderParameter(d8,d7.COMPILE_STATUS)){throw d7.getShaderInfoLog(d8)}var d5=d7.createProgram();d7.attachShader(d5,ea);d7.attachShader(d5,d8);d7.linkProgram(d5);if(!d7.getProgramParameter(d5,d7.LINK_STATUS)){throw"Error linking shaders."}return d5};var aU=function(d5,d9,d6,d8,d7){return{x:d5,y:d9,w:d6,h:d8}};var bf=aU;var bW=function(d5,d9,d6,d8,d7){return{x:d5,y:d9,w:d7?d6:d6-d5,h:d7?d8:d8-d9}};var aI=function(d5,d9,d6,d8,d7){return{x:d5-d6/2,y:d9-d8/2,w:d6,h:d8}};var dm=function(){};var bM=function(){};var bw=function(){};var b5=function(){};bM.prototype=new dm;bM.prototype.constructor=bM;bw.prototype=new dm;bw.prototype.constructor=bw;b5.prototype=new dm;b5.prototype.constructor=b5;dm.prototype.a3DOnlyFunction=i;var cg={};var bK=cR.Character=function(d5){if(typeof d5==="string"&&d5.length===1){this.code=d5.charCodeAt(0)}else{if(typeof d5==="number"){this.code=d5}else{if(d5 instanceof bK){this.code=d5}else{this.code=NaN}}}return cg[this.code]===d?cg[this.code]=this:cg[this.code]};bK.prototype.toString=function(){return String.fromCharCode(this.code)};bK.prototype.valueOf=function(){return this.code};var J=cR.PShape=function(d5){this.family=d5||0;this.visible=true;this.style=true;this.children=[];this.nameTable=[];this.params=[];this.name="";this.image=null;this.matrix=null;this.kind=null;this.close=null;this.width=null;this.height=null;this.parent=null};J.prototype={isVisible:function(){return this.visible},setVisible:function(d5){this.visible=d5},disableStyle:function(){this.style=false;for(var d6=0,d5=this.children.length;d6<d5;d6++){this.children[d6].disableStyle()}},enableStyle:function(){this.style=true;for(var d6=0,d5=this.children.length;d6<d5;d6++){this.children[d6].enableStyle()}},getFamily:function(){return this.family},getWidth:function(){return this.width},getHeight:function(){return this.height},setName:function(d5){this.name=d5},getName:function(){return this.name},draw:function(d5){d5=d5||cR;if(this.visible){this.pre(d5);this.drawImpl(d5);this.post(d5)}},drawImpl:function(d5){if(this.family===0){this.drawGroup(d5)}else{if(this.family===1){this.drawPrimitive(d5)}else{if(this.family===3){this.drawGeometry(d5)}else{if(this.family===21){this.drawPath(d5)}}}}},drawPath:function(d7){var d8,d6;if(this.vertices.length===0){return}d7.beginShape();if(this.vertexCodes.length===0){if(this.vertices[0].length===2){for(d8=0,d6=this.vertices.length;d8<d6;d8++){d7.vertex(this.vertices[d8][0],this.vertices[d8][1])}}else{for(d8=0,d6=this.vertices.length;d8<d6;d8++){d7.vertex(this.vertices[d8][0],this.vertices[d8][1],this.vertices[d8][2])}}}else{var d5=0;if(this.vertices[0].length===2){for(d8=0,d6=this.vertexCodes.length;d8<d6;d8++){if(this.vertexCodes[d8]===0){d7.vertex(this.vertices[d5][0],this.vertices[d5][1],this.vertices[d5]["moveTo"]);d7.breakShape=false;d5++}else{if(this.vertexCodes[d8]===1){d7.bezierVertex(this.vertices[d5+0][0],this.vertices[d5+0][1],this.vertices[d5+1][0],this.vertices[d5+1][1],this.vertices[d5+2][0],this.vertices[d5+2][1]);d5+=3}else{if(this.vertexCodes[d8]===2){d7.curveVertex(this.vertices[d5][0],this.vertices[d5][1]);d5++}else{if(this.vertexCodes[d8]===3){d7.breakShape=true}}}}}}else{for(d8=0,d6=this.vertexCodes.length;d8<d6;d8++){if(this.vertexCodes[d8]===0){d7.vertex(this.vertices[d5][0],this.vertices[d5][1],this.vertices[d5][2]);if(this.vertices[d5]["moveTo"]===true){a6[a6.length-1]["moveTo"]=true}else{if(this.vertices[d5]["moveTo"]===false){a6[a6.length-1]["moveTo"]=false}}d7.breakShape=false}else{if(this.vertexCodes[d8]===1){d7.bezierVertex(this.vertices[d5+0][0],this.vertices[d5+0][1],this.vertices[d5+0][2],this.vertices[d5+1][0],this.vertices[d5+1][1],this.vertices[d5+1][2],this.vertices[d5+2][0],this.vertices[d5+2][1],this.vertices[d5+2][2]);d5+=3}else{if(this.vertexCodes[d8]===2){d7.curveVertex(this.vertices[d5][0],this.vertices[d5][1],this.vertices[d5][2]);d5++}else{if(this.vertexCodes[d8]===3){d7.breakShape=true}}}}}}}d7.endShape(this.close?2:1)},drawGeometry:function(d7){var d8,d6;d7.beginShape(this.kind);if(this.style){for(d8=0,d6=this.vertices.length;d8<d6;d8++){d7.vertex(this.vertices[d8])}}else{for(d8=0,d6=this.vertices.length;d8<d6;d8++){var d5=this.vertices[d8];if(d5[2]===0){d7.vertex(d5[0],d5[1])}else{d7.vertex(d5[0],d5[1],d5[2])}}}d7.endShape()},drawGroup:function(d6){for(var d7=0,d5=this.children.length;d7<d5;d7++){this.children[d7].draw(d6)}},drawPrimitive:function(d5){if(this.kind===2){d5.point(this.params[0],this.params[1])}else{if(this.kind===4){if(this.params.length===4){d5.line(this.params[0],this.params[1],this.params[2],this.params[3])}else{d5.line(this.params[0],this.params[1],this.params[2],this.params[3],this.params[4],this.params[5])}}else{if(this.kind===8){d5.triangle(this.params[0],this.params[1],this.params[2],this.params[3],this.params[4],this.params[5])}else{if(this.kind===16){d5.quad(this.params[0],this.params[1],this.params[2],this.params[3],this.params[4],this.params[5],this.params[6],this.params[7])}else{if(this.kind===30){if(this.image!==null){var d9=bf;d5.imageMode(0);d5.image(this.image,this.params[0],this.params[1],this.params[2],this.params[3]);bf=d9}else{var d6=bF;d5.rectMode(0);d5.rect(this.params[0],this.params[1],this.params[2],this.params[3]);bF=d6}}else{if(this.kind===31){var d7=cI;d5.ellipseMode(0);d5.ellipse(this.params[0],this.params[1],this.params[2],this.params[3]);cI=d7}else{if(this.kind===32){var d8=cI;d5.ellipseMode(0);d5.arc(this.params[0],this.params[1],this.params[2],this.params[3],this.params[4],this.params[5]);cI=d8}else{if(this.kind===41){if(this.params.length===1){d5.box(this.params[0])}else{d5.box(this.params[0],this.params[1],this.params[2])}}else{if(this.kind===40){d5.sphere(this.params[0])}}}}}}}}}},pre:function(d5){if(this.matrix){d5.pushMatrix();d5.transform(this.matrix)}if(this.style){d5.pushStyle();this.styles(d5)}},post:function(d5){if(this.matrix){d5.popMatrix()}if(this.style){d5.popStyle()}},styles:function(d5){if(this.stroke){d5.stroke(this.strokeColor);d5.strokeWeight(this.strokeWeight);d5.strokeCap(this.strokeCap);d5.strokeJoin(this.strokeJoin)}else{d5.noStroke()}if(this.fill){d5.fill(this.fillColor)}else{d5.noFill()}},getChild:function(d8){var d6,d5;if(typeof d8==="number"){return this.children[d8]}var d7;if(d8===""||this.name===d8){return this}if(this.nameTable.length>0){for(d6=0,d5=this.nameTable.length;d6<d5||d7;d6++){if(this.nameTable[d6].getName===d8){d7=this.nameTable[d6];break}}if(d7){return d7}}for(d6=0,d5=this.children.length;d6<d5;d6++){d7=this.children[d6].getChild(d8);if(d7){return d7}}return null},getChildCount:function(){return this.children.length},addChild:function(d5){this.children.push(d5);d5.parent=this;if(d5.getName()!==null){this.addName(d5.getName(),d5)}},addName:function(d6,d5){if(this.parent!==null){this.parent.addName(d6,d5)}else{this.nameTable.push([d6,d5])}},translate:function(){if(arguments.length===2){this.checkMatrix(2);this.matrix.translate(arguments[0],arguments[1])}else{this.checkMatrix(3);this.matrix.translate(arguments[0],arguments[1],0)}},checkMatrix:function(d5){if(this.matrix===null){if(d5===2){this.matrix=new cR.PMatrix2D}else{this.matrix=new cR.PMatrix3D}}else{if(d5===3&&this.matrix instanceof cR.PMatrix2D){this.matrix=new cR.PMatrix3D}}},rotateX:function(d5){this.rotate(d5,1,0,0)},rotateY:function(d5){this.rotate(d5,0,1,0)},rotateZ:function(d5){this.rotate(d5,0,0,1)},rotate:function(){if(arguments.length===1){this.checkMatrix(2);this.matrix.rotate(arguments[0])}else{this.checkMatrix(3);this.matrix.rotate(arguments[0],arguments[1],arguments[2],arguments[3])}},scale:function(){if(arguments.length===2){this.checkMatrix(2);this.matrix.scale(arguments[0],arguments[1])}else{if(arguments.length===3){this.checkMatrix(2);this.matrix.scale(arguments[0],arguments[1],arguments[2])}else{this.checkMatrix(2);this.matrix.scale(arguments[0])}}},resetMatrix:function(){this.checkMatrix(2);this.matrix.reset()},applyMatrix:function(d5){if(arguments.length===1){this.applyMatrix(d5.elements[0],d5.elements[1],0,d5.elements[2],d5.elements[3],d5.elements[4],0,d5.elements[5],0,0,1,0,0,0,0,1)}else{if(arguments.length===6){this.checkMatrix(2);this.matrix.apply(arguments[0],arguments[1],arguments[2],0,arguments[3],arguments[4],arguments[5],0,0,0,1,0,0,0,0,1)}else{if(arguments.length===16){this.checkMatrix(3);this.matrix.apply(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11],arguments[12],arguments[13],arguments[14],arguments[15])}}}}};var cm=cR.PShapeSVG=function(){cR.PShape.call(this);if(arguments.length===1){this.element=arguments[0];this.vertexCodes=[];this.vertices=[];this.opacity=1;this.stroke=false;this.strokeColor=4278190080;this.strokeWeight=1;this.strokeCap="butt";this.strokeJoin="miter";this.strokeGradient=null;this.strokeGradientPaint=null;this.strokeName=null;this.strokeOpacity=1;this.fill=true;this.fillColor=4278190080;this.fillGradient=null;this.fillGradientPaint=null;this.fillName=null;this.fillOpacity=1;if(this.element.getName()!=="svg"){throw"root is not <svg>, it's <"+this.element.getName()+">"}}else{if(arguments.length===2){if(typeof arguments[1]==="string"){if(arguments[1].indexOf(".svg")>-1){this.element=new cR.XMLElement(cR,arguments[1]);this.vertexCodes=[];this.vertices=[];this.opacity=1;this.stroke=false;this.strokeColor=4278190080;this.strokeWeight=1;this.strokeCap="butt";this.strokeJoin="miter";this.strokeGradient="";this.strokeGradientPaint="";this.strokeName="";this.strokeOpacity=1;this.fill=true;this.fillColor=4278190080;this.fillGradient=null;this.fillGradientPaint=null;this.fillOpacity=1}}else{if(arguments[0]){this.element=arguments[1];this.vertexCodes=arguments[0].vertexCodes.slice();this.vertices=arguments[0].vertices.slice();this.stroke=arguments[0].stroke;this.strokeColor=arguments[0].strokeColor;this.strokeWeight=arguments[0].strokeWeight;this.strokeCap=arguments[0].strokeCap;this.strokeJoin=arguments[0].strokeJoin;this.strokeGradient=arguments[0].strokeGradient;this.strokeGradientPaint=arguments[0].strokeGradientPaint;this.strokeName=arguments[0].strokeName;this.fill=arguments[0].fill;this.fillColor=arguments[0].fillColor;this.fillGradient=arguments[0].fillGradient;this.fillGradientPaint=arguments[0].fillGradientPaint;this.fillName=arguments[0].fillName;this.strokeOpacity=arguments[0].strokeOpacity;this.fillOpacity=arguments[0].fillOpacity;this.opacity=arguments[0].opacity}}}}this.name=this.element.getStringAttribute("id");var d5=this.element.getStringAttribute("display","inline");this.visible=d5!=="none";var ea=this.element.getAttribute("transform");if(ea){this.matrix=this.parseMatrix(ea)}var d7=this.element.getStringAttribute("viewBox");if(d7!==null){var d9=d7.split(" ");this.width=d9[2];this.height=d9[3]}var d6=this.element.getStringAttribute("width");var d8=this.element.getStringAttribute("height");if(d6!==null){this.width=this.parseUnitSize(d6);this.height=this.parseUnitSize(d8)}else{if(this.width===0||this.height===0){this.width=1;this.height=1;throw"The width and/or height is not readable in the <svg> tag of this file."}}this.parseColors(this.element);this.parseChildren(this.element)};cm.prototype=new J;cm.prototype.parseMatrix=function(){function d5(d7){var d6=[];d7.replace(/\((.*?)\)/,function(){return function(d8,d9){d6=d9.replace(/,+/g," ").split(/\s+/)}}());return d6}return function(ed){this.checkMatrix(2);var d6=[];ed.replace(/\s*(\w+)\((.*?)\)/g,function(eg){d6.push(cR.trim(eg))});if(d6.length===0){return null}for(var eb=0,d9=d6.length;eb<d9;eb++){var d7=d5(d6[eb]);if(d6[eb].indexOf("matrix")!==-1){this.matrix.set(d7[0],d7[2],d7[4],d7[1],d7[3],d7[5])}else{if(d6[eb].indexOf("translate")!==-1){var ec=d7[0];var ea=d7.length===2?d7[1]:0;this.matrix.translate(ec,ea)}else{if(d6[eb].indexOf("scale")!==-1){var ef=d7[0];var ee=d7.length===2?d7[1]:d7[0];this.matrix.scale(ef,ee)}else{if(d6[eb].indexOf("rotate")!==-1){var d8=d7[0];if(d7.length===1){this.matrix.rotate(cR.radians(d8))}else{if(d7.length===3){this.matrix.translate(d7[1],d7[2]);this.matrix.rotate(cR.radians(d7[0]));this.matrix.translate(-d7[1],-d7[2])}}}else{if(d6[eb].indexOf("skewX")!==-1){this.matrix.skewX(parseFloat(d7[0]))}else{if(d6[eb].indexOf("skewY")!==-1){this.matrix.skewY(d7[0])}else{if(d6[eb].indexOf("shearX")!==-1){this.matrix.shearX(d7[0])}else{if(d6[eb].indexOf("shearY")!==-1){this.matrix.shearY(d7[0])}}}}}}}}}return this.matrix}}();cm.prototype.parseChildren=function(ea){var d6=ea.getChildren();var d9=new cR.PShape;for(var d8=0,d7=d6.length;d8<d7;d8++){var d5=this.parseChild(d6[d8]);if(d5){d9.addChild(d5)}}this.children.push(d9)};cm.prototype.getName=function(){return this.name};cm.prototype.parseChild=function(d7){var d6=d7.getName();var d5;if(d6==="g"){d5=new cm(this,d7)}else{if(d6==="defs"){d5=new cm(this,d7)}else{if(d6==="line"){d5=new cm(this,d7);d5.parseLine()}else{if(d6==="circle"){d5=new cm(this,d7);d5.parseEllipse(true)}else{if(d6==="ellipse"){d5=new cm(this,d7);d5.parseEllipse(false)}else{if(d6==="rect"){d5=new cm(this,d7);d5.parseRect()}else{if(d6==="polygon"){d5=new cm(this,d7);d5.parsePoly(true)}else{if(d6==="polyline"){d5=new cm(this,d7);d5.parsePoly(false)}else{if(d6==="path"){d5=new cm(this,d7);d5.parsePath()}else{if(d6==="radialGradient"){dr("PShapeSVG.prototype.parseChild, name = radialGradient")}else{if(d6==="linearGradient"){dr("PShapeSVG.prototype.parseChild, name = linearGradient")}else{if(d6==="text"){dr("PShapeSVG.prototype.parseChild, name = text")}else{if(d6==="filter"){dr("PShapeSVG.prototype.parseChild, name = filter")}else{if(d6==="mask"){dr("PShapeSVG.prototype.parseChild, name = mask")}else{i()}}}}}}}}}}}}}}return d5};cm.prototype.parsePath=function(){this.family=21;this.kind=0;var ea=[];var eu;var et=cR.trim(this.element.getStringAttribute("d").replace(/[\s,]+/g," "));if(et===null){return}et=cR.__toCharArray(et);var d8=0,d7=0,ef=0,ed=0,ee=0,ec=0,el=0,ek=0,d6=0,d5=0,eh=0,eg=0,ej=0,ei=0,es=0,eo=0;var em="";var eq=[];var er=false;var eb;var d9;var ep,en;while(es<et.length){eo=et[es].valueOf();if(eo>=65&&eo<=90||eo>=97&&eo<=122){ep=es;es++;if(es<et.length){eq=[];eo=et[es].valueOf();while(!(eo>=65&&eo<=90||eo>=97&&eo<=100||eo>=102&&eo<=122)&&er===false){if(eo===32){if(em!==""){eq.push(parseFloat(em));em=""}es++}else{if(eo===45){if(et[es-1].valueOf()===101){em+=et[es].toString();es++}else{if(em!==""){eq.push(parseFloat(em))}em=et[es].toString();es++}}else{em+=et[es].toString();es++}}if(es===et.length){er=true}else{eo=et[es].valueOf()}}}if(em!==""){eq.push(parseFloat(em));em=""}d9=et[ep];eo=d9.valueOf();if(eo===77){if(eq.length>=2&&eq.length%2===0){d8=eq[0];d7=eq[1];this.parsePathMoveto(d8,d7);if(eq.length>2){for(ep=2,en=eq.length;ep<en;ep+=2){d8=eq[ep];d7=eq[ep+1];this.parsePathLineto(d8,d7)}}}}else{if(eo===109){if(eq.length>=2&&eq.length%2===0){d8+=eq[0];d7+=eq[1];this.parsePathMoveto(d8,d7);if(eq.length>2){for(ep=2,en=eq.length;ep<en;ep+=2){d8+=eq[ep];d7+=eq[ep+1];this.parsePathLineto(d8,d7)}}}}else{if(eo===76){if(eq.length>=2&&eq.length%2===0){for(ep=0,en=eq.length;ep<en;ep+=2){d8=eq[ep];d7=eq[ep+1];this.parsePathLineto(d8,d7)}}}else{if(eo===108){if(eq.length>=2&&eq.length%2===0){for(ep=0,en=eq.length;ep<en;ep+=2){d8+=eq[ep];d7+=eq[ep+1];this.parsePathLineto(d8,d7)}}}else{if(eo===72){for(ep=0,en=eq.length;ep<en;ep++){d8=eq[ep];this.parsePathLineto(d8,d7)}}else{if(eo===104){for(ep=0,en=eq.length;ep<en;ep++){d8+=eq[ep];this.parsePathLineto(d8,d7)}}else{if(eo===86){for(ep=0,en=eq.length;ep<en;ep++){d7=eq[ep];this.parsePathLineto(d8,d7)}}else{if(eo===118){for(ep=0,en=eq.length;ep<en;ep++){d7+=eq[ep];this.parsePathLineto(d8,d7)}}else{if(eo===67){if(eq.length>=6&&eq.length%6===0){for(ep=0,en=eq.length;ep<en;ep+=6){ee=eq[ep];el=eq[ep+1];ec=eq[ep+2];ek=eq[ep+3];d6=eq[ep+4];d5=eq[ep+5];this.parsePathCurveto(ee,el,ec,ek,d6,d5);d8=d6;d7=d5}}}else{if(eo===99){if(eq.length>=6&&eq.length%6===0){for(ep=0,en=eq.length;ep<en;ep+=6){ee=d8+eq[ep];el=d7+eq[ep+1];ec=d8+eq[ep+2];ek=d7+eq[ep+3];d6=d8+eq[ep+4];d5=d7+eq[ep+5];this.parsePathCurveto(ee,el,ec,ek,d6,d5);d8=d6;d7=d5}}}else{if(eo===83){if(eq.length>=4&&eq.length%4===0){for(ep=0,en=eq.length;ep<en;ep+=4){if(eb.toLowerCase()==="c"||eb.toLowerCase()==="s"){eh=this.vertices[this.vertices.length-2][0];eg=this.vertices[this.vertices.length-2][1];ej=this.vertices[this.vertices.length-1][0];ei=this.vertices[this.vertices.length-1][1];ee=ej+(ej-eh);el=ei+(ei-eg)}else{ee=this.vertices[this.vertices.length-1][0];el=this.vertices[this.vertices.length-1][1]}ec=eq[ep];ek=eq[ep+1];d6=eq[ep+2];d5=eq[ep+3];this.parsePathCurveto(ee,el,ec,ek,d6,d5);d8=d6;d7=d5}}}else{if(eo===115){if(eq.length>=4&&eq.length%4===0){for(ep=0,en=eq.length;ep<en;ep+=4){if(eb.toLowerCase()==="c"||eb.toLowerCase()==="s"){eh=this.vertices[this.vertices.length-2][0];eg=this.vertices[this.vertices.length-2][1];ej=this.vertices[this.vertices.length-1][0];ei=this.vertices[this.vertices.length-1][1];ee=ej+(ej-eh);el=ei+(ei-eg)}else{ee=this.vertices[this.vertices.length-1][0];el=this.vertices[this.vertices.length-1][1]}ec=d8+eq[ep];ek=d7+eq[ep+1];d6=d8+eq[ep+2];d5=d7+eq[ep+3];this.parsePathCurveto(ee,el,ec,ek,d6,d5);d8=d6;d7=d5}}}else{if(eo===81){if(eq.length>=4&&eq.length%4===0){for(ep=0,en=eq.length;ep<en;ep+=4){ef=eq[ep];ed=eq[ep+1];d6=eq[ep+2];d5=eq[ep+3];this.parsePathQuadto(d8,d7,ef,ed,d6,d5);d8=d6;d7=d5}}}else{if(eo===113){if(eq.length>=4&&eq.length%4===0){for(ep=0,en=eq.length;ep<en;ep+=4){ef=d8+eq[ep];ed=d7+eq[ep+1];d6=d8+eq[ep+2];d5=d7+eq[ep+3];this.parsePathQuadto(d8,d7,ef,ed,d6,d5);d8=d6;d7=d5}}}else{if(eo===84){if(eq.length>=2&&eq.length%2===0){for(ep=0,en=eq.length;ep<en;ep+=2){if(eb.toLowerCase()==="q"||eb.toLowerCase()==="t"){eh=this.vertices[this.vertices.length-2][0];eg=this.vertices[this.vertices.length-2][1];ej=this.vertices[this.vertices.length-1][0];ei=this.vertices[this.vertices.length-1][1];ef=ej+(ej-eh);ed=ei+(ei-eg)}else{ef=d8;ed=d7}d6=eq[ep];d5=eq[ep+1];this.parsePathQuadto(d8,d7,ef,ed,d6,d5);d8=d6;d7=d5}}}else{if(eo===116){if(eq.length>=2&&eq.length%2===0){for(ep=0,en=eq.length;ep<en;ep+=2){if(eb.toLowerCase()==="q"||eb.toLowerCase()==="t"){eh=this.vertices[this.vertices.length-2][0];eg=this.vertices[this.vertices.length-2][1];ej=this.vertices[this.vertices.length-1][0];ei=this.vertices[this.vertices.length-1][1];ef=ej+(ej-eh);ed=ei+(ei-eg)}else{ef=d8;ed=d7}d6=d8+eq[ep];d5=d7+eq[ep+1];this.parsePathQuadto(d8,d7,ef,ed,d6,d5);d8=d6;d7=d5}}}else{if(eo===90||eo===122){this.close=true}}}}}}}}}}}}}}}}}eb=d9.toString()}else{es++}}};cm.prototype.parsePathQuadto=function(d7,d9,d5,ea,d6,d8){if(this.vertices.length>0){this.parsePathCode(1);this.parsePathVertex(d7+(d5-d7)*2/3,d9+(ea-d9)*2/3);this.parsePathVertex(d6+(d5-d6)*2/3,d8+(ea-d8)*2/3);this.parsePathVertex(d6,d8)}else{throw"Path must start with M/m"}};cm.prototype.parsePathCurveto=function(d8,ea,d6,d9,d5,d7){if(this.vertices.length>0){this.parsePathCode(1);this.parsePathVertex(d8,ea);this.parsePathVertex(d6,d9);this.parsePathVertex(d5,d7)}else{throw"Path must start with M/m"}};cm.prototype.parsePathLineto=function(d6,d5){if(this.vertices.length>0){this.parsePathCode(0);this.parsePathVertex(d6,d5);this.vertices[this.vertices.length-1]["moveTo"]=false}else{throw"Path must start with M/m"}};cm.prototype.parsePathMoveto=function(d6,d5){if(this.vertices.length>0){this.parsePathCode(3)}this.parsePathCode(0);this.parsePathVertex(d6,d5);this.vertices[this.vertices.length-1]["moveTo"]=true};cm.prototype.parsePathVertex=function(d5,d7){var d6=[];d6[0]=d5;d6[1]=d7;this.vertices.push(d6)};cm.prototype.parsePathCode=function(d5){this.vertexCodes.push(d5)};cm.prototype.parsePoly=function(d9){this.family=21;this.close=d9;var d6=cR.trim(this.element.getStringAttribute("points").replace(/[,\s]+/g," "));if(d6!==null){var d5=d6.split(" ");if(d5.length%2===0){for(var d8=0,d7=d5.length;d8<d7;d8++){var ea=[];ea[0]=d5[d8];ea[1]=d5[++d8];this.vertices.push(ea)}}else{throw"Error parsing polygon points: odd number of coordinates provided"}}};cm.prototype.parseRect=function(){this.kind=30;this.family=1;this.params=[];this.params[0]=this.element.getFloatAttribute("x");this.params[1]=this.element.getFloatAttribute("y");this.params[2]=this.element.getFloatAttribute("width");this.params[3]=this.element.getFloatAttribute("height");if(this.params[2]<0||this.params[3]<0){throw"svg error: negative width or height found while parsing <rect>"}};cm.prototype.parseEllipse=function(d7){this.kind=31;this.family=1;this.params=[];this.params[0]=this.element.getFloatAttribute("cx")|0;this.params[1]=this.element.getFloatAttribute("cy")|0;var d6,d5;if(d7){d6=d5=this.element.getFloatAttribute("r");if(d6<0){throw"svg error: negative radius found while parsing <circle>"}}else{d6=this.element.getFloatAttribute("rx");d5=this.element.getFloatAttribute("ry");if(d6<0||d5<0){throw"svg error: negative x-axis radius or y-axis radius found while parsing <ellipse>"}}this.params[0]-=d6;this.params[1]-=d5;this.params[2]=d6*2;this.params[3]=d5*2};cm.prototype.parseLine=function(){this.kind=4;this.family=1;this.params=[];this.params[0]=this.element.getFloatAttribute("x1");this.params[1]=this.element.getFloatAttribute("y1");this.params[2]=this.element.getFloatAttribute("x2");this.params[3]=this.element.getFloatAttribute("y2")};cm.prototype.parseColors=function(d7){if(d7.hasAttribute("opacity")){this.setOpacity(d7.getAttribute("opacity"))}if(d7.hasAttribute("stroke")){this.setStroke(d7.getAttribute("stroke"))}if(d7.hasAttribute("stroke-width")){this.setStrokeWeight(d7.getAttribute("stroke-width"))}if(d7.hasAttribute("stroke-linejoin")){this.setStrokeJoin(d7.getAttribute("stroke-linejoin"))}if(d7.hasAttribute("stroke-linecap")){this.setStrokeCap(d7.getStringAttribute("stroke-linecap"))}if(d7.hasAttribute("fill")){this.setFill(d7.getStringAttribute("fill"))}if(d7.hasAttribute("style")){var ea=d7.getStringAttribute("style");var d8=ea.toString().split(";");for(var d6=0,d5=d8.length;d6<d5;d6++){var d9=cR.trim(d8[d6].split(":"));if(d9[0]==="fill"){this.setFill(d9[1])}else{if(d9[0]==="fill-opacity"){this.setFillOpacity(d9[1])}else{if(d9[0]==="stroke"){this.setStroke(d9[1])}else{if(d9[0]==="stroke-width"){this.setStrokeWeight(d9[1])}else{if(d9[0]==="stroke-linecap"){this.setStrokeCap(d9[1])}else{if(d9[0]==="stroke-linejoin"){this.setStrokeJoin(d9[1])}else{if(d9[0]==="stroke-opacity"){this.setStrokeOpacity(d9[1])}else{if(d9[0]==="opacity"){this.setOpacity(d9[1])}}}}}}}}}}};cm.prototype.setFillOpacity=function(d5){this.fillOpacity=parseFloat(d5);this.fillColor=this.fillOpacity*255<<24|this.fillColor&16777215};cm.prototype.setFill=function(d5){var d6=this.fillColor&4278190080;if(d5==="none"){this.fill=false}else{if(d5.indexOf("#")===0){this.fill=true;if(d5.length===4){d5=d5.replace(/#(.)(.)(.)/,"#$1$1$2$2$3$3")}this.fillColor=d6|parseInt(d5.substring(1),16)&16777215}else{if(d5.indexOf("rgb")===0){this.fill=true;this.fillColor=d6|this.parseRGB(d5)}else{if(d5.indexOf("url(#")===0){this.fillName=d5.substring(5,d5.length-1)}else{if(q[d5]){this.fill=true;this.fillColor=d6|parseInt(q[d5].substring(1),16)&16777215}}}}}};cm.prototype.setOpacity=function(d5){this.strokeColor=parseFloat(d5)*255<<24|this.strokeColor&16777215;this.fillColor=parseFloat(d5)*255<<24|this.fillColor&16777215};cm.prototype.setStroke=function(d5){var d6=this.strokeColor&4278190080;if(d5==="none"){this.stroke=false}else{if(d5.charAt(0)==="#"){this.stroke=true;if(d5.length===4){d5=d5.replace(/#(.)(.)(.)/,"#$1$1$2$2$3$3")}this.strokeColor=d6|parseInt(d5.substring(1),16)&16777215}else{if(d5.indexOf("rgb")===0){this.stroke=true;this.strokeColor=d6|this.parseRGB(d5)}else{if(d5.indexOf("url(#")===0){this.strokeName=d5.substring(5,d5.length-1)}else{if(q[d5]){this.stroke=true;this.strokeColor=d6|parseInt(q[d5].substring(1),16)&16777215}}}}}};cm.prototype.setStrokeWeight=function(d5){this.strokeWeight=this.parseUnitSize(d5)};cm.prototype.setStrokeJoin=function(d5){if(d5==="miter"){this.strokeJoin="miter"}else{if(d5==="round"){this.strokeJoin="round"}else{if(d5==="bevel"){this.strokeJoin="bevel"}}}};cm.prototype.setStrokeCap=function(d5){if(d5==="butt"){this.strokeCap="butt"}else{if(d5==="round"){this.strokeCap="round"}else{if(d5==="square"){this.strokeCap="square"}}}};cm.prototype.setStrokeOpacity=function(d5){this.strokeOpacity=parseFloat(d5);this.strokeColor=this.strokeOpacity*255<<24|this.strokeColor&16777215};cm.prototype.parseRGB=function(d6){var d7=d6.substring(d6.indexOf("(")+1,d6.indexOf(")"));var d5=d7.split(", ");return d5[0]<<16|d5[1]<<8|d5[2]};cm.prototype.parseUnitSize=function(d6){var d5=d6.length-2;if(d5<0){return d6}if(d6.indexOf("pt")===d5){return parseFloat(d6.substring(0,d5))*1.25}if(d6.indexOf("pc")===d5){return parseFloat(d6.substring(0,d5))*15}if(d6.indexOf("mm")===d5){return parseFloat(d6.substring(0,d5))*3.543307}if(d6.indexOf("cm")===d5){return parseFloat(d6.substring(0,d5))*35.43307}if(d6.indexOf("in")===d5){return parseFloat(d6.substring(0,d5))*90}if(d6.indexOf("px")===d5){return parseFloat(d6.substring(0,d5))}return parseFloat(d6)};cR.shape=function(d7,d6,d9,d8,d5){if(arguments.length>=1&&arguments[0]!==null){if(d7.isVisible()){cR.pushMatrix();if(N===3){if(arguments.length===5){cR.translate(d6-d8/2,d9-d5/2);cR.scale(d8/d7.getWidth(),d5/d7.getHeight())}else{if(arguments.length===3){cR.translate(d6-d7.getWidth()/2,-d7.getHeight()/2)}else{cR.translate(-d7.getWidth()/2,-d7.getHeight()/2)}}}else{if(N===0){if(arguments.length===5){cR.translate(d6,d9);cR.scale(d8/d7.getWidth(),d5/d7.getHeight())}else{if(arguments.length===3){cR.translate(d6,d9)}}}else{if(N===1){if(arguments.length===5){d8-=d6;d5-=d9;cR.translate(d6,d9);cR.scale(d8/d7.getWidth(),d5/d7.getHeight())}else{if(arguments.length===3){cR.translate(d6,d9)}}}}}d7.draw(cR);if(arguments.length===1&&N===3||arguments.length>1){cR.popMatrix()}}}};cR.shapeMode=function(d5){N=d5};cR.loadShape=function(d5){if(arguments.length===1){if(d5.indexOf(".svg")>-1){return new cm(null,d5)}}return null};var cO=function(d9,d8,d5,d6,d7){this.fullName=d9||"";this.name=d8||"";this.namespace=d5||"";this.value=d6;this.type=d7};cO.prototype={getName:function(){return this.name},getFullName:function(){return this.fullName},getNamespace:function(){return this.namespace},getValue:function(){return this.value},getType:function(){return this.type},setValue:function(d5){this.value=d5}};var b4=cR.XMLElement=function(d5,d7,d8,d6){this.attributes=[];this.children=[];this.fullName=null;this.name=null;this.namespace="";this.content=null;this.parent=null;this.lineNr="";this.systemID="";this.type="ELEMENT";if(d5){if(typeof d5==="string"){if(d7===d&&d5.indexOf("<")>-1){this.parse(d5)}else{this.fullName=d5;this.namespace=d7;this.systemId=d8;this.lineNr=d6}}else{this.parse(d7)}}};b4.prototype={parse:function(d5){var d7;try{var d9=d5.substring(d5.length-4);if(d9===".xml"||d9===".svg"){d5=s(d5)}d7=(new DOMParser).parseFromString(d5,"text/xml");var d6=d7.documentElement;if(d6){this.parseChildrenRecursive(null,d6)}else{throw"Error loading document"}return this}catch(d8){throw d8}},parseChildrenRecursive:function(ed,eb){var ea,d6,ec,d9,d8,d5;if(!ed){this.fullName=eb.localName;this.name=eb.nodeName;ea=this}else{ea=new b4(eb.nodeName);ea.parent=ed}if(eb.nodeType===3&&eb.textContent!==""){return this.createPCDataElement(eb.textContent)}if(eb.nodeType===4){return this.createCDataElement(eb.textContent)}if(eb.attributes){for(d9=0,d8=eb.attributes.length;d9<d8;d9++){ec=eb.attributes[d9];d6=new cO(ec.getname,ec.nodeName,ec.namespaceURI,ec.nodeValue,ec.nodeType);ea.attributes.push(d6)}}if(eb.childNodes){for(d9=0,d8=eb.childNodes.length;d9<d8;d9++){var d7=eb.childNodes[d9];d5=ea.parseChildrenRecursive(ea,d7);if(d5!==null){ea.children.push(d5)}}}return ea},createElement:function(d6,d7,d8,d5){if(d8===d){return new b4(d6,d7)}return new b4(d6,d7,d8,d5)},createPCDataElement:function(d6,d5){if(d6.replace(/^\s+$/g,"")===""){return null}var d7=new b4;d7.type="TEXT";d7.content=d6;return d7},createCDataElement:function(d7){var d8=this.createPCDataElement(d7);if(d8===null){return null}d8.type="CDATA";var d6={"<":"&lt;",">":"&gt;","'":"&apos;",'"':"&quot;"},d5;for(d5 in d6){if(!Object.hasOwnProperty(d6,d5)){d7=d7.replace(new RegExp(d5,"g"),d6[d5])}}d8.cdata=d7;return d8},hasAttribute:function(){if(arguments.length===1){return this.getAttribute(arguments[0])!==null}if(arguments.length===2){return this.getAttribute(arguments[0],arguments[1])!==null}},equals:function(ea){if(!(ea instanceof b4)){return false}var d7,d6;if(this.fullName!==ea.fullName){return false}if(this.attributes.length!==ea.getAttributeCount()){return false}if(this.attributes.length!==ea.attributes.length){return false}var ee,ec,d5,eb,ed;for(d7=0,d6=this.attributes.length;d7<d6;d7++){ee=this.attributes[d7].getName();ec=this.attributes[d7].getNamespace();ed=ea.findAttribute(ee,ec);if(ed===null){return false}if(this.attributes[d7].getValue()!==ed.getValue()){return false}if(this.attributes[d7].getType()!==ed.getType()){return false}}if(this.children.length!==ea.getChildCount()){return false}if(this.children.length>0){var d9,d8;for(d7=0,d6=this.children.length;d7<d6;d7++){d9=this.getChild(d7);d8=ea.getChild(d7);if(!d9.equals(d8)){return false}}return true}return this.content===ea.content},getContent:function(){if(this.type==="TEXT"||this.type==="CDATA"){return this.content}var d5=this.children;if(d5.length===1&&(d5[0].type==="TEXT"||d5[0].type==="CDATA")){return d5[0].content}return null},getAttribute:function(){var d5;if(arguments.length===2){d5=this.findAttribute(arguments[0]);if(d5){return d5.getValue()}return arguments[1]}else{if(arguments.length===1){d5=this.findAttribute(arguments[0]);if(d5){return d5.getValue()}return null}else{if(arguments.length===3){d5=this.findAttribute(arguments[0],arguments[1]);if(d5){return d5.getValue()}return arguments[2]}}}},getStringAttribute:function(){if(arguments.length===1){return this.getAttribute(arguments[0])}if(arguments.length===2){return this.getAttribute(arguments[0],arguments[1])}return this.getAttribute(arguments[0],arguments[1],arguments[2])},getString:function(d5){return this.getStringAttribute(d5)},getFloatAttribute:function(){if(arguments.length===1){return parseFloat(this.getAttribute(arguments[0],0))}if(arguments.length===2){return this.getAttribute(arguments[0],arguments[1])}return this.getAttribute(arguments[0],arguments[1],arguments[2])},getFloat:function(d5){return this.getFloatAttribute(d5)},getIntAttribute:function(){if(arguments.length===1){return this.getAttribute(arguments[0],0)}if(arguments.length===2){return this.getAttribute(arguments[0],arguments[1])}return this.getAttribute(arguments[0],arguments[1],arguments[2])},getInt:function(d5){return this.getIntAttribute(d5)},hasChildren:function(){return this.children.length>0},addChild:function(d5){if(d5!==null){d5.parent=this;this.children.push(d5)}},insertChild:function(d7,d5){if(d7){if(d7.getLocalName()===null&&!this.hasChildren()){var d6=this.children[this.children.length-1];if(d6.getLocalName()===null){d6.setContent(d6.getContent()+d7.getContent());return}}d7.parent=this;this.children.splice(d5,0,d7)}},getChild:function(d6){if(typeof d6==="number"){return this.children[d6]}if(d6.indexOf("/")!==-1){return this.getChildRecursive(d6.split("/"),0)}var d5,d9;for(var d8=0,d7=this.getChildCount();d8<d7;d8++){d5=this.getChild(d8);d9=d5.getName();if(d9!==null&&d9===d6){return d5}}return null},getChildren:function(){if(arguments.length===1){if(typeof arguments[0]==="number"){return this.getChild(arguments[0])}if(arguments[0].indexOf("/")!==-1){return this.getChildrenRecursive(arguments[0].split("/"),0)}var d9=[];var d5,d8;for(var d7=0,d6=this.getChildCount();d7<d6;d7++){d5=this.getChild(d7);d8=d5.getName();if(d8!==null&&d8===arguments[0]){d9.push(d5)}}return d9}return this.children},getChildCount:function(){return this.children.length},getChildRecursive:function(d6,eb){if(eb===d6.length){return this}var d5,ea,d9=d6[eb];for(var d8=0,d7=this.getChildCount();d8<d7;d8++){d5=this.getChild(d8);ea=d5.getName();if(ea!==null&&ea===d9){return d5.getChildRecursive(d6,eb+1)}}return null},getChildrenRecursive:function(d5,d9){if(d9===d5.length-1){return this.getChildren(d5[d9])}var d8=this.getChildren(d5[d9]);var d7=[];for(var d6=0;d6<d8.length;d6++){d7=d7.concat(d8[d6].getChildrenRecursive(d5,d9+1))}return d7},isLeaf:function(){return !this.hasChildren()},listChildren:function(){var d5=[];for(var d7=0,d6=this.children.length;d7<d6;d7++){d5.push(this.getChild(d7).getName())}return d5},removeAttribute:function(d6,d8){this.namespace=d8||"";for(var d7=0,d5=this.attributes.length;d7<d5;d7++){if(this.attributes[d7].getName()===d6&&this.attributes[d7].getNamespace()===this.namespace){this.attributes.splice(d7,1);break}}},removeChild:function(d7){if(d7){for(var d6=0,d5=this.children.length;d6<d5;d6++){if(this.children[d6].equals(d7)){this.children.splice(d6,1);break}}}},removeChildAtIndex:function(d5){if(this.children.length>d5){this.children.splice(d5,1)}},findAttribute:function(d6,d8){this.namespace=d8||"";for(var d7=0,d5=this.attributes.length;d7<d5;d7++){if(this.attributes[d7].getName()===d6&&this.attributes[d7].getNamespace()===this.namespace){return this.attributes[d7]}}return null},setAttribute:function(){var d5;if(arguments.length===3){var d7=arguments[0].indexOf(":");var d6=arguments[0].substring(d7+1);d5=this.findAttribute(d6,arguments[1]);if(d5){d5.setValue(arguments[2])}else{d5=new cO(arguments[0],d6,arguments[1],arguments[2],"CDATA");this.attributes.push(d5)}}else{d5=this.findAttribute(arguments[0]);if(d5){d5.setValue(arguments[1])}else{d5=new cO(arguments[0],arguments[0],null,arguments[1],"CDATA");this.attributes.push(d5)}}},setString:function(d5,d6){this.setAttribute(d5,d6)},setInt:function(d5,d6){this.setAttribute(d5,d6)},setFloat:function(d5,d6){this.setAttribute(d5,d6)},setContent:function(d5){if(this.children.length>0){D.debug("Tried to set content for XMLElement with children")}this.content=d5},setName:function(){if(arguments.length===1){this.name=arguments[0];this.fullName=arguments[0];this.namespace=null}else{var d5=arguments[0].indexOf(":");if(arguments[1]===null||d5<0){this.name=arguments[0]}else{this.name=arguments[0].substring(d5+1)}this.fullName=arguments[0];this.namespace=arguments[1]}},getName:function(){return this.fullName},getLocalName:function(){return this.name},getAttributeCount:function(){return this.attributes.length},toString:function(){if(this.type==="TEXT"){return this.content}if(this.type==="CDATA"){return this.cdata}var d7=this.fullName;var d8="<"+d7;var d6,d9;for(d6=0;d6<this.attributes.length;d6++){var d5=this.attributes[d6];d8+=" "+d5.getName()+'="'+d5.getValue()+'"'}if(this.children.length===0){if(this.content===""){d8+="/>"}else{d8+=">"+this.content+"</"+d7+">"}}else{d8+=">";for(d9=0;d9<this.children.length;d9++){d8+=this.children[d9].toString()}d8+="</"+d7+">"}return d8}};b4.parse=function(d6){var d5=new b4;d5.parse(d6);return d5};var db=cR.XML=cR.XMLElement;cR.loadXML=function(d5){return new db(cR,d5)};var ch=function(d8){var d5=0;for(var d6=0;d6<d8.length;d6++){if(d6!==0){d5=p.max(d5,p.abs(d8[d6]))}else{d5=p.abs(d8[d6])}}var d7=(d5+"").indexOf(".");if(d7===0){d7=1}else{if(d7===-1){d7=(d5+"").length}}return d7};var aS=cR.PMatrix2D=function(){if(arguments.length===0){this.reset()}else{if(arguments.length===1&&arguments[0] instanceof aS){this.set(arguments[0].array())}else{if(arguments.length===6){this.set(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5])}}}};aS.prototype={set:function(){if(arguments.length===6){var d5=arguments;this.set([d5[0],d5[1],d5[2],d5[3],d5[4],d5[5]])}else{if(arguments.length===1&&arguments[0] instanceof aS){this.elements=arguments[0].array()}else{if(arguments.length===1&&arguments[0] instanceof Array){this.elements=arguments[0].slice()}}}},get:function(){var d5=new aS;d5.set(this.elements);return d5},reset:function(){this.set([1,0,0,0,1,0])},array:function az(){return this.elements.slice()},translate:function(d6,d5){this.elements[2]=d6*this.elements[0]+d5*this.elements[1]+this.elements[2];this.elements[5]=d6*this.elements[3]+d5*this.elements[4]+this.elements[5]},invTranslate:function(d6,d5){this.translate(-d6,-d5)},transpose:function(){},mult:function(d6,d7){var d5,d8;if(d6 instanceof l){d5=d6.x;d8=d6.y;if(!d7){d7=new l}}else{if(d6 instanceof Array){d5=d6[0];d8=d6[1];if(!d7){d7=[]}}}if(d7 instanceof Array){d7[0]=this.elements[0]*d5+this.elements[1]*d8+this.elements[2];d7[1]=this.elements[3]*d5+this.elements[4]*d8+this.elements[5]}else{if(d7 instanceof l){d7.x=this.elements[0]*d5+this.elements[1]*d8+this.elements[2];d7.y=this.elements[3]*d5+this.elements[4]*d8+this.elements[5];d7.z=0}}return d7},multX:function(d5,d6){return d5*this.elements[0]+d6*this.elements[1]+this.elements[2]},multY:function(d5,d6){return d5*this.elements[3]+d6*this.elements[4]+this.elements[5]},skewX:function(d5){this.apply(1,0,1,d5,0,0)},skewY:function(d5){this.apply(1,0,1,0,d5,0)},shearX:function(d5){this.apply(1,0,1,p.tan(d5),0,0)},shearY:function(d5){this.apply(1,0,1,0,p.tan(d5),0)},determinant:function(){return this.elements[0]*this.elements[4]-this.elements[1]*this.elements[3]},invert:function(){var ea=this.determinant();if(p.abs(ea)>-2147483648){var d6=this.elements[0];var eb=this.elements[1];var d9=this.elements[2];var d8=this.elements[3];var d7=this.elements[4];var d5=this.elements[5];this.elements[0]=d7/ea;this.elements[3]=-d8/ea;this.elements[1]=-eb/ea;this.elements[4]=d6/ea;this.elements[2]=(eb*d5-d7*d9)/ea;this.elements[5]=(d8*d9-d6*d5)/ea;return true}return false},scale:function(d6,d5){if(d6&&!d5){d5=d6}if(d6&&d5){this.elements[0]*=d6;this.elements[1]*=d5;this.elements[3]*=d6;this.elements[4]*=d5}},invScale:function(d6,d5){if(d6&&!d5){d5=d6}this.scale(1/d6,1/d5)},apply:function(){var d7;if(arguments.length===1&&arguments[0] instanceof aS){d7=arguments[0].array()}else{if(arguments.length===6){d7=Array.prototype.slice.call(arguments)}else{if(arguments.length===1&&arguments[0] instanceof Array){d7=arguments[0]}}}var d5=[0,0,this.elements[2],0,0,this.elements[5]];var d8=0;for(var d9=0;d9<2;d9++){for(var d6=0;d6<3;d6++,d8++){d5[d8]+=this.elements[d9*3+0]*d7[d6+0]+this.elements[d9*3+1]*d7[d6+3]}}this.elements=d5.slice()},preApply:function(){var d6;if(arguments.length===1&&arguments[0] instanceof aS){d6=arguments[0].array()}else{if(arguments.length===6){d6=Array.prototype.slice.call(arguments)}else{if(arguments.length===1&&arguments[0] instanceof Array){d6=arguments[0]}}}var d5=[0,0,d6[2],0,0,d6[5]];d5[2]=d6[2]+this.elements[2]*d6[0]+this.elements[5]*d6[1];d5[5]=d6[5]+this.elements[2]*d6[3]+this.elements[5]*d6[4];d5[0]=this.elements[0]*d6[0]+this.elements[3]*d6[1];d5[3]=this.elements[0]*d6[3]+this.elements[3]*d6[4];d5[1]=this.elements[1]*d6[0]+this.elements[4]*d6[1];d5[4]=this.elements[1]*d6[3]+this.elements[4]*d6[4];this.elements=d5.slice()},rotate:function(d7){var d9=p.cos(d7);var d5=p.sin(d7);var d8=this.elements[0];var d6=this.elements[1];this.elements[0]=d9*d8+d5*d6;this.elements[1]=-d5*d8+d9*d6;d8=this.elements[3];d6=this.elements[4];this.elements[3]=d9*d8+d5*d6;this.elements[4]=-d5*d8+d9*d6},rotateZ:function(d5){this.rotate(d5)},invRotateZ:function(d5){this.rotateZ(d5-p.PI)},print:function(){var d6=ch(this.elements);var d5=""+cR.nfs(this.elements[0],d6,4)+" "+cR.nfs(this.elements[1],d6,4)+" "+cR.nfs(this.elements[2],d6,4)+"\n"+cR.nfs(this.elements[3],d6,4)+" "+cR.nfs(this.elements[4],d6,4)+" "+cR.nfs(this.elements[5],d6,4)+"\n\n";cR.println(d5)}};var aK=cR.PMatrix3D=function(){this.reset()};aK.prototype={set:function(){if(arguments.length===16){this.elements=Array.prototype.slice.call(arguments)}else{if(arguments.length===1&&arguments[0] instanceof aK){this.elements=arguments[0].array()}else{if(arguments.length===1&&arguments[0] instanceof Array){this.elements=arguments[0].slice()}}}},get:function(){var d5=new aK;d5.set(this.elements);return d5},reset:function(){this.elements=[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]},array:function az(){return this.elements.slice()},translate:function(d6,d5,d7){if(d7===d){d7=0}this.elements[3]+=d6*this.elements[0]+d5*this.elements[1]+d7*this.elements[2];this.elements[7]+=d6*this.elements[4]+d5*this.elements[5]+d7*this.elements[6];this.elements[11]+=d6*this.elements[8]+d5*this.elements[9]+d7*this.elements[10];this.elements[15]+=d6*this.elements[12]+d5*this.elements[13]+d7*this.elements[14]},transpose:function(){var d5=this.elements[4];this.elements[4]=this.elements[1];this.elements[1]=d5;d5=this.elements[8];this.elements[8]=this.elements[2];this.elements[2]=d5;d5=this.elements[6];this.elements[6]=this.elements[9];this.elements[9]=d5;d5=this.elements[3];this.elements[3]=this.elements[12];this.elements[12]=d5;d5=this.elements[7];this.elements[7]=this.elements[13];this.elements[13]=d5;d5=this.elements[11];this.elements[11]=this.elements[14];this.elements[14]=d5},mult:function(d7,d8){var d5,ea,d9,d6;if(d7 instanceof l){d5=d7.x;ea=d7.y;d9=d7.z;d6=1;if(!d8){d8=new l}}else{if(d7 instanceof Array){d5=d7[0];ea=d7[1];d9=d7[2];d6=d7[3]||1;if(!d8||d8.length!==3&&d8.length!==4){d8=[0,0,0]}}}if(d8 instanceof Array){if(d8.length===3){d8[0]=this.elements[0]*d5+this.elements[1]*ea+this.elements[2]*d9+this.elements[3];d8[1]=this.elements[4]*d5+this.elements[5]*ea+this.elements[6]*d9+this.elements[7];d8[2]=this.elements[8]*d5+this.elements[9]*ea+this.elements[10]*d9+this.elements[11]}else{if(d8.length===4){d8[0]=this.elements[0]*d5+this.elements[1]*ea+this.elements[2]*d9+this.elements[3]*d6;d8[1]=this.elements[4]*d5+this.elements[5]*ea+this.elements[6]*d9+this.elements[7]*d6;d8[2]=this.elements[8]*d5+this.elements[9]*ea+this.elements[10]*d9+this.elements[11]*d6;d8[3]=this.elements[12]*d5+this.elements[13]*ea+this.elements[14]*d9+this.elements[15]*d6}}}if(d8 instanceof l){d8.x=this.elements[0]*d5+this.elements[1]*ea+this.elements[2]*d9+this.elements[3];d8.y=this.elements[4]*d5+this.elements[5]*ea+this.elements[6]*d9+this.elements[7];d8.z=this.elements[8]*d5+this.elements[9]*ea+this.elements[10]*d9+this.elements[11]}return d8},preApply:function(){var d7;if(arguments.length===1&&arguments[0] instanceof aK){d7=arguments[0].array()}else{if(arguments.length===16){d7=Array.prototype.slice.call(arguments)}else{if(arguments.length===1&&arguments[0] instanceof Array){d7=arguments[0]}}}var d5=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var d8=0;for(var d9=0;d9<4;d9++){for(var d6=0;d6<4;d6++,d8++){d5[d8]+=this.elements[d6+0]*d7[d9*4+0]+this.elements[d6+4]*d7[d9*4+1]+this.elements[d6+8]*d7[d9*4+2]+this.elements[d6+12]*d7[d9*4+3]}}this.elements=d5.slice()},apply:function(){var d7;if(arguments.length===1&&arguments[0] instanceof aK){d7=arguments[0].array()}else{if(arguments.length===16){d7=Array.prototype.slice.call(arguments)}else{if(arguments.length===1&&arguments[0] instanceof Array){d7=arguments[0]}}}var d5=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var d8=0;for(var d9=0;d9<4;d9++){for(var d6=0;d6<4;d6++,d8++){d5[d8]+=this.elements[d9*4+0]*d7[d6+0]+this.elements[d9*4+1]*d7[d6+4]+this.elements[d9*4+2]*d7[d6+8]+this.elements[d9*4+3]*d7[d6+12]}}this.elements=d5.slice()},rotate:function(d9,d5,eb,d8){if(!eb){this.rotateZ(d9)}else{var ea=cR.cos(d9);var d7=cR.sin(d9);var d6=1-ea;this.apply(d6*d5*d5+ea,d6*d5*eb-d7*d8,d6*d5*d8+d7*eb,0,d6*d5*eb+d7*d8,d6*eb*eb+ea,d6*eb*d8-d7*d5,0,d6*d5*d8-d7*eb,d6*eb*d8+d7*d5,d6*d8*d8+ea,0,0,0,0,1)}},invApply:function(){if(W===d){W=new aK}var d5=arguments;W.set(d5[0],d5[1],d5[2],d5[3],d5[4],d5[5],d5[6],d5[7],d5[8],d5[9],d5[10],d5[11],d5[12],d5[13],d5[14],d5[15]);if(!W.invert()){return false}this.preApply(W);return true},rotateX:function(d6){var d7=cR.cos(d6);var d5=cR.sin(d6);this.apply([1,0,0,0,0,d7,-d5,0,0,d5,d7,0,0,0,0,1])},rotateY:function(d6){var d7=cR.cos(d6);var d5=cR.sin(d6);this.apply([d7,0,d5,0,0,1,0,0,-d5,0,d7,0,0,0,0,1])},rotateZ:function(d6){var d7=p.cos(d6);var d5=p.sin(d6);this.apply([d7,-d5,0,0,d5,d7,0,0,0,0,1,0,0,0,0,1])},scale:function(d7,d6,d5){if(d7&&!d6&&!d5){d6=d5=d7}else{if(d7&&d6&&!d5){d5=1}}if(d7&&d6&&d5){this.elements[0]*=d7;this.elements[1]*=d6;this.elements[2]*=d5;this.elements[4]*=d7;this.elements[5]*=d6;this.elements[6]*=d5;this.elements[8]*=d7;this.elements[9]*=d6;this.elements[10]*=d5;this.elements[12]*=d7;this.elements[13]*=d6;this.elements[14]*=d5}},skewX:function(d6){var d5=p.tan(d6);this.apply(1,d5,0,0,0,1,0,0,0,0,1,0,0,0,0,1)},skewY:function(d6){var d5=p.tan(d6);this.apply(1,0,0,0,d5,1,0,0,0,0,1,0,0,0,0,1)},shearX:function(d6){var d5=p.tan(d6);this.apply(1,d5,0,0,0,1,0,0,0,0,1,0,0,0,0,1)},shearY:function(d6){var d5=p.tan(d6);this.apply(1,0,0,0,d5,1,0,0,0,0,1,0,0,0,0,1)},multX:function(d5,d8,d7,d6){if(!d7){return this.elements[0]*d5+this.elements[1]*d8+this.elements[3]}if(!d6){return this.elements[0]*d5+this.elements[1]*d8+this.elements[2]*d7+this.elements[3]}return this.elements[0]*d5+this.elements[1]*d8+this.elements[2]*d7+this.elements[3]*d6},multY:function(d5,d8,d7,d6){if(!d7){return this.elements[4]*d5+this.elements[5]*d8+this.elements[7]}if(!d6){return this.elements[4]*d5+this.elements[5]*d8+this.elements[6]*d7+this.elements[7]}return this.elements[4]*d5+this.elements[5]*d8+this.elements[6]*d7+this.elements[7]*d6},multZ:function(d5,d8,d7,d6){if(!d6){return this.elements[8]*d5+this.elements[9]*d8+this.elements[10]*d7+this.elements[11]}return this.elements[8]*d5+this.elements[9]*d8+this.elements[10]*d7+this.elements[11]*d6},multW:function(d5,d8,d7,d6){if(!d6){return this.elements[12]*d5+this.elements[13]*d8+this.elements[14]*d7+this.elements[15]}return this.elements[12]*d5+this.elements[13]*d8+this.elements[14]*d7+this.elements[15]*d6},invert:function(){var ee=this.elements[0]*this.elements[5]-this.elements[1]*this.elements[4];var ed=this.elements[0]*this.elements[6]-this.elements[2]*this.elements[4];var ec=this.elements[0]*this.elements[7]-this.elements[3]*this.elements[4];var eb=this.elements[1]*this.elements[6]-this.elements[2]*this.elements[5];var ea=this.elements[1]*this.elements[7]-this.elements[3]*this.elements[5];var d9=this.elements[2]*this.elements[7]-this.elements[3]*this.elements[6];var d8=this.elements[8]*this.elements[13]-this.elements[9]*this.elements[12];var d7=this.elements[8]*this.elements[14]-this.elements[10]*this.elements[12];var d6=this.elements[8]*this.elements[15]-this.elements[11]*this.elements[12];var ej=this.elements[9]*this.elements[14]-this.elements[10]*this.elements[13];var eh=this.elements[9]*this.elements[15]-this.elements[11]*this.elements[13];var eg=this.elements[10]*this.elements[15]-this.elements[11]*this.elements[14];var ei=ee*eg-ed*eh+ec*ej+eb*d6-ea*d7+d9*d8;if(p.abs(ei)<=1e-9){return false}var ef=[];ef[0]=+this.elements[5]*eg-this.elements[6]*eh+this.elements[7]*ej;ef[4]=-this.elements[4]*eg+this.elements[6]*d6-this.elements[7]*d7;ef[8]=+this.elements[4]*eh-this.elements[5]*d6+this.elements[7]*d8;ef[12]=-this.elements[4]*ej+this.elements[5]*d7-this.elements[6]*d8;ef[1]=-this.elements[1]*eg+this.elements[2]*eh-this.elements[3]*ej;ef[5]=+this.elements[0]*eg-this.elements[2]*d6+this.elements[3]*d7;ef[9]=-this.elements[0]*eh+this.elements[1]*d6-this.elements[3]*d8;ef[13]=+this.elements[0]*ej-this.elements[1]*d7+this.elements[2]*d8;ef[2]=+this.elements[13]*d9-this.elements[14]*ea+this.elements[15]*eb;ef[6]=-this.elements[12]*d9+this.elements[14]*ec-this.elements[15]*ed;ef[10]=+this.elements[12]*ea-this.elements[13]*ec+this.elements[15]*ee;ef[14]=-this.elements[12]*eb+this.elements[13]*ed-this.elements[14]*ee;ef[3]=-this.elements[9]*d9+this.elements[10]*ea-this.elements[11]*eb;ef[7]=+this.elements[8]*d9-this.elements[10]*ec+this.elements[11]*ed;ef[11]=-this.elements[8]*ea+this.elements[9]*ec-this.elements[11]*ee;ef[15]=+this.elements[8]*eb-this.elements[9]*ed+this.elements[10]*ee;var d5=1/ei;ef[0]*=d5;ef[1]*=d5;ef[2]*=d5;ef[3]*=d5;ef[4]*=d5;ef[5]*=d5;ef[6]*=d5;ef[7]*=d5;ef[8]*=d5;ef[9]*=d5;ef[10]*=d5;ef[11]*=d5;ef[12]*=d5;ef[13]*=d5;ef[14]*=d5;ef[15]*=d5;this.elements=ef.slice();return true},toString:function(){var d6="";for(var d5=0;d5<15;d5++){d6+=this.elements[d5]+", "}d6+=this.elements[15];return d6},print:function(){var d6=ch(this.elements);var d5=""+cR.nfs(this.elements[0],d6,4)+" "+cR.nfs(this.elements[1],d6,4)+" "+cR.nfs(this.elements[2],d6,4)+" "+cR.nfs(this.elements[3],d6,4)+"\n"+cR.nfs(this.elements[4],d6,4)+" "+cR.nfs(this.elements[5],d6,4)+" "+cR.nfs(this.elements[6],d6,4)+" "+cR.nfs(this.elements[7],d6,4)+"\n"+cR.nfs(this.elements[8],d6,4)+" "+cR.nfs(this.elements[9],d6,4)+" "+cR.nfs(this.elements[10],d6,4)+" "+cR.nfs(this.elements[11],d6,4)+"\n"+cR.nfs(this.elements[12],d6,4)+" "+cR.nfs(this.elements[13],d6,4)+" "+cR.nfs(this.elements[14],d6,4)+" "+cR.nfs(this.elements[15],d6,4)+"\n\n";cR.println(d5)},invTranslate:function(d6,d5,d7){this.preApply(1,0,0,-d6,0,1,0,-d5,0,0,1,-d7,0,0,0,1)},invRotateX:function(d6){var d7=p.cos(-d6);var d5=p.sin(-d6);this.preApply([1,0,0,0,0,d7,-d5,0,0,d5,d7,0,0,0,0,1])},invRotateY:function(d6){var d7=p.cos(-d6);var d5=p.sin(-d6);this.preApply([d7,0,d5,0,0,1,0,0,-d5,0,d7,0,0,0,0,1])},invRotateZ:function(d6){var d7=p.cos(-d6);var d5=p.sin(-d6);this.preApply([d7,-d5,0,0,d5,d7,0,0,0,0,1,0,0,0,0,1])},invScale:function(d5,d7,d6){this.preApply([1/d5,0,0,0,0,1/d7,0,0,0,0,1/d6,0,0,0,0,1])}};var Q=cR.PMatrixStack=function(){this.matrixStack=[]};Q.prototype.load=function(){var d5=dT.$newPMatrix();if(arguments.length===1){d5.set(arguments[0])}else{d5.set(arguments)}this.matrixStack.push(d5)};bM.prototype.$newPMatrix=function(){return new aS};bw.prototype.$newPMatrix=function(){return new aK};Q.prototype.push=function(){this.matrixStack.push(this.peek())};Q.prototype.pop=function(){return this.matrixStack.pop()};Q.prototype.peek=function(){var d5=dT.$newPMatrix();d5.set(this.matrixStack[this.matrixStack.length-1]);return d5};Q.prototype.mult=function(d5){this.matrixStack[this.matrixStack.length-1].apply(d5)};cR.split=function(d6,d5){return d6.split(d5)};cR.splitTokens=function(eb,ea){if(ea===d){return eb.split(/\s+/g)}var d8=ea.split(/()/g),d6="",d5=eb.length,d7,ec,d9=[];for(d7=0;d7<d5;d7++){ec=eb[d7];if(d8.indexOf(ec)>-1){if(d6!==""){d9.push(d6)}d6=""}else{d6+=ec}}if(d6!==""){d9.push(d6)}return d9};cR.append=function(d6,d5){d6[d6.length]=d5;return d6};cR.concat=function(d6,d5){return d6.concat(d5)};cR.sort=function(ea,d8){var d6=[];if(ea.length>0){var d9=d8>0?d8:ea.length;for(var d7=0;d7<d9;d7++){d6.push(ea[d7])}if(typeof ea[0]==="string"){d6.sort()}else{d6.sort(function(ec,eb){return ec-eb})}if(d8>0){for(var d5=d6.length;d5<ea.length;d5++){d6.push(ea[d5])}}}return d6};cR.splice=function(d9,d8,d6){if(d8.length===0){return d9}if(d8 instanceof Array){for(var d7=0,d5=d6;d7<d8.length;d5++,d7++){d9.splice(d5,0,d8[d7])}}else{d9.splice(d6,0,d8)}return d9};cR.subset=function(d8,d7,d6){var d5=d6!==d?d7+d6:d8.length;return d8.slice(d7,d5)};cR.join=function(d6,d5){return d6.join(d5)};cR.shorten=function(d8){var d6=[];var d5=d8.length;for(var d7=0;d7<d5;d7++){d6[d7]=d8[d7]}d6.pop();return d6};cR.expand=function(d7,d8){var d6=d7.slice(0),d5=d8||d7.length*2;d6.length=d5;return d6};cR.arrayCopy=function(){var eb,d9=0,d7,d6=0,ea;if(arguments.length===2){eb=arguments[0];d7=arguments[1];ea=eb.length}else{if(arguments.length===3){eb=arguments[0];d7=arguments[1];ea=arguments[2]}else{if(arguments.length===5){eb=arguments[0];d9=arguments[1];d7=arguments[2];d6=arguments[3];ea=arguments[4]}}}for(var d8=d9,d5=d6;d8<ea+d9;d8++,d5++){if(d7[d5]!==d){d7[d5]=eb[d8]}else{throw"array index out of bounds exception"}}};cR.reverse=function(d5){return d5.reverse()};cR.mix=function(d6,d5,d7){return d6+((d5-d6)*d7>>8)};cR.peg=function(d5){return d5<0?0:d5>255?255:d5};cR.modes=function(){var ea=4278190080,d7=16711680,d6=65280,d9=255,d8=p.min,d5=p.max;function eb(eg,ej,ef,eo,eq,ep,eh,el,ek,ed,ee){var en=d8(((eg&4278190080)>>>24)+ej,255)<<24;var ec=ef+((ek-ef)*ej>>8);ec=(ec<0?0:ec>255?255:ec)<<16;var ei=eo+((ed-eo)*ej>>8);ei=(ei<0?0:ei>255?255:ei)<<8;var em=eq+((ee-eq)*ej>>8);em=em<0?0:em>255?255:em;return en|ec|ei|em}return{replace:function(ed,ec){return ec},blend:function(ee,ed){var eg=(ed&ea)>>>24,ec=ee&d7,ei=ee&d6,ek=ee&d9,ej=ed&d7,ef=ed&d6,eh=ed&d9;return d8(((ee&ea)>>>24)+eg,255)<<24|ec+((ej-ec)*eg>>8)&d7|ei+((ef-ei)*eg>>8)&d6|ek+((eh-ek)*eg>>8)&d9},add:function(ed,ec){var ee=(ec&ea)>>>24;return d8(((ed&ea)>>>24)+ee,255)<<24|d8((ed&d7)+((ec&d7)>>8)*ee,d7)&d7|d8((ed&d6)+((ec&d6)>>8)*ee,d6)&d6|d8((ed&d9)+((ec&d9)*ee>>8),d9)},subtract:function(ed,ec){var ee=(ec&ea)>>>24;return d8(((ed&ea)>>>24)+ee,255)<<24|d5((ed&d7)-((ec&d7)>>8)*ee,d6)&d7|d5((ed&d6)-((ec&d6)>>8)*ee,d9)&d6|d5((ed&d9)-((ec&d9)*ee>>8),0)},lightest:function(ed,ec){var ee=(ec&ea)>>>24;return d8(((ed&ea)>>>24)+ee,255)<<24|d5(ed&d7,((ec&d7)>>8)*ee)&d7|d5(ed&d6,((ec&d6)>>8)*ee)&d6|d5(ed&d9,(ec&d9)*ee>>8)},darkest:function(ee,ed){var eg=(ed&ea)>>>24,ec=ee&d7,ei=ee&d6,ek=ee&d9,ej=d8(ee&d7,((ed&d7)>>8)*eg),ef=d8(ee&d6,((ed&d6)>>8)*eg),eh=d8(ee&d9,(ed&d9)*eg>>8);return d8(((ee&ea)>>>24)+eg,255)<<24|ec+((ej-ec)*eg>>8)&d7|ei+((ef-ei)*eg>>8)&d6|ek+((eh-ek)*eg>>8)&d9},difference:function(eg,ef){var ei=(ef&ea)>>>24,ee=(eg&d7)>>16,el=(eg&d6)>>8,en=eg&d9,em=(ef&d7)>>16,eh=(ef&d6)>>8,ek=ef&d9,ej=ee>em?ee-em:em-ee,ec=el>eh?el-eh:eh-el,ed=en>ek?en-ek:ek-en;return eb(eg,ei,ee,el,en,em,eh,ek,ej,ec,ed)},exclusion:function(eg,ef){var ei=(ef&ea)>>>24,ee=(eg&d7)>>16,el=(eg&d6)>>8,en=eg&d9,em=(ef&d7)>>16,eh=(ef&d6)>>8,ek=ef&d9,ej=ee+em-(ee*em>>7),ec=el+eh-(el*eh>>7),ed=en+ek-(en*ek>>7);return eb(eg,ei,ee,el,en,em,eh,ek,ej,ec,ed)},multiply:function(eg,ef){var ei=(ef&ea)>>>24,ee=(eg&d7)>>16,el=(eg&d6)>>8,en=eg&d9,em=(ef&d7)>>16,eh=(ef&d6)>>8,ek=ef&d9,ej=ee*em>>8,ec=el*eh>>8,ed=en*ek>>8;return eb(eg,ei,ee,el,en,em,eh,ek,ej,ec,ed)},screen:function(eg,ef){var ei=(ef&ea)>>>24,ee=(eg&d7)>>16,el=(eg&d6)>>8,en=eg&d9,em=(ef&d7)>>16,eh=(ef&d6)>>8,ek=ef&d9,ej=255-((255-ee)*(255-em)>>8),ec=255-((255-el)*(255-eh)>>8),ed=255-((255-en)*(255-ek)>>8);return eb(eg,ei,ee,el,en,em,eh,ek,ej,ec,ed)},hard_light:function(eg,ef){var ei=(ef&ea)>>>24,ee=(eg&d7)>>16,el=(eg&d6)>>8,en=eg&d9,em=(ef&d7)>>16,eh=(ef&d6)>>8,ek=ef&d9,ej=em<128?ee*em>>7:255-((255-ee)*(255-em)>>7),ec=eh<128?el*eh>>7:255-((255-el)*(255-eh)>>7),ed=ek<128?en*ek>>7:255-((255-en)*(255-ek)>>7);return eb(eg,ei,ee,el,en,em,eh,ek,ej,ec,ed)},soft_light:function(eg,ef){var ei=(ef&ea)>>>24,ee=(eg&d7)>>16,el=(eg&d6)>>8,en=eg&d9,em=(ef&d7)>>16,eh=(ef&d6)>>8,ek=ef&d9,ej=(ee*em>>7)+(ee*ee>>8)-(ee*ee*em>>15),ec=(el*eh>>7)+(el*el>>8)-(el*el*eh>>15),ed=(en*ek>>7)+(en*en>>8)-(en*en*ek>>15);return eb(eg,ei,ee,el,en,em,eh,ek,ej,ec,ed)},overlay:function(eg,ef){var ei=(ef&ea)>>>24,ee=(eg&d7)>>16,el=(eg&d6)>>8,en=eg&d9,em=(ef&d7)>>16,eh=(ef&d6)>>8,ek=ef&d9,ej=ee<128?ee*em>>7:255-((255-ee)*(255-em)>>7),ec=el<128?el*eh>>7:255-((255-el)*(255-eh)>>7),ed=en<128?en*ek>>7:255-((255-en)*(255-ek)>>7);return eb(eg,ei,ee,el,en,em,eh,ek,ej,ec,ed)},dodge:function(eg,ef){var ei=(ef&ea)>>>24,ee=(eg&d7)>>16,el=(eg&d6)>>8,en=eg&d9,em=(ef&d7)>>16,eh=(ef&d6)>>8,ek=ef&d9;var ej=255;if(em!==255){ej=(ee<<8)/(255-em);ej=ej<0?0:ej>255?255:ej}var ec=255;if(eh!==255){ec=(el<<8)/(255-eh);ec=ec<0?0:ec>255?255:ec}var ed=255;if(ek!==255){ed=(en<<8)/(255-ek);ed=ed<0?0:ed>255?255:ed}return eb(eg,ei,ee,el,en,em,eh,ek,ej,ec,ed)},burn:function(eg,ef){var ei=(ef&ea)>>>24,ee=(eg&d7)>>16,el=(eg&d6)>>8,en=eg&d9,em=(ef&d7)>>16,eh=(ef&d6)>>8,ek=ef&d9;var ej=0;if(em!==0){ej=(255-ee<<8)/em;ej=255-(ej<0?0:ej>255?255:ej)}var ec=0;if(eh!==0){ec=(255-el<<8)/eh;ec=255-(ec<0?0:ec>255?255:ec)}var ed=0;if(ek!==0){ed=(255-en<<8)/ek;ed=255-(ed<0?0:ed>255?255:ed)}return eb(eg,ei,ee,el,en,em,eh,ek,ej,ec,ed)}}}();function dC(ea,d9,d7,d6){var d5,d8,ec,ed;if(cT===3){var eb=cR.color.toRGB(ea,d9,d7);d5=eb[0];d8=eb[1];ec=eb[2]}else{d5=p.round(255*(ea/bE));d8=p.round(255*(d9/bD));ec=p.round(255*(d7/bB))}ed=p.round(255*(d6/bP));d5=d5<0?0:d5;d8=d8<0?0:d8;ec=ec<0?0:ec;ed=ed<0?0:ed;d5=d5>255?255:d5;d8=d8>255?255:d8;ec=ec>255?255:ec;ed=ed>255?255:ed;return ed<<24&4278190080|d5<<16&16711680|d8<<8&65280|ec&255}function dF(d5,d7){var d6;if(d5&4278190080){d6=p.round(255*(d7/bP));d6=d6>255?255:d6;d6=d6<0?0:d6;return d5-(d5&4278190080)+(d6<<24&4278190080)}if(cT===1){return dC(d5,d5,d5,d7)}if(cT===3){return dC(0,0,d5/bE*bB,d7)}}function dH(d5){if(d5<=bE&&d5>=0){if(cT===1){return dC(d5,d5,d5,bP)}if(cT===3){return dC(0,0,d5/bE*bB,bP)}}if(d5){if(d5>2147483647){d5-=4294967296}return d5}}cR.color=function(d5,d8,d7,d6){if(d5!==d&&d8!==d&&d7!==d&&d6!==d){return dC(d5,d8,d7,d6)}if(d5!==d&&d8!==d&&d7!==d){return dC(d5,d8,d7,bP)}if(d5!==d&&d8!==d){return dF(d5,d8)}if(typeof d5==="number"){return dH(d5)}return dC(bE,bD,bB,bP)};cR.color.toString=function(d5){return"rgba("+(d5>>16&255)+","+(d5>>8&255)+","+(d5&255)+","+(d5>>24&255)/255+")"};cR.color.toInt=function(d8,d7,d5,d6){return d6<<24&4278190080|d8<<16&16711680|d7<<8&65280|d5&255};cR.color.toArray=function(d5){return[d5>>16&255,d5>>8&255,d5&255,d5>>24&255]};cR.color.toGLArray=function(d5){return[(d5>>16&255)/255,(d5>>8&255)/255,(d5&255)/255,(d5>>24&255)/255]};cR.color.toRGB=function(d7,ed,ea){d7=d7>bE?bE:d7;ed=ed>bD?bD:ed;ea=ea>bB?bB:ea;d7=d7/bE*360;ed=ed/bD*100;ea=ea/bB*100;var ec=p.round(ea/100*255);if(ed===0){return[ec,ec,ec]}var d8=d7%360;var d9=d8%60;var d6=p.round(ea*(100-ed)/10000*255);var d5=p.round(ea*(6000-ed*d9)/600000*255);var eb=p.round(ea*(6000-ed*(60-d9))/600000*255);switch(p.floor(d8/60)){case 0:return[ec,eb,d6];case 1:return[d5,ec,d6];case 2:return[d6,ec,eb];case 3:return[d6,d5,ec];case 4:return[eb,d6,ec];case 5:return[ec,d6,d5]}};function aN(ec){var eb,ea,d6;eb=(ec>>16&255)/255;ea=(ec>>8&255)/255;d6=(ec&255)/255;var d5=cR.max(cR.max(eb,ea),d6),d8=cR.min(cR.min(eb,ea),d6),d7,d9;if(d8===d5){return[0,0,d5*bB]}d9=(d5-d8)/d5;if(eb===d5){d7=(ea-d6)/(d5-d8)}else{if(ea===d5){d7=2+(d6-eb)/(d5-d8)}else{d7=4+(eb-ea)/(d5-d8)}}d7/=6;if(d7<0){d7+=1}else{if(d7>1){d7-=1}}return[d7*bE,d9*bD,d5*bB]}cR.brightness=function(d5){return aN(d5)[2]};cR.saturation=function(d5){return aN(d5)[1]};cR.hue=function(d5){return aN(d5)[0]};cR.red=function(d5){return(d5>>16&255)/255*bE};cR.green=function(d5){return(d5>>8&255)/255*bD};cR.blue=function(d5){return(d5&255)/255*bB};cR.alpha=function(d5){return(d5>>24&255)/255*bP};cR.lerpColor=function(eh,eg,ea){var ef,el,em,en,ej,d5,eb,ep,ei,eq,d9,eo;var ed,ec,d6,ek,ee;var d8=cR.color(eh);var d7=cR.color(eg);if(cT===3){ed=aN(d8);ep=(d8>>24&255)/bP;ec=aN(d7);eo=(d7>>24&255)/bP;ek=cR.lerp(ed[0],ec[0],ea);ee=cR.lerp(ed[1],ec[1],ea);em=cR.lerp(ed[2],ec[2],ea);d6=cR.color.toRGB(ek,ee,em);en=cR.lerp(ep,eo,ea)*bP;return en<<24&4278190080|(d6[0]&255)<<16|(d6[1]&255)<<8|d6[2]&255}ej=d8>>16&255;d5=d8>>8&255;eb=d8&255;ep=(d8>>24&255)/bP;ei=d7>>16&255;eq=d7>>8&255;d9=d7&255;eo=(d7>>24&255)/bP;ef=cR.lerp(ej,ei,ea)|0;el=cR.lerp(d5,eq,ea)|0;em=cR.lerp(eb,d9,ea)|0;en=cR.lerp(ep,eo,ea)*bP;return en<<24&4278190080|ef<<16&16711680|el<<8&65280|em&255};cR.colorMode=function(){cT=arguments[0];if(arguments.length>1){bE=arguments[1];bD=arguments[2]||arguments[1];bB=arguments[3]||arguments[1];bP=arguments[4]||arguments[1]}};cR.blendColor=function(d6,d5,d7){if(d7===0){return cR.modes.replace(d6,d5)}else{if(d7===1){return cR.modes.blend(d6,d5)}else{if(d7===2){return cR.modes.add(d6,d5)}else{if(d7===4){return cR.modes.subtract(d6,d5)}else{if(d7===8){return cR.modes.lightest(d6,d5)}else{if(d7===16){return cR.modes.darkest(d6,d5)}else{if(d7===32){return cR.modes.difference(d6,d5)}else{if(d7===64){return cR.modes.exclusion(d6,d5)}else{if(d7===128){return cR.modes.multiply(d6,d5)}else{if(d7===256){return cR.modes.screen(d6,d5)}else{if(d7===1024){return cR.modes.hard_light(d6,d5)}else{if(d7===2048){return cR.modes.soft_light(d6,d5)}else{if(d7===512){return cR.modes.overlay(d6,d5)}else{if(d7===4096){return cR.modes.dodge(d6,d5)}else{if(d7===8192){return cR.modes.burn(d6,d5)}}}}}}}}}}}}}}}};function ay(){d3.save()}function cK(){d3.restore();bY=true;al=true}cR.printMatrix=function(){dE.print()};bM.prototype.translate=function(d5,d6){dE.translate(d5,d6);aO.invTranslate(d5,d6);d3.translate(d5,d6)};bw.prototype.translate=function(d5,d7,d6){dE.translate(d5,d7,d6);aO.invTranslate(d5,d7,d6)};bM.prototype.scale=function(d5,d6){dE.scale(d5,d6);aO.invScale(d5,d6);d3.scale(d5,d6||d5)};bw.prototype.scale=function(d5,d7,d6){dE.scale(d5,d7,d6);aO.invScale(d5,d7,d6)};bM.prototype.transform=function(d6){var d5=d6.array();d3.transform(d5[0],d5[3],d5[1],d5[4],d5[2],d5[5])};bw.prototype.transformm=function(d5){throw"p.transform is currently not supported in 3D mode"};bM.prototype.pushMatrix=function(){ah.load(dE);c5.load(aO);ay()};bw.prototype.pushMatrix=function(){ah.load(dE);c5.load(aO)};bM.prototype.popMatrix=function(){dE.set(ah.pop());aO.set(c5.pop());cK()};bw.prototype.popMatrix=function(){dE.set(ah.pop());aO.set(c5.pop())};bM.prototype.resetMatrix=function(){dE.reset();aO.reset();d3.setTransform(1,0,0,1,0,0)};bw.prototype.resetMatrix=function(){dE.reset();aO.reset()};dm.prototype.applyMatrix=function(){var d5=arguments;dE.apply(d5[0],d5[1],d5[2],d5[3],d5[4],d5[5],d5[6],d5[7],d5[8],d5[9],d5[10],d5[11],d5[12],d5[13],d5[14],d5[15]);aO.invApply(d5[0],d5[1],d5[2],d5[3],d5[4],d5[5],d5[6],d5[7],d5[8],d5[9],d5[10],d5[11],d5[12],d5[13],d5[14],d5[15])};bM.prototype.applyMatrix=function(){var d5=arguments;for(var d6=d5.length;d6<16;d6++){d5[d6]=0}d5[10]=d5[15]=1;dm.prototype.applyMatrix.apply(this,d5)};cR.rotateX=function(d5){dE.rotateX(d5);aO.invRotateX(d5)};bM.prototype.rotateZ=function(){throw"rotateZ() is not supported in 2D mode. Use rotate(float) instead."};bw.prototype.rotateZ=function(d5){dE.rotateZ(d5);aO.invRotateZ(d5)};cR.rotateY=function(d5){dE.rotateY(d5);aO.invRotateY(d5)};bM.prototype.rotate=function(d5){dE.rotateZ(d5);aO.invRotateZ(d5);d3.rotate(d5)};bw.prototype.rotate=function(d5){cR.rotateZ(d5)};bM.prototype.shearX=function(d5){dE.shearX(d5);d3.transform(1,0,d5,1,0,0)};bw.prototype.shearX=function(d5){dE.shearX(d5)};bM.prototype.shearY=function(d5){dE.shearY(d5);d3.transform(1,d5,0,1,0,0)};bw.prototype.shearY=function(d5){dE.shearY(d5)};cR.pushStyle=function(){ay();cR.pushMatrix();var d5={doFill:aC,currentFillColor:aW,doStroke:b9,currentStrokeColor:cq,curTint:ba,curRectMode:bF,curColorMode:cT,colorModeX:bE,colorModeZ:bB,colorModeY:bD,colorModeA:bP,curTextFont:R,horizontalTextAlignment:I,verticalTextAlignment:cW,textMode:cD,curFontName:T,curTextSize:dV,curTextAscent:aY,curTextDescent:dv,curTextLeading:d2};bh.push(d5)};cR.popStyle=function(){var d5=bh.pop();if(d5){cK();cR.popMatrix();aC=d5.doFill;aW=d5.currentFillColor;b9=d5.doStroke;cq=d5.currentStrokeColor;ba=d5.curTint;bF=d5.curRectMode;cT=d5.curColorMode;bE=d5.colorModeX;bB=d5.colorModeZ;bD=d5.colorModeY;bP=d5.colorModeA;R=d5.curTextFont;T=d5.curFontName;dV=d5.curTextSize;I=d5.horizontalTextAlignment;cW=d5.verticalTextAlignment;cD=d5.textMode;aY=d5.curTextAscent;dv=d5.curTextDescent;d2=d5.curTextLeading}else{throw"Too many popStyle() without enough pushStyle()"}};cR.year=function(){return(new Date).getFullYear()};cR.month=function(){return(new Date).getMonth()+1};cR.day=function(){return(new Date).getDate()};cR.hour=function(){return(new Date).getHours()};cR.minute=function(){return(new Date).getMinutes()};cR.second=function(){return(new Date).getSeconds()};cR.millis=function(){return Date.now()-dk};function co(){var d5=(Date.now()-dn)/1000;K++;var d6=K/d5;if(d5>0.5){dn=Date.now();K=0;cR.__frameRate=d6}cR.frameCount++}bM.prototype.redraw=function(){co();d3.lineWidth=dR;var d5=cR.pmouseX,d6=cR.pmouseY;cR.pmouseX=dI;cR.pmouseY=d0;ay();cR.draw();cK();dI=cR.mouseX;d0=cR.mouseY;cR.pmouseX=d5;cR.pmouseY=d6};bw.prototype.redraw=function(){co();var d5=cR.pmouseX,d6=cR.pmouseY;cR.pmouseX=dI;cR.pmouseY=d0;d3.clear(d3.DEPTH_BUFFER_BIT);dx={attributes:{},locations:{}};cR.noLights();cR.lightFalloff(1,0,0);cR.shininess(1);cR.ambient(255,255,255);cR.specular(0,0,0);cR.emissive(0,0,0);cR.camera();cR.draw();dI=cR.mouseX;d0=cR.mouseY;cR.pmouseX=d5;cR.pmouseY=d6};cR.noLoop=function(){ax=false;ar=false;clearInterval(bZ);cL.onPause()};cR.loop=function(){if(ar){return}dn=Date.now();K=0;bZ=m.setInterval(function(){try{cL.onFrameStart();cR.redraw();cL.onFrameEnd()}catch(d5){m.clearInterval(bZ);throw d5}},au);ax=true;ar=true;cL.onLoop()};cR.frameRate=function(d5){dP=d5;au=1000/dP;if(ax){cR.noLoop();cR.loop()}};var ao=[];function bJ(d7,d6,d5){if(d7.addEventListener){d7.addEventListener(d6,d5,false)}else{d7.attachEvent("on"+d6,d5)}ao.push({elem:d7,type:d6,fn:d5})}function c9(d5){var d8=d5.elem,d7=d5.type,d6=d5.fn;if(d8.removeEventListener){d8.removeEventListener(d7,d6,false)}else{if(d8.detachEvent){d8.detachEvent("on"+d7,d6)}}}cR.exit=function(){m.clearInterval(bZ);F(cR.externals.canvas.id);delete Z.onmousedown;for(var d6 in D.lib){if(D.lib.hasOwnProperty(d6)){if(D.lib[d6].hasOwnProperty("detach")){D.lib[d6].detach(cR)}}}var d5=ao.length;while(d5--){c9(ao[d5])}cL.onExit()};cR.cursor=function(){if(arguments.length>1||arguments.length===1&&arguments[0] instanceof cR.PImage){var d8=arguments[0],d5,ea;if(arguments.length>=3){d5=arguments[1];ea=arguments[2];if(d5<0||ea<0||ea>=d8.height||d5>=d8.width){throw"x and y must be non-negative and less than the dimensions of the image"}}else{d5=d8.width>>>1;ea=d8.height>>>1}var d6=d8.toDataURL();var d7='url("'+d6+'") '+d5+" "+ea+", default";U=Z.style.cursor=d7}else{if(arguments.length===1){var d9=arguments[0];U=Z.style.cursor=d9}else{U=Z.style.cursor=cf}}};cR.noCursor=function(){U=Z.style.cursor=k.NOCURSOR};cR.link=function(d5,d6){if(d6!==d){m.open(d5,d6)}else{m.location=d5}};cR.beginDraw=i;cR.endDraw=i;bM.prototype.toImageData=function(d5,d8,d6,d7){d5=d5!==d?d5:0;d8=d8!==d?d8:0;d6=d6!==d?d6:cR.width;d7=d7!==d?d7:cR.height;return d3.getImageData(d5,d8,d6,d7)};bw.prototype.toImageData=function(ed,ec,ee,d9){ed=ed!==d?ed:0;ec=ec!==d?ec:0;ee=ee!==d?ee:cR.width;d9=d9!==d?d9:cR.height;var eb=v.createElement("canvas"),ef=eb.getContext("2d"),d8=ef.createImageData(ee,d9),d6=new r(ee*d9*4);d3.readPixels(ed,ec,ee,d9,d3.RGBA,d3.UNSIGNED_BYTE,d6);for(var d7=0,ea=d6.length,d5=d8.data;d7<ea;d7++){d5[d7]=d6[(d9-1-p.floor(d7/4/ee))*ee*4+d7%(ee*4)]}return d8};cR.status=function(d5){m.status=d5};cR.binary=function(d6,d7){var d8;if(d7>0){d8=d7}else{if(d6 instanceof bK){d8=16;d6|=0}else{d8=32;while(d8>1&&!(d6>>>d8-1&1)){d8--}}}var d5="";while(d8>0){d5+=d6>>>--d8&1?"1":"0"}return d5};cR.unbinary=function(d6){var d8=d6.length-1,d7=1,d5=0;while(d8>=0){var d9=d6[d8--];if(d9!=="0"&&d9!=="1"){throw"the value passed into unbinary was not an 8 bit binary number"}if(d9==="1"){d5+=d7}d7<<=1}return d5};function cS(eh,ef,d9,ek,eb,ei){var d7=eh<0?d9:ef;var d6=eb===0;var eg=eb===d||eb<0?0:eb;var ee=p.abs(eh);if(d6){eg=1;ee*=10;while(p.abs(p.round(ee)-ee)>0.000001&&eg<7){++eg;ee*=10}}else{if(eg!==0){ee*=p.pow(10,eg)}}var d8,ed=ee*2;if(p.floor(ee)===ee){d8=ee}else{if(p.floor(ed)===ed){var d5=p.floor(ee);d8=d5+d5%2}else{d8=p.round(ee)}}var ea="";var ej=ek+eg;while(ej>0||d8>0){ej--;ea=""+d8%10+ea;d8=p.floor(d8/10)}if(ei!==d){var ec=ea.length-3-eg;while(ec>0){ea=ea.substring(0,ec)+ei+ea.substring(ec);ec-=3}}if(eg>0){return d7+ea.substring(0,ea.length-eg)+"."+ea.substring(ea.length-eg,ea.length)}return d7+ea}function aj(eb,ea,d5,ed,d6,ec){if(eb instanceof Array){var d8=[];for(var d7=0,d9=eb.length;d7<d9;d7++){d8.push(cS(eb[d7],ea,d5,ed,d6,ec))}return d8}return cS(eb,ea,d5,ed,d6,ec)}cR.nf=function(d7,d5,d6){return aj(d7,"","-",d5,d6)};cR.nfs=function(d7,d5,d6){return aj(d7," ","-",d5,d6)};cR.nfp=function(d7,d5,d6){return aj(d7,"+","-",d5,d6)};cR.nfc=function(d7,d5,d6){return aj(d7,"","-",d5,d6,",")};var aH=function(d7,d6){d6=d6===d||d6===null?d6=8:d6;if(d7<0){d7=4294967295+d7+1}var d5=Number(d7).toString(16).toUpperCase();while(d5.length<d6){d5="0"+d5}if(d5.length>=d6){d5=d5.substring(d5.length-d6,d5.length)}return d5};cR.hex=function(d6,d5){if(arguments.length===1){if(d6 instanceof bK){d5=4}else{d5=8}}return aH(d6,d5)};function dA(d5){var d6=parseInt("0x"+d5,16);if(d6>2147483647){d6-=4294967296}return d6}cR.unhex=function(d7){if(d7 instanceof Array){var d5=[];for(var d6=0;d6<d7.length;d6++){d5.push(dA(d7[d6]))}return d5}return dA(d7)};cR.loadStrings=function(d6){if(localStorage[d6]){return localStorage[d6].split("\n")}var d5=s(d6);if(typeof d5!=="string"||d5===""){return[]}d5=d5.replace(/(\r\n?)/g,"\n").replace(/\n$/,"");return d5.split("\n")};cR.saveStrings=function(d6,d5){localStorage[d6]=d5.join("\n")};cR.loadBytes=function(d7){var d6=s(d7);var d5=[];for(var d8=0;d8<d6.length;d8++){d5.push(d6.charCodeAt(d8))}return d5};function a7(d5){return Array.prototype.slice.call(d5,1)}cR.matchAll=function(d6,d5){var d8=[],d7;var d9=new RegExp(d5,"g");while((d7=d9.exec(d6))!==null){d8.push(d7);if(d7[0].length===0){++d9.lastIndex}}return d8.length>0?d8:null};cR.__contains=function(d6,d5){if(typeof d6!=="string"){return d6.contains.apply(d6,a7(arguments))}return d6!==null&&d5!==null&&typeof d5==="string"&&d6.indexOf(d5)>-1};cR.__replaceAll=function(d5,d7,d6){if(typeof d5!=="string"){return d5.replaceAll.apply(d5,a7(arguments))}return d5.replace(new RegExp(d7,"g"),d6)};cR.__replaceFirst=function(d5,d7,d6){if(typeof d5!=="string"){return d5.replaceFirst.apply(d5,a7(arguments))}return d5.replace(new RegExp(d7,""),d6)};cR.__replace=function(d8,ea,d9){if(typeof d8!=="string"){return d8.replace.apply(d8,a7(arguments))}if(ea instanceof RegExp){return d8.replace(ea,d9)}if(typeof ea!=="string"){ea=ea.toString()}if(ea===""){return d8}var d7=d8.indexOf(ea);if(d7<0){return d8}var d6=0,d5="";do{d5+=d8.substring(d6,d7)+d9;d6=d7+ea.length}while((d7=d8.indexOf(ea,d6))>=0);return d5+d8.substring(d6)};cR.__equals=function(d6,d5){if(d6.equals instanceof Function){return d6.equals.apply(d6,a7(arguments))}return d6.valueOf()===d5.valueOf()};cR.__equalsIgnoreCase=function(d6,d5){if(typeof d6!=="string"){return d6.equalsIgnoreCase.apply(d6,a7(arguments))}return d6.toLowerCase()===d5.toLowerCase()};cR.__toCharArray=function(d7){if(typeof d7!=="string"){return d7.toCharArray.apply(d7,a7(arguments))}var d8=[];for(var d6=0,d5=d7.length;d6<d5;++d6){d8[d6]=new bK(d7.charAt(d6))}return d8};cR.__split=function(d8,d9,d6){if(typeof d8!=="string"){return d8.split.apply(d8,a7(arguments))}var eb=new RegExp(d9);if(d6===d||d6<1){return d8.split(eb)}var d5=[],ea=d8,ec;while((ec=ea.search(eb))!==-1&&d5.length<d6-1){var d7=eb.exec(ea).toString();d5.push(ea.substring(0,ec));ea=ea.substring(ec+d7.length)}if(ec!==-1||ea!==""){d5.push(ea)}return d5};cR.__codePointAt=function(d8,d6){var d9=d8.charCodeAt(d6),d7,d5;if(55296<=d9&&d9<=56319){d7=d9;d5=d8.charCodeAt(d6+1);return(d7-55296)*1024+(d5-56320)+65536}return d9};cR.match=function(d6,d5){return d6.match(d5)};cR.__matches=function(d6,d5){return(new RegExp(d5)).test(d6)};cR.__startsWith=function(d5,d7,d6){if(typeof d5!=="string"){return d5.startsWith.apply(d5,a7(arguments))}d6=d6||0;if(d6<0||d6>d5.length){return false}return d7===""||d7===d5?true:d5.indexOf(d7)===d6};cR.__endsWith=function(d6,d7){if(typeof d6!=="string"){return d6.endsWith.apply(d6,a7(arguments))}var d5=d7?d7.length:0;return d7===""||d7===d6?true:d6.indexOf(d7)===d6.length-d5};cR.__hashCode=function(d5){if(d5.hashCode instanceof Function){return d5.hashCode.apply(d5,a7(arguments))}return b(d5)};cR.__printStackTrace=function(d5){cR.println("Exception: "+d5.toString())};var d4=[];cR.println=function(d5){var d6=d4.length;if(d6){D.logger.log(d4.join(""));d4.length=0}if(arguments.length===0&&d6===0){D.logger.log("")}else{if(arguments.length!==0){D.logger.log(d5)}}};cR.print=function(d5){d4.push(d5)};cR.str=function(d7){if(d7 instanceof Array){var d5=[];for(var d6=0;d6<d7.length;d6++){d5.push(d7[d6].toString()+"")}return d5}return d7.toString()+""};cR.trim=function(d7){if(d7 instanceof Array){var d5=[];for(var d6=0;d6<d7.length;d6++){d5.push(d7[d6].replace(/^\s*/,"").replace(/\s*$/,"").replace(/\r*$/,""))}return d5}return d7.replace(/^\s*/,"").replace(/\s*$/,"").replace(/\r*$/,"")};function aM(d5){if(typeof d5==="number"){return d5!==0}if(typeof d5==="boolean"){return d5}if(typeof d5==="string"){return d5.toLowerCase()==="true"}if(d5 instanceof bK){return d5.code===49||d5.code===84||d5.code===116}}cR.parseBoolean=function(d7){if(d7 instanceof Array){var d5=[];for(var d6=0;d6<d7.length;d6++){d5.push(aM(d7[d6]))}return d5}return aM(d7)};cR.parseByte=function(d7){if(d7 instanceof Array){var d5=[];for(var d6=0;d6<d7.length;d6++){d5.push(0-(d7[d6]&128)|d7[d6]&127)}return d5}return 0-(d7&128)|d7&127};cR.parseChar=function(d7){if(typeof d7==="number"){return new bK(String.fromCharCode(d7&65535))}if(d7 instanceof Array){var d5=[];for(var d6=0;d6<d7.length;d6++){d5.push(new bK(String.fromCharCode(d7[d6]&65535)))}return d5}throw"char() may receive only one argument of type int, byte, int[], or byte[]."};function cJ(d5){if(typeof d5==="number"){return d5}if(typeof d5==="boolean"){return d5?1:0}if(typeof d5==="string"){return parseFloat(d5)}if(d5 instanceof bK){return d5.code}}cR.parseFloat=function(d7){if(d7 instanceof Array){var d5=[];for(var d6=0;d6<d7.length;d6++){d5.push(cJ(d7[d6]))}return d5}return cJ(d7)};function ag(d7,d5){if(typeof d7==="number"){return d7&4294967295}if(typeof d7==="boolean"){return d7?1:0}if(typeof d7==="string"){var d6=parseInt(d7,d5||10);return d6&4294967295}if(d7 instanceof bK){return d7.code}}cR.parseInt=function(d8,d7){if(d8 instanceof Array){var d5=[];for(var d6=0;d6<d8.length;d6++){if(typeof d8[d6]==="string"&&!/^\s*[+\-]?\d+\s*$/.test(d8[d6])){d5.push(0)}else{d5.push(ag(d8[d6],d7))}}return d5}return ag(d8,d7)};cR.__int_cast=function(d5){return 0|d5};cR.__instanceof=function(d7,d6){if(typeof d6!=="function"){throw"Function is expected as type argument for instanceof operator"}if(typeof d7==="string"){return d6===Object||d6===String}if(d7 instanceof d6){return true}if(typeof d7!=="object"||d7===null){return false}var d9=d7.constructor;if(d6.$isInterface){var d8=[];while(d9){if(d9.$interfaces){d8=d8.concat(d9.$interfaces)}d9=d9.$base}while(d8.length>0){var d5=d8.shift();if(d5===d6){return true}if(d5.$interfaces){d8=d8.concat(d5.$interfaces)}}return false}while(d9.hasOwnProperty("$base")){d9=d9.$base;if(d9===d6){return true}}return false};cR.abs=p.abs;cR.ceil=p.ceil;cR.constrain=function(d6,d7,d5){return d6>d5?d5:d6<d7?d7:d6};cR.dist=function(){var d7,d6,d5;if(arguments.length===4){d7=arguments[0]-arguments[2];d6=arguments[1]-arguments[3];return p.sqrt(d7*d7+d6*d6)}if(arguments.length===6){d7=arguments[0]-arguments[3];d6=arguments[1]-arguments[4];d5=arguments[2]-arguments[5];return p.sqrt(d7*d7+d6*d6+d5*d5)}};cR.exp=p.exp;cR.floor=p.floor;cR.lerp=function(d6,d5,d7){return(d5-d6)*d7+d6};cR.log=p.log;cR.mag=function(d6,d5,d7){if(d7){return p.sqrt(d6*d6+d5*d5+d7*d7)}return p.sqrt(d6*d6+d5*d5)};cR.map=function(d8,d6,d7,d5,d9){return d5+(d9-d5)*((d8-d6)/(d7-d6))};cR.max=function(){if(arguments.length===2){return arguments[0]<arguments[1]?arguments[1]:arguments[0]}var d6=arguments.length===1?arguments[0]:arguments;if(!("length" in d6&&d6.length>0)){throw"Non-empty array is expected"}var d5=d6[0],d8=d6.length;for(var d7=1;d7<d8;++d7){if(d5<d6[d7]){d5=d6[d7]}}return d5};cR.min=function(){if(arguments.length===2){return arguments[0]<arguments[1]?arguments[0]:arguments[1]}var d5=arguments.length===1?arguments[0]:arguments;if(!("length" in d5&&d5.length>0)){throw"Non-empty array is expected"}var d7=d5[0],d8=d5.length;for(var d6=1;d6<d8;++d6){if(d7>d5[d6]){d7=d5[d6]}}return d7};cR.norm=function(d6,d5,d7){return(d6-d5)/(d7-d5)};cR.pow=p.pow;cR.round=p.round;cR.sq=function(d5){return d5*d5};cR.sqrt=p.sqrt;cR.acos=p.acos;cR.asin=p.asin;cR.atan=p.atan;cR.atan2=p.atan2;cR.cos=p.cos;cR.degrees=function(d5){return d5*180/p.PI};cR.radians=function(d5){return d5/180*p.PI};cR.sin=p.sin;cR.tan=p.tan;var bT=p.random;cR.random=function(){if(arguments.length===0){return bT()}if(arguments.length===1){return bT()*arguments[0]}var d6=arguments[0],d5=arguments[1];return bT()*(d5-d6)+d6};function cj(d7,d6){var d9=d7||362436069,d5=d6||521288629;var d8=function(){d9=36969*(d9&65535)+(d9>>>16)&4294967295;d5=18000*(d5&65535)+(d5>>>16)&4294967295;return((d9&65535)<<16|d5&65535)&4294967295};this.nextDouble=function(){var ea=d8()/4294967296;return ea<0?1+ea:ea};this.nextInt=d8}cj.createRandomized=function(){var d5=new Date;return new cj(d5/60000&4294967295,d5&4294967295)};cR.randomSeed=function(d5){bT=(new cj(d5)).nextDouble};cR.Random=function(d5){var d8=false,d6,d7;this.nextGaussian=function(){if(d8){d8=false;return d6}var ec,ea,d9;do{ec=2*d7()-1;ea=2*d7()-1;d9=ec*ec+ea*ea}while(d9>=1||d9===0);var eb=p.sqrt(-2*p.log(d9)/d9);d6=ea*eb;d8=true;return ec*eb};d7=d5===d?p.random:(new cj(d5)).nextDouble};function du(ec){var d6=ec!==d?new cj(ec):cj.createRandomized();var eb,d9;var d8=new r(512);for(eb=0;eb<256;++eb){d8[eb]=eb}for(eb=0;eb<256;++eb){var ee=d8[d9=d6.nextInt()&255];d8[d9]=d8[eb];d8[eb]=ee}for(eb=0;eb<256;++eb){d8[eb+256]=d8[eb]}function d5(ei,ef,el,ek){var ej=ei&15;var eh=ej<8?ef:el,eg=ej<4?el:ej===12||ej===14?ef:ek;return((ej&1)===0?eh:-eh)+((ej&2)===0?eg:-eg)}function ea(eh,ef,ei){var eg=(eh&1)===0?ef:ei;return(eh&2)===0?-eg:eg}function ed(eg,ef){return(eg&1)===0?-ef:ef}function d7(eh,eg,ef){return eg+eh*(ef-eg)}this.noise3d=function(er,eq,ep){var ei=p.floor(er)&255,eg=p.floor(eq)&255,ef=p.floor(ep)&255;er-=p.floor(er);eq-=p.floor(eq);ep-=p.floor(ep);var em=(3-2*er)*er*er,el=(3-2*eq)*eq*eq,ek=(3-2*ep)*ep*ep;var et=d8[ei]+eg,eo=d8[et]+ef,en=d8[et+1]+ef,es=d8[ei+1]+eg,ej=d8[es]+ef,eh=d8[es+1]+ef;return d7(ek,d7(el,d7(em,d5(d8[eo],er,eq,ep),d5(d8[ej],er-1,eq,ep)),d7(em,d5(d8[en],er,eq-1,ep),d5(d8[eh],er-1,eq-1,ep))),d7(el,d7(em,d5(d8[eo+1],er,eq,ep-1),d5(d8[ej+1],er-1,eq,ep-1)),d7(em,d5(d8[en+1],er,eq-1,ep-1),d5(d8[eh+1],er-1,eq-1,ep-1))))};this.noise2d=function(ef,em){var el=p.floor(ef)&255,ej=p.floor(em)&255;ef-=p.floor(ef);em-=p.floor(em);var eh=(3-2*ef)*ef*ef,eg=(3-2*em)*em*em;var ek=d8[el]+ej,ei=d8[el+1]+ej;return d7(eg,d7(eh,ea(d8[ek],ef,em),ea(d8[ei],ef-1,em)),d7(eh,ea(d8[ek+1],ef,em-1),ea(d8[ei+1],ef-1,em-1)))};this.noise1d=function(ef){var eh=p.floor(ef)&255;ef-=p.floor(ef);var eg=(3-2*ef)*ef*ef;return d7(eg,ed(d8[eh],ef),ed(d8[eh+1],ef-1))}}var bR={generator:d,octaves:4,fallout:0.5,seed:d};cR.noise=function(d5,ec,eb){if(bR.generator===d){bR.generator=new du(bR.seed)}var ea=bR.generator;var d9=1,d6=1,d8=0;for(var d7=0;d7<bR.octaves;++d7){d9*=bR.fallout;switch(arguments.length){case 1:d8+=d9*(1+ea.noise1d(d6*d5))/2;break;case 2:d8+=d9*(1+ea.noise2d(d6*d5,d6*ec))/2;break;case 3:d8+=d9*(1+ea.noise3d(d6*d5,d6*ec,d6*eb))/2;break}d6*=2}return d8};cR.noiseDetail=function(d6,d5){bR.octaves=d6;if(d5!==d){bR.fallout=d5}};cR.noiseSeed=function(d5){bR.seed=d5;bR.generator=d};dm.prototype.size=function(d6,d9,d8){if(b9){cR.stroke(0)}if(aC){cR.fill(255)}var d7={fillStyle:d3.fillStyle,strokeStyle:d3.strokeStyle,lineCap:d3.lineCap,lineJoin:d3.lineJoin};if(Z.style.length>0){Z.style.removeProperty("width");Z.style.removeProperty("height")}Z.width=cR.width=d6||100;Z.height=cR.height=d9||100;for(var ea in d7){if(d7.hasOwnProperty(ea)){d3[ea]=d7[ea]}}cR.textFont(R);cR.background();bU=p.max(1000,d6*d9*0.05);cR.externals.context=d3;for(var d5=0;d5<720;d5++){ac[d5]=cR.sin(d5*(p.PI/180)*0.5);bg[d5]=cR.cos(d5*(p.PI/180)*0.5)}};bM.prototype.size=function(d5,d7,d6){if(d3===d){d3=Z.getContext("2d");ah=new Q;c5=new Q;dE=new aS;aO=new aS}dm.prototype.size.apply(this,arguments)};bw.prototype.size=function(){var d6=false;return function d5(d8,ea,d9){if(d6){throw"Multiple calls to size() for 3D renders are not allowed."}d6=true;function eb(ed){var eg=["experimental-webgl","webgl","webkit-3d"],ef;for(var ee=0,ec=eg.length;ee<ec;ee++){ef=ed.getContext(eg[ee],{antialias:false,preserveDrawingBuffer:true});if(ef){break}}return ef}try{Z.width=cR.width=d8||100;Z.height=cR.height=ea||100;d3=eb(Z);c2=d3.createTexture();bN=d3.createTexture()}catch(d7){D.debug(d7)}if(!d3){throw"WebGL context is not supported on this browser."}d3.viewport(0,0,Z.width,Z.height);d3.enable(d3.DEPTH_TEST);d3.enable(d3.BLEND);d3.blendFunc(d3.SRC_ALPHA,d3.ONE_MINUS_SRC_ALPHA);dL=bA(d3,dz,aR);bO=bA(d3,aJ,bL);cR.strokeWeight(1);ds=bA(d3,di,aA);d3.useProgram(ds);dU("usingTexture3d",ds,"usingTexture",dO);cR.lightFalloff(1,0,0);cR.shininess(1);cR.ambient(255,255,255);cR.specular(0,0,0);cR.emissive(0,0,0);bc=d3.createBuffer();d3.bindBuffer(d3.ARRAY_BUFFER,bc);d3.bufferData(d3.ARRAY_BUFFER,dc,d3.STATIC_DRAW);cE=d3.createBuffer();d3.bindBuffer(d3.ARRAY_BUFFER,cE);d3.bufferData(d3.ARRAY_BUFFER,da,d3.STATIC_DRAW);df=d3.createBuffer();d3.bindBuffer(d3.ARRAY_BUFFER,df);d3.bufferData(d3.ARRAY_BUFFER,bC,d3.STATIC_DRAW);aw=d3.createBuffer();d3.bindBuffer(d3.ARRAY_BUFFER,aw);d3.bufferData(d3.ARRAY_BUFFER,af,d3.STATIC_DRAW);bX=d3.createBuffer();d3.bindBuffer(d3.ARRAY_BUFFER,bX);d3.bufferData(d3.ARRAY_BUFFER,ad,d3.STATIC_DRAW);bb=d3.createBuffer();b3=d3.createBuffer();an=d3.createBuffer();aB=d3.createBuffer();bx=d3.createBuffer();aa=d3.createBuffer();aq=d3.createBuffer();d3.bindBuffer(d3.ARRAY_BUFFER,aq);d3.bufferData(d3.ARRAY_BUFFER,new e([0,0,0]),d3.STATIC_DRAW);cC=d3.createBuffer();d3.bindBuffer(d3.ARRAY_BUFFER,cC);d3.bufferData(d3.ARRAY_BUFFER,new e([1,1,0,-1,1,0,-1,-1,0,1,-1,0]),d3.STATIC_DRAW);X=d3.createBuffer();d3.bindBuffer(d3.ARRAY_BUFFER,X);d3.bufferData(d3.ARRAY_BUFFER,new e([0,0,1,0,1,1,0,1]),d3.STATIC_DRAW);M=d3.createBuffer();d3.bindBuffer(d3.ELEMENT_ARRAY_BUFFER,M);d3.bufferData(d3.ELEMENT_ARRAY_BUFFER,new x([0,1,2,2,3,0]),d3.STATIC_DRAW);bQ=new aK;cc=new aK;dE=new aK;aO=new aK;c6=new aK;cR.camera();cR.perspective();ah=new Q;c5=new Q;cY=new aK;aL=new aK;aG=new aK;bu=new aK;b8=new aK;P=new aK;P.set(-1,3,-3,1,3,-6,3,0,-3,3,0,0,1,0,0,0);dm.prototype.size.apply(this,arguments)}}();bM.prototype.ambientLight=dm.prototype.a3DOnlyFunction;bw.prototype.ambientLight=function(d5,d8,ed,ee,ea,d9){if(dG===8){throw"can only create "+8+" lights"}var eb=new l(ee,ea,d9);var ec=new aK;ec.scale(1,-1,1);ec.apply(dE.array());ec.mult(eb,eb);var d6=dC(d5,d8,ed,0);var d7=[(d6>>16&255)/255,(d6>>8&255)/255,(d6&255)/255];d3.useProgram(ds);dX("uLights.color.3d."+dG,ds,"uLights"+dG+".color",d7);dX("uLights.position.3d."+dG,ds,"uLights"+dG+".position",eb.array());dU("uLights.type.3d."+dG,ds,"uLights"+dG+".type",0);dU("uLightCount3d",ds,"uLightCount",++dG)};bM.prototype.directionalLight=dm.prototype.a3DOnlyFunction;bw.prototype.directionalLight=function(d5,eb,ed,ec,ea,d9){if(dG===8){throw"can only create "+8+" lights"}d3.useProgram(ds);var ee=new aK;ee.scale(1,-1,1);ee.apply(dE.array());ee=ee.array();var d7=[ee[0]*ec+ee[4]*ea+ee[8]*d9,ee[1]*ec+ee[5]*ea+ee[9]*d9,ee[2]*ec+ee[6]*ea+ee[10]*d9];var d6=dC(d5,eb,ed,0);var d8=[(d6>>16&255)/255,(d6>>8&255)/255,(d6&255)/255];dX("uLights.color.3d."+dG,ds,"uLights"+dG+".color",d8);dX("uLights.position.3d."+dG,ds,"uLights"+dG+".position",d7);dU("uLights.type.3d."+dG,ds,"uLights"+dG+".type",1);dU("uLightCount3d",ds,"uLightCount",++dG)};bM.prototype.lightFalloff=dm.prototype.a3DOnlyFunction;bw.prototype.lightFalloff=function(d6,d5,d7){d3.useProgram(ds);dX("uFalloff3d",ds,"uFalloff",[d6,d5,d7])};bM.prototype.lightSpecular=dm.prototype.a3DOnlyFunction;bw.prototype.lightSpecular=function(d9,d8,d5){var d6=dC(d9,d8,d5,0);var d7=[(d6>>16&255)/255,(d6>>8&255)/255,(d6&255)/255];d3.useProgram(ds);dX("uSpecular3d",ds,"uSpecular",d7)};cR.lights=function(){cR.ambientLight(128,128,128);cR.directionalLight(128,128,128,0,0,-1);cR.lightFalloff(1,0,0);cR.lightSpecular(0,0,0)};bM.prototype.pointLight=dm.prototype.a3DOnlyFunction;bw.prototype.pointLight=function(d5,d8,ed,ee,ea,d9){if(dG===8){throw"can only create "+8+" lights"}var eb=new l(ee,ea,d9);var ec=new aK;ec.scale(1,-1,1);ec.apply(dE.array());ec.mult(eb,eb);var d6=dC(d5,d8,ed,0);var d7=[(d6>>16&255)/255,(d6>>8&255)/255,(d6&255)/255];d3.useProgram(ds);dX("uLights.color.3d."+dG,ds,"uLights"+dG+".color",d7);dX("uLights.position.3d."+dG,ds,"uLights"+dG+".position",eb.array());dU("uLights.type.3d."+dG,ds,"uLights"+dG+".type",2);dU("uLightCount3d",ds,"uLightCount",++dG)};bM.prototype.noLights=dm.prototype.a3DOnlyFunction;bw.prototype.noLights=function(){dG=0;d3.useProgram(ds);dU("uLightCount3d",ds,"uLightCount",dG)};bM.prototype.spotLight=dm.prototype.a3DOnlyFunction;bw.prototype.spotLight=function(d5,ed,ei,ej,eh,ef,ee,ec,ea,d9,eb){if(dG===8){throw"can only create "+8+" lights"}d3.useProgram(ds);var eg=new l(ej,eh,ef);var ek=new aK;ek.scale(1,-1,1);ek.apply(dE.array());ek.mult(eg,eg);ek=ek.array();var d7=[ek[0]*ee+ek[4]*ec+ek[8]*ea,ek[1]*ee+ek[5]*ec+ek[9]*ea,ek[2]*ee+ek[6]*ec+ek[10]*ea];var d6=dC(d5,ed,ei,0);var d8=[(d6>>16&255)/255,(d6>>8&255)/255,(d6&255)/255];dX("uLights.color.3d."+dG,ds,"uLights"+dG+".color",d8);dX("uLights.position.3d."+dG,ds,"uLights"+dG+".position",eg.array());dX("uLights.direction.3d."+dG,ds,"uLights"+dG+".direction",d7);dX("uLights.concentration.3d."+dG,ds,"uLights"+dG+".concentration",eb);dX("uLights.angle.3d."+dG,ds,"uLights"+dG+".angle",d9);dU("uLights.type.3d."+dG,ds,"uLights"+dG+".type",3);dU("uLightCount3d",ds,"uLightCount",++dG)};bM.prototype.beginCamera=function(){throw"beginCamera() is not available in 2D mode"};bw.prototype.beginCamera=function(){if(ak){throw"You cannot call beginCamera() again before calling endCamera()"}ak=true;dE=cc;aO=bQ};bM.prototype.endCamera=function(){throw"endCamera() is not available in 2D mode"};bw.prototype.endCamera=function(){if(!ak){throw"You cannot call endCamera() before calling beginCamera()"}dE.set(bQ);aO.set(cc);ak=false};cR.camera=function(eg,ef,ed,eb,d9,d8,eo,em,ek){if(eg===d){dg=cR.width/2;de=cR.height/2;dd=de/p.tan(cF/2);eg=dg;ef=de;ed=dd;eb=dg;d9=de;d8=0;eo=0;em=1;ek=0}var ea=new l(eg-eb,ef-d9,ed-d8);var ec=new l(eo,em,ek);ea.normalize();var ee=l.cross(ec,ea);ec=l.cross(ea,ee);ee.normalize();ec.normalize();var ep=ee.x,en=ee.y,el=ee.z;var d7=ec.x,d6=ec.y,d5=ec.z;var ej=ea.x,ei=ea.y,eh=ea.z;bQ.set(ep,en,el,0,d7,d6,d5,0,ej,ei,eh,0,0,0,0,1);bQ.translate(-eg,-ef,-ed);cc.reset();cc.invApply(ep,en,el,0,d7,d6,d5,0,ej,ei,eh,0,0,0,0,1);cc.translate(eg,ef,ed);dE.set(bQ);aO.set(cc)};cR.perspective=function(d9,d7,ea,d6){if(arguments.length===0){de=Z.height/2;dd=de/p.tan(cF/2);aV=dd/10;ap=dd*10;b0=cR.width/cR.height;d9=cF;d7=b0;ea=aV;d6=ap}var eb,d5,ec,d8;eb=ea*p.tan(d9/2);d5=-eb;ec=eb*d7;d8=d5*d7;cR.frustum(d8,ec,d5,eb,ea,d6)};bM.prototype.frustum=function(){throw"Processing.js: frustum() is not supported in 2D mode"};bw.prototype.frustum=function(eb,d7,d6,ea,d9,d5){cd=true;c6=new aK;c6.set(2*d9/(d7-eb),0,(d7+eb)/(d7-eb),0,0,2*d9/(ea-d6),(ea+d6)/(ea-d6),0,0,0,-(d5+d9)/(d5-d9),-(2*d5*d9)/(d5-d9),0,0,-1,0);var d8=new aK;d8.set(c6);d8.transpose();d3.useProgram(dL);a4("projection2d",dL,"uProjection",false,d8.array());d3.useProgram(ds);a4("projection3d",ds,"uProjection",false,d8.array());d3.useProgram(bO);a4("uProjectionUS",bO,"uProjection",false,d8.array())};cR.ortho=function(d6,eh,d5,ef,ec,eb){if(arguments.length===0){d6=0;eh=cR.width;d5=0;ef=cR.height;ec=-10;eb=10}var eg=2/(eh-d6);var ee=2/(ef-d5);var ed=-2/(eb-ec);var ea=-(eh+d6)/(eh-d6);var d9=-(ef+d5)/(ef-d5);var d8=-(eb+ec)/(eb-ec);c6=new aK;c6.set(eg,0,0,ea,0,ee,0,d9,0,0,ed,d8,0,0,0,1);var d7=new aK;d7.set(c6);d7.transpose();d3.useProgram(dL);a4("projection2d",dL,"uProjection",false,d7.array());d3.useProgram(ds);a4("projection3d",ds,"uProjection",false,d7.array());d3.useProgram(bO);a4("uProjectionUS",bO,"uProjection",false,d7.array());cd=false};cR.printProjection=function(){c6.print()};cR.printCamera=function(){bQ.print()};bM.prototype.box=dm.prototype.a3DOnlyFunction;bw.prototype.box=function(d7,ea,ec){if(!ea||!ec){ea=ec=d7}var d9=new aK;d9.scale(d7,ea,ec);var d6=new aK;d6.scale(1,-1,1);d6.apply(dE.array());d6.transpose();if(aC){d3.useProgram(ds);a4("model3d",ds,"uModel",false,d9.array());a4("view3d",ds,"uView",false,d6.array());d3.enable(d3.POLYGON_OFFSET_FILL);d3.polygonOffset(1,1);dX("color3d",ds,"uColor",bj);if(dG>0){var d8=new aK;d8.set(d6);var d5=new aK;d5.set(d9);d8.mult(d5);var eb=new aK;eb.set(d8);eb.invert();eb.transpose();a4("uNormalTransform3d",ds,"uNormalTransform",false,eb.array());c7("aNormal3d",ds,"aNormal",3,cE)}else{cb("aNormal3d",ds,"aNormal")}c7("aVertex3d",ds,"aVertex",3,bc);cb("aColor3d",ds,"aColor");cb("aTexture3d",ds,"aTexture");d3.drawArrays(d3.TRIANGLES,0,dc.length/3);d3.disable(d3.POLYGON_OFFSET_FILL)}if(dR>0&&b9){d3.useProgram(dL);a4("uModel2d",dL,"uModel",false,d9.array());a4("uView2d",dL,"uView",false,d6.array());dX("uColor2d",dL,"uColor",cV);dU("uIsDrawingText2d",dL,"uIsDrawingText",false);c7("vertex2d",dL,"aVertex",3,df);cb("aTextureCoord2d",dL,"aTextureCoord");d3.drawArrays(d3.LINES,0,bC.length/3)}};var cy=function(){var d6;cA=[];for(d6=0;d6<bH;d6++){cA.push(0);cA.push(-1);cA.push(0);cA.push(bo[d6]);cA.push(bn[d6]);cA.push(bm[d6])}cA.push(0);cA.push(-1);cA.push(0);cA.push(bo[0]);cA.push(bn[0]);cA.push(bm[0]);var ea,d7,d9;var d8=0;for(d6=2;d6<bG;d6++){ea=d7=d8;d8+=bH;d9=d8;for(var d5=0;d5<bH;d5++){cA.push(bo[ea]);cA.push(bn[ea]);cA.push(bm[ea++]);cA.push(bo[d9]);cA.push(bn[d9]);cA.push(bm[d9++])}ea=d7;d9=d8;cA.push(bo[ea]);cA.push(bn[ea]);cA.push(bm[ea]);cA.push(bo[d9]);cA.push(bn[d9]);cA.push(bm[d9])}for(d6=0;d6<bH;d6++){d9=d8+d6;cA.push(bo[d9]);cA.push(bn[d9]);cA.push(bm[d9]);cA.push(0);cA.push(1);cA.push(0)}cA.push(bo[d8]);cA.push(bn[d8]);cA.push(bm[d8]);cA.push(0);cA.push(1);cA.push(0);d3.bindBuffer(d3.ARRAY_BUFFER,bb);d3.bufferData(d3.ARRAY_BUFFER,new e(cA),d3.STATIC_DRAW)};cR.sphereDetail=function(d6,eh){var ec;if(arguments.length===1){d6=eh=arguments[0]}if(d6<3){d6=3}if(eh<2){eh=2}if(d6===bH&&eh===bG){return}var eg=720/d6;var ea=new e(d6);var d7=new e(d6);for(ec=0;ec<d6;ec++){ea[ec]=bg[ec*eg%720|0];d7[ec]=ac[ec*eg%720|0]}var ef=d6*(eh-1)+2;var ee=0;bo=new e(ef);bn=new e(ef);bm=new e(ef);var ed=720*0.5/eh;var d9=ed;for(ec=1;ec<eh;ec++){var d8=ac[d9%720|0];var d5=-bg[d9%720|0];for(var eb=0;eb<d6;eb++){bo[ee]=ea[eb]*d8;bn[ee]=d5;bm[ee++]=d7[eb]*d8}d9+=ed}bH=d6;bG=eh;cy()};bM.prototype.sphere=dm.prototype.a3DOnlyFunction;bw.prototype.sphere=function(){var d9=arguments[0];if(bH<3||bG<2){cR.sphereDetail(30)}var d8=new aK;d8.scale(d9,d9,d9);var d6=new aK;d6.scale(1,-1,1);d6.apply(dE.array());d6.transpose();if(aC){if(dG>0){var d7=new aK;d7.set(d6);var d5=new aK;d5.set(d8);d7.mult(d5);var ea=new aK;ea.set(d7);ea.invert();ea.transpose();a4("uNormalTransform3d",ds,"uNormalTransform",false,ea.array());c7("aNormal3d",ds,"aNormal",3,bb)}else{cb("aNormal3d",ds,"aNormal")}d3.useProgram(ds);cb("aTexture3d",ds,"aTexture");a4("uModel3d",ds,"uModel",false,d8.array());a4("uView3d",ds,"uView",false,d6.array());c7("aVertex3d",ds,"aVertex",3,bb);cb("aColor3d",ds,"aColor");d3.enable(d3.POLYGON_OFFSET_FILL);d3.polygonOffset(1,1);dX("uColor3d",ds,"uColor",bj);d3.drawArrays(d3.TRIANGLE_STRIP,0,cA.length/3);d3.disable(d3.POLYGON_OFFSET_FILL)}if(dR>0&&b9){d3.useProgram(dL);a4("uModel2d",dL,"uModel",false,d8.array());a4("uView2d",dL,"uView",false,d6.array());c7("aVertex2d",dL,"aVertex",3,bb);cb("aTextureCoord2d",dL,"aTextureCoord");dX("uColor2d",dL,"uColor",cV);dU("uIsDrawingText",dL,"uIsDrawingText",false);d3.drawArrays(d3.LINE_STRIP,0,cA.length/3)}};cR.modelX=function(eb,ea,d9){var ed=dE.array();var ef=cc.array();var d5=ed[0]*eb+ed[1]*ea+ed[2]*d9+ed[3];var ee=ed[4]*eb+ed[5]*ea+ed[6]*d9+ed[7];var ec=ed[8]*eb+ed[9]*ea+ed[10]*d9+ed[11];var d6=ed[12]*eb+ed[13]*ea+ed[14]*d9+ed[15];var d7=ef[0]*d5+ef[1]*ee+ef[2]*ec+ef[3]*d6;var d8=ef[12]*d5+ef[13]*ee+ef[14]*ec+ef[15]*d6;return d8!==0?d7/d8:d7};cR.modelY=function(eb,ea,d9){var ed=dE.array();var ef=cc.array();var d5=ed[0]*eb+ed[1]*ea+ed[2]*d9+ed[3];var ee=ed[4]*eb+ed[5]*ea+ed[6]*d9+ed[7];var ec=ed[8]*eb+ed[9]*ea+ed[10]*d9+ed[11];var d6=ed[12]*eb+ed[13]*ea+ed[14]*d9+ed[15];var d7=ef[4]*d5+ef[5]*ee+ef[6]*ec+ef[7]*d6;var d8=ef[12]*d5+ef[13]*ee+ef[14]*ec+ef[15]*d6;return d8!==0?d7/d8:d7};cR.modelZ=function(eb,ea,d9){var ed=dE.array();var ef=cc.array();var d5=ed[0]*eb+ed[1]*ea+ed[2]*d9+ed[3];var ee=ed[4]*eb+ed[5]*ea+ed[6]*d9+ed[7];var ec=ed[8]*eb+ed[9]*ea+ed[10]*d9+ed[11];var d7=ed[12]*eb+ed[13]*ea+ed[14]*d9+ed[15];var d6=ef[8]*d5+ef[9]*ee+ef[10]*ec+ef[11]*d7;var d8=ef[12]*d5+ef[13]*ee+ef[14]*ec+ef[15]*d7;return d8!==0?d6/d8:d6};bM.prototype.ambient=dm.prototype.a3DOnlyFunction;bw.prototype.ambient=function(d8,d7,d6){d3.useProgram(ds);dU("uUsingMat3d",ds,"uUsingMat",true);var d5=cR.color(d8,d7,d6);dX("uMaterialAmbient3d",ds,"uMaterialAmbient",cR.color.toGLArray(d5).slice(0,3))};bM.prototype.emissive=dm.prototype.a3DOnlyFunction;bw.prototype.emissive=function(d8,d7,d6){d3.useProgram(ds);dU("uUsingMat3d",ds,"uUsingMat",true);var d5=cR.color(d8,d7,d6);dX("uMaterialEmissive3d",ds,"uMaterialEmissive",cR.color.toGLArray(d5).slice(0,3))};bM.prototype.shininess=dm.prototype.a3DOnlyFunction;bw.prototype.shininess=function(d5){d3.useProgram(ds);dU("uUsingMat3d",ds,"uUsingMat",true);dX("uShininess3d",ds,"uShininess",d5)};bM.prototype.specular=dm.prototype.a3DOnlyFunction;bw.prototype.specular=function(d8,d7,d6){d3.useProgram(ds);dU("uUsingMat3d",ds,"uUsingMat",true);var d5=cR.color(d8,d7,d6);dX("uMaterialSpecular3d",ds,"uMaterialSpecular",cR.color.toGLArray(d5).slice(0,3))};cR.screenX=function(ec,eb,ea){var ee=dE.array();if(ee.length===16){var d5=ee[0]*ec+ee[1]*eb+ee[2]*ea+ee[3];var ef=ee[4]*ec+ee[5]*eb+ee[6]*ea+ee[7];var ed=ee[8]*ec+ee[9]*eb+ee[10]*ea+ee[11];var d6=ee[12]*ec+ee[13]*eb+ee[14]*ea+ee[15];var d9=c6.array();var d7=d9[0]*d5+d9[1]*ef+d9[2]*ed+d9[3]*d6;var d8=d9[12]*d5+d9[13]*ef+d9[14]*ed+d9[15]*d6;if(d8!==0){d7/=d8}return cR.width*(1+d7)/2}return dE.multX(ec,eb)};cR.screenY=function av(ec,eb,ea){var ee=dE.array();if(ee.length===16){var d5=ee[0]*ec+ee[1]*eb+ee[2]*ea+ee[3];var ef=ee[4]*ec+ee[5]*eb+ee[6]*ea+ee[7];var ed=ee[8]*ec+ee[9]*eb+ee[10]*ea+ee[11];var d6=ee[12]*ec+ee[13]*eb+ee[14]*ea+ee[15];var d9=c6.array();var d7=d9[4]*d5+d9[5]*ef+d9[6]*ed+d9[7]*d6;var d8=d9[12]*d5+d9[13]*ef+d9[14]*ed+d9[15]*d6;if(d8!==0){d7/=d8}return cR.height*(1+d7)/2}return dE.multY(ec,eb)};cR.screenZ=function at(ec,eb,ea){var ee=dE.array();if(ee.length!==16){return 0}var d9=c6.array();var d5=ee[0]*ec+ee[1]*eb+ee[2]*ea+ee[3];var ef=ee[4]*ec+ee[5]*eb+ee[6]*ea+ee[7];var ed=ee[8]*ec+ee[9]*eb+ee[10]*ea+ee[11];var d7=ee[12]*ec+ee[13]*eb+ee[14]*ea+ee[15];var d6=d9[8]*d5+d9[9]*ef+d9[10]*ed+d9[11]*d7;var d8=d9[12]*d5+d9[13]*ef+d9[14]*ed+d9[15]*d7;if(d8!==0){d6/=d8}return(d6+1)/2};dm.prototype.fill=function(){var d5=cR.color(arguments[0],arguments[1],arguments[2],arguments[3]);if(d5===aW&&aC){return}aC=true;aW=d5};bM.prototype.fill=function(){dm.prototype.fill.apply(this,arguments);al=true};bw.prototype.fill=function(){dm.prototype.fill.apply(this,arguments);bj=cR.color.toGLArray(aW)};function bi(){if(aC){if(al){d3.fillStyle=cR.color.toString(aW);al=false}d3.fill()}}cR.noFill=function(){aC=false};dm.prototype.stroke=function(){var d5=cR.color(arguments[0],arguments[1],arguments[2],arguments[3]);if(d5===cq&&b9){return}b9=true;cq=d5};bM.prototype.stroke=function(){dm.prototype.stroke.apply(this,arguments);bY=true};bw.prototype.stroke=function(){dm.prototype.stroke.apply(this,arguments);cV=cR.color.toGLArray(cq)};function c8(){if(b9){if(bY){d3.strokeStyle=cR.color.toString(cq);bY=false}d3.stroke()}}cR.noStroke=function(){b9=false};dm.prototype.strokeWeight=function(d5){dR=d5};bM.prototype.strokeWeight=function(d5){dm.prototype.strokeWeight.apply(this,arguments);d3.lineWidth=d5};bw.prototype.strokeWeight=function(d5){dm.prototype.strokeWeight.apply(this,arguments);d3.useProgram(dL);dX("pointSize2d",dL,"uPointSize",d5);d3.useProgram(bO);dX("pointSizeUnlitShape",bO,"uPointSize",d5);d3.lineWidth(d5)};cR.strokeCap=function(d5){dT.$ensureContext().lineCap=d5};cR.strokeJoin=function(d5){dT.$ensureContext().lineJoin=d5};bM.prototype.smooth=function(){dJ=true;var d5=Z.style;d5.setProperty("image-rendering","optimizeQuality","important");d5.setProperty("-ms-interpolation-mode","bicubic","important");if(d3.hasOwnProperty("mozImageSmoothingEnabled")){d3.mozImageSmoothingEnabled=true}};bw.prototype.smooth=function(){dJ=true};bM.prototype.noSmooth=function(){dJ=false;var d5=Z.style;d5.setProperty("image-rendering","optimizeSpeed","important");d5.setProperty("image-rendering","-moz-crisp-edges","important");d5.setProperty("image-rendering","-webkit-optimize-contrast","important");d5.setProperty("image-rendering","optimize-contrast","important");d5.setProperty("-ms-interpolation-mode","nearest-neighbor","important");if(d3.hasOwnProperty("mozImageSmoothingEnabled")){d3.mozImageSmoothingEnabled=false}};bw.prototype.noSmooth=function(){dJ=false};bM.prototype.point=function(d5,d6){if(!b9){return}d5=p.round(d5);d6=p.round(d6);d3.fillStyle=cR.color.toString(cq);al=true;if(dR>1){d3.beginPath();d3.arc(d5,d6,dR/2,0,6.283185307179586,false);d3.fill()}else{d3.fillRect(d5,d6,1,1)}};bw.prototype.point=function(d5,d9,d8){var d7=new aK;d7.translate(d5,d9,d8||0);d7.transpose();var d6=new aK;d6.scale(1,-1,1);d6.apply(dE.array());d6.transpose();d3.useProgram(dL);a4("uModel2d",dL,"uModel",false,d7.array());a4("uView2d",dL,"uView",false,d6.array());if(dR>0&&b9){dX("uColor2d",dL,"uColor",cV);dU("uIsDrawingText2d",dL,"uIsDrawingText",false);dU("uSmooth2d",dL,"uSmooth",dJ);c7("aVertex2d",dL,"aVertex",3,aq);cb("aTextureCoord2d",dL,"aTextureCoord");d3.drawArrays(d3.POINTS,0,1)}};cR.beginShape=function(d5){dM=d5;d1=[];a6=[]};bM.prototype.vertex=function(d6,d8,d5){var d7=[];if(dp){dp=false}d7.isVert=true;d7[0]=d6;d7[1]=d8;d7[2]=0;d7[3]=0;d7[4]=0;d7[5]=aW;d7[6]=cq;a6.push(d7);if(d5){a6[a6.length-1]["moveTo"]=d5}};bw.prototype.vertex=function(d5,ea,d9,d8,d7){var d6=[];if(dp){dp=false}d6.isVert=true;if(d7===d&&dO){d7=d8;d8=d9;d9=0}if(d8!==d&&d7!==d){if(dZ===2){d8/=cn.width;d7/=cn.height}d8=d8>1?1:d8;d8=d8<0?0:d8;d7=d7>1?1:d7;d7=d7<0?0:d7}d6[0]=d5;d6[1]=ea;d6[2]=d9||0;d6[3]=d8||0;d6[4]=d7||0;d6[5]=bj[0];d6[6]=bj[1];d6[7]=bj[2];d6[8]=bj[3];d6[9]=cV[0];d6[10]=cV[1];d6[11]=cV[2];d6[12]=cV[3];d6[13]=a3;d6[14]=a2;d6[15]=a1;a6.push(d6)};var dW=function(d7,d6){var d5=new aK;d5.scale(1,-1,1);d5.apply(dE.array());d5.transpose();d3.useProgram(bO);a4("uViewUS",bO,"uView",false,d5.array());dU("uSmoothUS",bO,"uSmooth",dJ);c7("aVertexUS",bO,"aVertex",3,aq);d3.bufferData(d3.ARRAY_BUFFER,new e(d7),d3.STREAM_DRAW);c7("aColorUS",bO,"aColor",4,aB);d3.bufferData(d3.ARRAY_BUFFER,new e(d6),d3.STREAM_DRAW);d3.drawArrays(d3.POINTS,0,d7.length/3)};var be=function(d9,d8,d7){var d6;if(d8==="LINES"){d6=d3.LINES}else{if(d8==="LINE_LOOP"){d6=d3.LINE_LOOP}else{d6=d3.LINE_STRIP}}var d5=new aK;d5.scale(1,-1,1);d5.apply(dE.array());d5.transpose();d3.useProgram(bO);a4("uViewUS",bO,"uView",false,d5.array());c7("aVertexUS",bO,"aVertex",3,b3);d3.bufferData(d3.ARRAY_BUFFER,new e(d9),d3.STREAM_DRAW);c7("aColorUS",bO,"aColor",4,bx);d3.bufferData(d3.ARRAY_BUFFER,new e(d7),d3.STREAM_DRAW);d3.drawArrays(d6,0,d9.length/3)};var dh=function(ea,d9,d8,d7){var d6;if(d9==="TRIANGLES"){d6=d3.TRIANGLES}else{if(d9==="TRIANGLE_FAN"){d6=d3.TRIANGLE_FAN}else{d6=d3.TRIANGLE_STRIP}}var d5=new aK;d5.scale(1,-1,1);d5.apply(dE.array());d5.transpose();d3.useProgram(ds);a4("model3d",ds,"uModel",false,[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]);a4("view3d",ds,"uView",false,d5.array());d3.enable(d3.POLYGON_OFFSET_FILL);d3.polygonOffset(1,1);dX("color3d",ds,"uColor",[-1,0,0,0]);c7("vertex3d",ds,"aVertex",3,an);d3.bufferData(d3.ARRAY_BUFFER,new e(ea),d3.STREAM_DRAW);if(dO&&ba!==null){br(d8)}c7("aColor3d",ds,"aColor",4,aB);d3.bufferData(d3.ARRAY_BUFFER,new e(d8),d3.STREAM_DRAW);cb("aNormal3d",ds,"aNormal");if(dO){dU("uUsingTexture3d",ds,"uUsingTexture",dO);c7("aTexture3d",ds,"aTexture",2,aa);d3.bufferData(d3.ARRAY_BUFFER,new e(d7),d3.STREAM_DRAW)}d3.drawArrays(d6,0,ea.length/3);d3.disable(d3.POLYGON_OFFSET_FILL)};function cN(){bi();c8();d3.closePath()}bM.prototype.endShape=function(ec){if(a6.length===0){return}var d8=ec===2;if(d8){a6.push(a6[0])}var d7=[];var d5=[];var ee=[];var eh=[];var ea=[];var ed;dp=true;var eb,d9,d6;var eg=a6.length;for(eb=0;eb<eg;eb++){ed=a6[eb];for(d9=0;d9<3;d9++){d5.push(ed[d9])}}for(eb=0;eb<eg;eb++){ed=a6[eb];for(d9=5;d9<9;d9++){ee.push(ed[d9])}}for(eb=0;eb<eg;eb++){ed=a6[eb];for(d9=9;d9<13;d9++){eh.push(ed[d9])}}for(eb=0;eb<eg;eb++){ed=a6[eb];ea.push(ed[3]);ea.push(ed[4])}if(dK&&(dM===20||dM===d)){if(eg>3){var ef=[],ei=1-aE;d3.beginPath();d3.moveTo(a6[1][0],a6[1][1]);for(eb=1;eb+2<eg;eb++){ed=a6[eb];ef[0]=[ed[0],ed[1]];ef[1]=[ed[0]+(ei*a6[eb+1][0]-ei*a6[eb-1][0])/6,ed[1]+(ei*a6[eb+1][1]-ei*a6[eb-1][1])/6];ef[2]=[a6[eb+1][0]+(ei*a6[eb][0]-ei*a6[eb+2][0])/6,a6[eb+1][1]+(ei*a6[eb][1]-ei*a6[eb+2][1])/6];ef[3]=[a6[eb+1][0],a6[eb+1][1]];d3.bezierCurveTo(ef[1][0],ef[1][1],ef[2][0],ef[2][1],ef[3][0],ef[3][1])}cN()}}else{if(V&&(dM===20||dM===d)){d3.beginPath();for(eb=0;eb<eg;eb++){ed=a6[eb];if(a6[eb]["isVert"]){if(a6[eb]["moveTo"]){d3.moveTo(ed[0],ed[1])}else{d3.lineTo(ed[0],ed[1])}}else{d3.bezierCurveTo(a6[eb][0],a6[eb][1],a6[eb][2],a6[eb][3],a6[eb][4],a6[eb][5])}}cN()}else{if(dM===2){for(eb=0;eb<eg;eb++){ed=a6[eb];if(b9){cR.stroke(ed[6])}cR.point(ed[0],ed[1])}}else{if(dM===4){for(eb=0;eb+1<eg;eb+=2){ed=a6[eb];if(b9){cR.stroke(a6[eb+1][6])}cR.line(ed[0],ed[1],a6[eb+1][0],a6[eb+1][1])}}else{if(dM===9){for(eb=0;eb+2<eg;eb+=3){ed=a6[eb];d3.beginPath();d3.moveTo(ed[0],ed[1]);d3.lineTo(a6[eb+1][0],a6[eb+1][1]);d3.lineTo(a6[eb+2][0],a6[eb+2][1]);d3.lineTo(ed[0],ed[1]);if(aC){cR.fill(a6[eb+2][5]);bi()}if(b9){cR.stroke(a6[eb+2][6]);c8()}d3.closePath()}}else{if(dM===10){for(eb=0;eb+1<eg;eb++){ed=a6[eb];d3.beginPath();d3.moveTo(a6[eb+1][0],a6[eb+1][1]);d3.lineTo(ed[0],ed[1]);if(b9){cR.stroke(a6[eb+1][6])}if(aC){cR.fill(a6[eb+1][5])}if(eb+2<eg){d3.lineTo(a6[eb+2][0],a6[eb+2][1]);if(b9){cR.stroke(a6[eb+2][6])}if(aC){cR.fill(a6[eb+2][5])}}cN()}}else{if(dM===11){if(eg>2){d3.beginPath();d3.moveTo(a6[0][0],a6[0][1]);d3.lineTo(a6[1][0],a6[1][1]);d3.lineTo(a6[2][0],a6[2][1]);if(aC){cR.fill(a6[2][5]);bi()}if(b9){cR.stroke(a6[2][6]);c8()}d3.closePath();for(eb=3;eb<eg;eb++){ed=a6[eb];d3.beginPath();d3.moveTo(a6[0][0],a6[0][1]);d3.lineTo(a6[eb-1][0],a6[eb-1][1]);d3.lineTo(ed[0],ed[1]);if(aC){cR.fill(ed[5]);bi()}if(b9){cR.stroke(ed[6]);c8()}d3.closePath()}}}else{if(dM===16){for(eb=0;eb+3<eg;eb+=4){ed=a6[eb];d3.beginPath();d3.moveTo(ed[0],ed[1]);for(d9=1;d9<4;d9++){d3.lineTo(a6[eb+d9][0],a6[eb+d9][1])}d3.lineTo(ed[0],ed[1]);if(aC){cR.fill(a6[eb+3][5]);bi()}if(b9){cR.stroke(a6[eb+3][6]);c8()}d3.closePath()}}else{if(dM===17){if(eg>3){for(eb=0;eb+1<eg;eb+=2){ed=a6[eb];d3.beginPath();if(eb+3<eg){d3.moveTo(a6[eb+2][0],a6[eb+2][1]);d3.lineTo(ed[0],ed[1]);d3.lineTo(a6[eb+1][0],a6[eb+1][1]);d3.lineTo(a6[eb+3][0],a6[eb+3][1]);if(aC){cR.fill(a6[eb+3][5])}if(b9){cR.stroke(a6[eb+3][6])}}else{d3.moveTo(ed[0],ed[1]);d3.lineTo(a6[eb+1][0],a6[eb+1][1])}cN()}}}else{d3.beginPath();d3.moveTo(a6[0][0],a6[0][1]);for(eb=1;eb<eg;eb++){ed=a6[eb];if(ed.isVert){if(ed.moveTo){d3.moveTo(ed[0],ed[1])}else{d3.lineTo(ed[0],ed[1])}}}cN()}}}}}}}}}dK=false;V=false;b6=[];cX=0;if(d8){a6.pop()}};bw.prototype.endShape=function(ec){if(a6.length===0){return}var d8=ec===2;var d7=[];var d5=[];var ee=[];var eh=[];var ea=[];var ed;dp=true;var eb,d9,d6;var eg=a6.length;for(eb=0;eb<eg;eb++){ed=a6[eb];for(d9=0;d9<3;d9++){d5.push(ed[d9])}}for(eb=0;eb<eg;eb++){ed=a6[eb];for(d9=5;d9<9;d9++){ee.push(ed[d9])}}for(eb=0;eb<eg;eb++){ed=a6[eb];for(d9=9;d9<13;d9++){eh.push(ed[d9])}}for(eb=0;eb<eg;eb++){ed=a6[eb];ea.push(ed[3]);ea.push(ed[4])}if(d8){d5.push(a6[0][0]);d5.push(a6[0][1]);d5.push(a6[0][2]);for(eb=5;eb<9;eb++){ee.push(a6[0][eb])}for(eb=9;eb<13;eb++){eh.push(a6[0][eb])}ea.push(a6[0][3]);ea.push(a6[0][4])}if(dK&&(dM===20||dM===d)){d7=d5;if(b9){be(d7,null,eh)}if(aC){dh(d5,null,ee)}}else{if(V&&(dM===20||dM===d)){d7=d5;d7.splice(d7.length-3);eh.splice(eh.length-4);if(b9){be(d7,null,eh)}if(aC){dh(d5,"TRIANGLES",ee)}}else{if(dM===2){for(eb=0;eb<eg;eb++){ed=a6[eb];for(d9=0;d9<3;d9++){d7.push(ed[d9])}}dW(d7,eh)}else{if(dM===4){for(eb=0;eb<eg;eb++){ed=a6[eb];for(d9=0;d9<3;d9++){d7.push(ed[d9])}}for(eb=0;eb<eg;eb++){ed=a6[eb];for(d9=5;d9<9;d9++){ee.push(ed[d9])}}be(d7,"LINES",eh)}else{if(dM===9){if(eg>2){for(eb=0;eb+2<eg;eb+=3){d5=[];ea=[];d7=[];ee=[];eh=[];for(d9=0;d9<3;d9++){for(d6=0;d6<3;d6++){d7.push(a6[eb+d9][d6]);d5.push(a6[eb+d9][d6])}}for(d9=0;d9<3;d9++){for(d6=3;d6<5;d6++){ea.push(a6[eb+d9][d6])}}for(d9=0;d9<3;d9++){for(d6=5;d6<9;d6++){ee.push(a6[eb+d9][d6]);eh.push(a6[eb+d9][d6+4])}}if(b9){be(d7,"LINE_LOOP",eh)}if(aC||dO){dh(d5,"TRIANGLES",ee,ea)}}}}else{if(dM===10){if(eg>2){for(eb=0;eb+2<eg;eb++){d7=[];d5=[];eh=[];ee=[];ea=[];for(d9=0;d9<3;d9++){for(d6=0;d6<3;d6++){d7.push(a6[eb+d9][d6]);d5.push(a6[eb+d9][d6])}}for(d9=0;d9<3;d9++){for(d6=3;d6<5;d6++){ea.push(a6[eb+d9][d6])}}for(d9=0;d9<3;d9++){for(d6=5;d6<9;d6++){eh.push(a6[eb+d9][d6+4]);ee.push(a6[eb+d9][d6])}}if(aC||dO){dh(d5,"TRIANGLE_STRIP",ee,ea)}if(b9){be(d7,"LINE_LOOP",eh)}}}}else{if(dM===11){if(eg>2){for(eb=0;eb<3;eb++){ed=a6[eb];for(d9=0;d9<3;d9++){d7.push(ed[d9])}}for(eb=0;eb<3;eb++){ed=a6[eb];for(d9=9;d9<13;d9++){eh.push(ed[d9])}}if(b9){be(d7,"LINE_LOOP",eh)}for(eb=2;eb+1<eg;eb++){d7=[];eh=[];d7.push(a6[0][0]);d7.push(a6[0][1]);d7.push(a6[0][2]);eh.push(a6[0][9]);eh.push(a6[0][10]);eh.push(a6[0][11]);eh.push(a6[0][12]);for(d9=0;d9<2;d9++){for(d6=0;d6<3;d6++){d7.push(a6[eb+d9][d6])}}for(d9=0;d9<2;d9++){for(d6=9;d6<13;d6++){eh.push(a6[eb+d9][d6])}}if(b9){be(d7,"LINE_STRIP",eh)}}if(aC||dO){dh(d5,"TRIANGLE_FAN",ee,ea)}}}else{if(dM===16){for(eb=0;eb+3<eg;eb+=4){d7=[];for(d9=0;d9<4;d9++){ed=a6[eb+d9];for(d6=0;d6<3;d6++){d7.push(ed[d6])}}if(b9){be(d7,"LINE_LOOP",eh)}if(aC){d5=[];ee=[];ea=[];for(d9=0;d9<3;d9++){d5.push(a6[eb][d9])}for(d9=5;d9<9;d9++){ee.push(a6[eb][d9])}for(d9=0;d9<3;d9++){d5.push(a6[eb+1][d9])}for(d9=5;d9<9;d9++){ee.push(a6[eb+1][d9])}for(d9=0;d9<3;d9++){d5.push(a6[eb+3][d9])}for(d9=5;d9<9;d9++){ee.push(a6[eb+3][d9])}for(d9=0;d9<3;d9++){d5.push(a6[eb+2][d9])}for(d9=5;d9<9;d9++){ee.push(a6[eb+2][d9])}if(dO){ea.push(a6[eb+0][3]);ea.push(a6[eb+0][4]);ea.push(a6[eb+1][3]);ea.push(a6[eb+1][4]);ea.push(a6[eb+3][3]);ea.push(a6[eb+3][4]);ea.push(a6[eb+2][3]);ea.push(a6[eb+2][4])}dh(d5,"TRIANGLE_STRIP",ee,ea)}}}else{if(dM===17){var ef=[];if(eg>3){for(eb=0;eb<2;eb++){ed=a6[eb];for(d9=0;d9<3;d9++){d7.push(ed[d9])}}for(eb=0;eb<2;eb++){ed=a6[eb];for(d9=9;d9<13;d9++){eh.push(ed[d9])}}be(d7,"LINE_STRIP",eh);if(eg>4&&eg%2>0){ef=d5.splice(d5.length-3);a6.pop()}for(eb=0;eb+3<eg;eb+=2){d7=[];eh=[];for(d9=0;d9<3;d9++){d7.push(a6[eb+1][d9])}for(d9=0;d9<3;d9++){d7.push(a6[eb+3][d9])}for(d9=0;d9<3;d9++){d7.push(a6[eb+2][d9])}for(d9=0;d9<3;d9++){d7.push(a6[eb+0][d9])}for(d9=9;d9<13;d9++){eh.push(a6[eb+1][d9])}for(d9=9;d9<13;d9++){eh.push(a6[eb+3][d9])}for(d9=9;d9<13;d9++){eh.push(a6[eb+2][d9])}for(d9=9;d9<13;d9++){eh.push(a6[eb+0][d9])}if(b9){be(d7,"LINE_STRIP",eh)}}if(aC||dO){dh(d5,"TRIANGLE_LIST",ee,ea)}}}else{if(eg===1){for(d9=0;d9<3;d9++){d7.push(a6[0][d9])}for(d9=9;d9<13;d9++){eh.push(a6[0][d9])}dW(d7,eh)}else{for(eb=0;eb<eg;eb++){ed=a6[eb];for(d9=0;d9<3;d9++){d7.push(ed[d9])}for(d9=5;d9<9;d9++){eh.push(ed[d9])}}if(b9&&d8){be(d7,"LINE_LOOP",eh)}else{if(b9&&!d8){be(d7,"LINE_STRIP",eh)}}if(aC||dO){dh(d5,"TRIANGLE_FAN",ee,ea)}}}}}}}}}dO=false;d3.useProgram(ds);dU("usingTexture3d",ds,"uUsingTexture",dO)}}dK=false;V=false;b6=[];cX=0};var aT=function(d8,d7){var d9=1/d8;var d6=d9*d9;var d5=d6*d9;d7.set(0,0,0,1,d5,d6,d9,0,6*d5,2*d6,0,0,6*d5,0,0,0)};var dl=function(){if(!aG){cY=new aK;aG=new aK;cH=true}var d5=aE;cY.set((d5-1)/2,(d5+3)/2,(-3-d5)/2,(1-d5)/2,1-d5,(-5-d5)/2,d5+2,(d5-1)/2,(d5-1)/2,0,(1-d5)/2,0,0,1,0,0);aT(L,aG);if(!b8){aL=new aK}aL.set(cY);aL.preApply(b8);aG.apply(cY)};bM.prototype.bezierVertex=function(){V=true;var d5=[];if(dp){throw"vertex() must be used at least once before calling bezierVertex()"}for(var d6=0;d6<arguments.length;d6++){d5[d6]=arguments[d6]}a6.push(d5);a6[a6.length-1]["isVert"]=false};bw.prototype.bezierVertex=function(){V=true;var ec=[];if(dp){throw"vertex() must be used at least once before calling bezierVertex()"}if(arguments.length===9){if(bu===d){bu=new aK}var eh=a6.length-1;aT(ct,bu);bu.apply(P);var ej=bu.array();var d8=a6[eh][0],ei=a6[eh][1],eb=a6[eh][2];var ee=ej[4]*d8+ej[5]*arguments[0]+ej[6]*arguments[3]+ej[7]*arguments[6];var ed=ej[8]*d8+ej[9]*arguments[0]+ej[10]*arguments[3]+ej[11]*arguments[6];var ea=ej[12]*d8+ej[13]*arguments[0]+ej[14]*arguments[3]+ej[15]*arguments[6];var ek=ej[4]*ei+ej[5]*arguments[1]+ej[6]*arguments[4]+ej[7]*arguments[7];var eg=ej[8]*ei+ej[9]*arguments[1]+ej[10]*arguments[4]+ej[11]*arguments[7];var ef=ej[12]*ei+ej[13]*arguments[1]+ej[14]*arguments[4]+ej[15]*arguments[7];var d7=ej[4]*eb+ej[5]*arguments[2]+ej[6]*arguments[5]+ej[7]*arguments[8];var d6=ej[8]*eb+ej[9]*arguments[2]+ej[10]*arguments[5]+ej[11]*arguments[8];var d5=ej[12]*eb+ej[13]*arguments[2]+ej[14]*arguments[5]+ej[15]*arguments[8];for(var d9=0;d9<ct;d9++){d8+=ee;ee+=ed;ed+=ea;ei+=ek;ek+=eg;eg+=ef;eb+=d7;d7+=d6;d6+=d5;cR.vertex(d8,ei,eb)}cR.vertex(arguments[6],arguments[7],arguments[8])}};cR.texture=function(d8){var d6=dT.$ensureContext();if(d8.__texture){d6.bindTexture(d6.TEXTURE_2D,d8.__texture)}else{if(d8.localName==="canvas"){d6.bindTexture(d6.TEXTURE_2D,c2);d6.texImage2D(d6.TEXTURE_2D,0,d6.RGBA,d6.RGBA,d6.UNSIGNED_BYTE,d8);d6.texParameteri(d6.TEXTURE_2D,d6.TEXTURE_MAG_FILTER,d6.LINEAR);d6.texParameteri(d6.TEXTURE_2D,d6.TEXTURE_MIN_FILTER,d6.LINEAR);d6.generateMipmap(d6.TEXTURE_2D);cn.width=d8.width;cn.height=d8.height}else{var d7=d6.createTexture(),ea=v.createElement("canvas"),d5=ea.getContext("2d"),d9;if(d8.width&d8.width-1===0){ea.width=d8.width}else{d9=1;while(d9<d8.width){d9*=2}ea.width=d9}if(d8.height&d8.height-1===0){ea.height=d8.height}else{d9=1;while(d9<d8.height){d9*=2}ea.height=d9}d5.drawImage(d8.sourceImg,0,0,d8.width,d8.height,0,0,ea.width,ea.height);d6.bindTexture(d6.TEXTURE_2D,d7);d6.texParameteri(d6.TEXTURE_2D,d6.TEXTURE_MIN_FILTER,d6.LINEAR_MIPMAP_LINEAR);d6.texParameteri(d6.TEXTURE_2D,d6.TEXTURE_MAG_FILTER,d6.LINEAR);d6.texParameteri(d6.TEXTURE_2D,d6.TEXTURE_WRAP_T,d6.CLAMP_TO_EDGE);d6.texParameteri(d6.TEXTURE_2D,d6.TEXTURE_WRAP_S,d6.CLAMP_TO_EDGE);d6.texImage2D(d6.TEXTURE_2D,0,d6.RGBA,d6.RGBA,d6.UNSIGNED_BYTE,ea);d6.generateMipmap(d6.TEXTURE_2D);d8.__texture=d7;cn.width=d8.width;cn.height=d8.height}}dO=true;d6.useProgram(ds);dU("usingTexture3d",ds,"uUsingTexture",dO)};cR.textureMode=function(d5){dZ=d5};var am=function(eq,eb,eh,eo,ea,eg,em,d9,ef,ek,d8,ed){var er=eo;var ec=ea;var ei=eg;var ee=aG.array();var ep=ee[4]*eq+ee[5]*eo+ee[6]*em+ee[7]*ek;var en=ee[8]*eq+ee[9]*eo+ee[10]*em+ee[11]*ek;var el=ee[12]*eq+ee[13]*eo+ee[14]*em+ee[15]*ek;var eu=ee[4]*eb+ee[5]*ea+ee[6]*d9+ee[7]*d8;var et=ee[8]*eb+ee[9]*ea+ee[10]*d9+ee[11]*d8;var es=ee[12]*eb+ee[13]*ea+ee[14]*d9+ee[15]*d8;var d7=ee[4]*eh+ee[5]*eg+ee[6]*ef+ee[7]*ed;var d6=ee[8]*eh+ee[9]*eg+ee[10]*ef+ee[11]*ed;var d5=ee[12]*eh+ee[13]*eg+ee[14]*ef+ee[15]*ed;cR.vertex(er,ec,ei);for(var ej=0;ej<L;ej++){er+=ep;ep+=en;en+=el;ec+=eu;eu+=et;et+=es;ei+=d7;d7+=d6;d6+=d5;cR.vertex(er,ec,ei)}};bM.prototype.curveVertex=function(d5,d6){dK=true;cR.vertex(d5,d6)};bw.prototype.curveVertex=function(d5,d8,d7){dK=true;if(!cH){dl()}var d6=[];d6[0]=d5;d6[1]=d8;d6[2]=d7;b6.push(d6);cX++;if(cX>3){am(b6[cX-4][0],b6[cX-4][1],b6[cX-4][2],b6[cX-3][0],b6[cX-3][1],b6[cX-3][2],b6[cX-2][0],b6[cX-2][1],b6[cX-2][2],b6[cX-1][0],b6[cX-1][1],b6[cX-1][2])}};bM.prototype.curve=function(ea,ec,d8,eb,d6,d9,d5,d7){cR.beginShape();cR.curveVertex(ea,ec);cR.curveVertex(d8,eb);cR.curveVertex(d6,d9);cR.curveVertex(d5,d7);cR.endShape()};bw.prototype.curve=function(d7,ef,eb,d6,ee,ea,d5,ed,d9,eg,ec,d8){if(d8!==d){cR.beginShape();cR.curveVertex(d7,ef,eb);cR.curveVertex(d6,ee,ea);cR.curveVertex(d5,ed,d9);cR.curveVertex(eg,ec,d8);cR.endShape();return}cR.beginShape();cR.curveVertex(d7,ef);cR.curveVertex(eb,d6);cR.curveVertex(ee,ea);cR.curveVertex(d5,ed);cR.endShape()};cR.curveTightness=function(d5){aE=d5};cR.curveDetail=function(d5){L=d5;dl()};cR.rectMode=function(d5){bF=d5};cR.imageMode=function(d5){switch(d5){case 0:bf=aU;break;case 1:bf=bW;break;case 3:bf=aI;break;default:throw"Invalid imageMode"}};cR.ellipseMode=function(d5){cI=d5};cR.arc=function(eh,ef,d8,ej,d7,eg){if(d8<=0||eg<d7){return}if(cI===1){d8=d8-eh;ej=ej-ef}else{if(cI===2){eh=eh-d8;ef=ef-ej;d8=d8*2;ej=ej*2}else{if(cI===3){eh=eh-d8/2;ef=ef-ej/2}}}while(d7<0){d7+=6.283185307179586;eg+=6.283185307179586}if(eg-d7>6.283185307179586){d7=0;eg=6.283185307179586}var ei=d8/2,ek=ej/2,ec=eh+ei,ea=ef+ek,d6=0|0.5+d7*cR.RAD_TO_DEG*2,ee=0|0.5+eg*cR.RAD_TO_DEG*2,ed,eb;if(aC){var d9=b9;b9=false;cR.beginShape();cR.vertex(ec,ea);for(ed=d6;ed<=ee;ed++){eb=ed%720;cR.vertex(ec+bg[eb]*ei,ea+ac[eb]*ek)}cR.endShape(2);b9=d9}if(b9){var d5=aC;aC=false;cR.beginShape();for(ed=d6;ed<=ee;ed++){eb=ed%720;cR.vertex(ec+bg[eb]*ei,ea+ac[eb]*ek)}cR.endShape();aC=d5}};bM.prototype.line=function(d6,ed,d5,eb){if(!b9){return}d6=p.round(d6);d5=p.round(d5);ed=p.round(ed);eb=p.round(eb);if(d6===d5&&ed===eb){cR.point(d6,ed);return}var d7=d,ee=d,ea=true,ec=dE.array(),d8=[1,0,0,0,1,0];for(var d9=0;d9<6&&ea;d9++){ea=ec[d9]===d8[d9]}if(ea){if(d6===d5){if(ed>eb){d7=ed;ed=eb;eb=d7}eb++;if(dR%2===1){d3.translate(0.5,0)}}else{if(ed===eb){if(d6>d5){d7=d6;d6=d5;d5=d7}d5++;if(dR%2===1){d3.translate(0,0.5)}}}if(dR===1){ee=d3.lineCap;d3.lineCap="butt"}}d3.beginPath();d3.moveTo(d6||0,ed||0);d3.lineTo(d5||0,eb||0);c8();if(ea){if(d6===d5&&dR%2===1){d3.translate(-0.5,0)}else{if(ed===eb&&dR%2===1){d3.translate(0,-0.5)}}if(dR===1){d3.lineCap=ee}}};bw.prototype.line=function(d7,ea,ec,d6,d8,eb){if(d8===d||eb===d){eb=0;d8=d6;d6=ec;ec=0}if(d7===d6&&ea===d8&&ec===eb){cR.point(d7,ea,ec);return}var d9=[d7,ea,ec,d6,d8,eb];var d5=new aK;d5.scale(1,-1,1);d5.apply(dE.array());d5.transpose();if(dR>0&&b9){d3.useProgram(dL);a4("uModel2d",dL,"uModel",false,[1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]);a4("uView2d",dL,"uView",false,d5.array());dX("uColor2d",dL,"uColor",cV);dU("uIsDrawingText",dL,"uIsDrawingText",false);c7("aVertex2d",dL,"aVertex",3,b3);cb("aTextureCoord2d",dL,"aTextureCoord");d3.bufferData(d3.ARRAY_BUFFER,new e(d9),d3.STREAM_DRAW);d3.drawArrays(d3.LINES,0,2)}};bM.prototype.bezier=function(){if(arguments.length!==8){throw"You must use 8 parameters for bezier() in 2D mode"}cR.beginShape();cR.vertex(arguments[0],arguments[1]);cR.bezierVertex(arguments[2],arguments[3],arguments[4],arguments[5],arguments[6],arguments[7]);cR.endShape()};bw.prototype.bezier=function(){if(arguments.length!==12){throw"You must use 12 parameters for bezier() in 3D mode"}cR.beginShape();cR.vertex(arguments[0],arguments[1],arguments[2]);cR.bezierVertex(arguments[3],arguments[4],arguments[5],arguments[6],arguments[7],arguments[8],arguments[9],arguments[10],arguments[11]);cR.endShape()};cR.bezierDetail=function(d5){ct=d5};cR.bezierPoint=function(d6,d5,d9,d8,d7){return(1-d7)*(1-d7)*(1-d7)*d6+3*(1-d7)*(1-d7)*d7*d5+3*(1-d7)*d7*d7*d9+d7*d7*d7*d8};cR.bezierTangent=function(d6,d5,d9,d8,d7){return 3*d7*d7*(-d6+3*d5-3*d9+d8)+6*d7*(d6-2*d5+d9)+3*(-d6+d5)};cR.curvePoint=function(d6,d5,d9,d8,d7){return 0.5*(2*d5+(-d6+d9)*d7+(2*d6-5*d5+4*d9-d8)*d7*d7+(-d6+3*d5-3*d9+d8)*d7*d7*d7)};cR.curveTangent=function(d6,d5,d9,d8,d7){return 0.5*(-d6+d9+2*(2*d6-5*d5+4*d9-d8)*d7+3*(-d6+3*d5-3*d9+d8)*d7*d7)};cR.triangle=function(d8,ea,d6,d9,d5,d7){cR.beginShape(9);cR.vertex(d8,ea,0);cR.vertex(d6,d9,0);cR.vertex(d5,d7,0);cR.endShape()};cR.quad=function(ea,ec,d8,eb,d6,d9,d5,d7){cR.beginShape(16);cR.vertex(ea,ec,0);cR.vertex(d8,eb,0);cR.vertex(d6,d9,0);cR.vertex(d5,d7,0);cR.endShape()};var bI=function(eb,ea,d5,ec,ee,d9,ed,d6){if(d6===d){d9=ee;ed=ee;d6=ee}var d7=d5/2,d8=ec/2;if(ee>d7||ee>d8){ee=p.min(d7,d8)}if(d9>d7||d9>d8){d9=p.min(d7,d8)}if(ed>d7||ed>d8){ed=p.min(d7,d8)}if(d6>d7||d6>d8){d6=p.min(d7,d8)}if(!aC||b9){d3.translate(0.5,0.5)}d3.beginPath();d3.moveTo(eb+ee,ea);d3.lineTo(eb+d5-d9,ea);d3.quadraticCurveTo(eb+d5,ea,eb+d5,ea+d9);d3.lineTo(eb+d5,ea+ec-ed);d3.quadraticCurveTo(eb+d5,ea+ec,eb+d5-ed,ea+ec);d3.lineTo(eb+d6,ea+ec);d3.quadraticCurveTo(eb,ea+ec,eb,ea+ec-d6);d3.lineTo(eb,ea+ee);d3.quadraticCurveTo(eb,ea,eb+ee,ea);if(!aC||b9){d3.translate(-0.5,-0.5)}bi();c8()};bM.prototype.rect=function(d6,ec,d9,d5,d7,ea,d8,eb){if(!d9&&!d5){return}if(bF===1){d9-=d6;d5-=ec}else{if(bF===2){d9*=2;d5*=2;d6-=d9/2;ec-=d5/2}else{if(bF===3){d6-=d9/2;ec-=d5/2}}}d6=p.round(d6);ec=p.round(ec);d9=p.round(d9);d5=p.round(d5);if(d7!==d){bI(d6,ec,d9,d5,d7,ea,d8,eb);return}if(b9&&dR%2===1){d3.translate(0.5,0.5)}d3.beginPath();d3.rect(d6,ec,d9,d5);bi();c8();if(b9&&dR%2===1){d3.translate(-0.5,-0.5)}};bw.prototype.rect=function(ed,ec,d5,ef,eh,ea,eg,d6){if(eh!==d){throw"rect() with rounded corners is not supported in 3D mode"}if(bF===1){d5-=ed;ef-=ec}else{if(bF===2){d5*=2;ef*=2;ed-=d5/2;ec-=ef/2}else{if(bF===3){ed-=d5/2;ec-=ef/2}}}var d9=new aK;d9.translate(ed,ec,0);d9.scale(d5,ef,1);d9.transpose();var eb=new aK;eb.scale(1,-1,1);eb.apply(dE.array());eb.transpose();if(dR>0&&b9){d3.useProgram(dL);a4("uModel2d",dL,"uModel",false,d9.array());a4("uView2d",dL,"uView",false,eb.array());dX("uColor2d",dL,"uColor",cV);dU("uIsDrawingText2d",dL,"uIsDrawingText",false);c7("aVertex2d",dL,"aVertex",3,aw);cb("aTextureCoord2d",dL,"aTextureCoord");d3.drawArrays(d3.LINE_LOOP,0,af.length/3)}if(aC){d3.useProgram(ds);a4("uModel3d",ds,"uModel",false,d9.array());a4("uView3d",ds,"uView",false,eb.array());d3.enable(d3.POLYGON_OFFSET_FILL);d3.polygonOffset(1,1);dX("color3d",ds,"uColor",bj);if(dG>0){var ee=new aK;ee.set(eb);var d7=new aK;d7.set(d9);ee.mult(d7);var d8=new aK;d8.set(ee);d8.invert();d8.transpose();a4("uNormalTransform3d",ds,"uNormalTransform",false,d8.array());c7("aNormal3d",ds,"aNormal",3,bX)}else{cb("normal3d",ds,"aNormal")}c7("vertex3d",ds,"aVertex",3,aw);d3.drawArrays(d3.TRIANGLE_FAN,0,af.length/3);d3.disable(d3.POLYGON_OFFSET_FILL)}};bM.prototype.ellipse=function(eb,ea,d6,ed){eb=eb||0;ea=ea||0;if(d6<=0&&ed<=0){return}if(cI===2){d6*=2;ed*=2}else{if(cI===1){d6=d6-eb;ed=ed-ea;eb+=d6/2;ea+=ed/2}else{if(cI===0){eb+=d6/2;ea+=ed/2}}}if(d6===ed){d3.beginPath();d3.arc(eb,ea,d6/2,0,6.283185307179586,false);bi();c8()}else{var ec=d6/2,d9=ed/2,d5=0.5522847498307933,d8=d5*ec,d7=d5*d9;cR.beginShape();cR.vertex(eb+ec,ea);cR.bezierVertex(eb+ec,ea-d7,eb+d8,ea-d9,eb,ea-d9);cR.bezierVertex(eb-d8,ea-d9,eb-ec,ea-d7,eb-ec,ea);cR.bezierVertex(eb-ec,ea+d7,eb-d8,ea+d9,eb,ea+d9);cR.bezierVertex(eb+d8,ea+d9,eb+ec,ea+d7,eb+ec,ea);cR.endShape()}};bw.prototype.ellipse=function(ei,eh,d7,ek){ei=ei||0;eh=eh||0;if(d7<=0&&ek<=0){return}if(cI===2){d7*=2;ek*=2}else{if(cI===1){d7=d7-ei;ek=ek-eh;ei+=d7/2;eh+=ek/2}else{if(cI===0){ei+=d7/2;eh+=ek/2}}}var ej=d7/2,ee=ek/2,d5=0.5522847498307933,d9=d5*ej,d8=d5*ee;cR.beginShape();cR.vertex(ei+ej,eh);cR.bezierVertex(ei+ej,eh-d8,0,ei+d9,eh-ee,0,ei,eh-ee,0);cR.bezierVertex(ei-d9,eh-ee,0,ei-ej,eh-d8,0,ei-ej,eh,0);cR.bezierVertex(ei-ej,eh+d8,0,ei-d9,eh+ee,0,ei,eh+ee,0);cR.bezierVertex(ei+d9,eh+ee,0,ei+ej,eh+d8,0,ei+ej,eh,0);cR.endShape();if(aC){var ea=0,ef=0,ec,eb;for(ec=0;ec<a6.length;ec++){ea+=a6[ec][0];ef+=a6[ec][1]}ea/=a6.length;ef/=a6.length;var ed=[],d6=[],eg=[];ed[0]=ea;ed[1]=ef;ed[2]=0;ed[3]=0;ed[4]=0;ed[5]=bj[0];ed[6]=bj[1];ed[7]=bj[2];ed[8]=bj[3];ed[9]=cV[0];ed[10]=cV[1];ed[11]=cV[2];ed[12]=cV[3];ed[13]=a3;ed[14]=a2;ed[15]=a1;a6.unshift(ed);for(ec=0;ec<a6.length;ec++){for(eb=0;eb<3;eb++){d6.push(a6[ec][eb])}for(eb=5;eb<9;eb++){eg.push(a6[ec][eb])}}dh(d6,"TRIANGLE_FAN",eg)}};cR.normal=function(d5,d7,d6){if(arguments.length!==3||!(typeof d5==="number"&&typeof d7==="number"&&typeof d6==="number")){throw"normal() requires three numeric arguments."}a3=d5;a2=d7;a1=d6;if(dM!==0){if(aX===0){aX=1}else{if(aX===1){aX=2}}}};cR.save=function(d6,d5){if(d5!==d){return m.open(d5.toDataURL(),"_blank")}return m.open(cR.externals.canvas.toDataURL(),"_blank")};var cr=0;cR.saveFrame=function(d5){if(d5===d){d5="screen-####.png"}var d6=d5.replace(/#+/,function(d8){var d7=""+cr++;while(d7.length<d8.length){d7="0"+d7}return d7});cR.save(d6)};var b7=v.createElement("canvas").getContext("2d");var S=[d,d,d];function bt(ec,d6,eb){var d8=S.shift();if(d8===d){d8={};d8.canvas=v.createElement("canvas");d8.context=d8.canvas.getContext("2d")}S.push(d8);var d7=d8.canvas,d9=d8.context,ea=d6||ec.width,d5=eb||ec.height;d7.width=ea;d7.height=d5;if(!ec){d9.clearRect(0,0,ea,d5)}else{if("data" in ec){d9.putImageData(ec,0,0)}else{d9.clearRect(0,0,ea,d5);d9.drawImage(ec,0,0,ea,d5)}}return d8}function bV(d5){return{getLength:function(d6){return function(){if(d6.isRemote){throw"Image is loaded remotely. Cannot get length."}else{return d6.imageData.data.length?d6.imageData.data.length/4:0}}}(d5),getPixel:function(d6){return function(d7){var d9=d7*4,d8=d6.imageData.data;if(d6.isRemote){throw"Image is loaded remotely. Cannot get pixels."}return(d8[d9+3]&255)<<24|(d8[d9]&255)<<16|(d8[d9+1]&255)<<8|d8[d9+2]&255}}(d5),setPixel:function(d6){return function(d7,ea){var d9=d7*4,d8=d6.imageData.data;if(d6.isRemote){throw"Image is loaded remotely. Cannot set pixel."}d8[d9+0]=ea>>16&255;d8[d9+1]=ea>>8&255;d8[d9+2]=ea&255;d8[d9+3]=ea>>24&255;d6.__isDirty=true}}(d5),toArray:function(d6){return function(){var d7=[],ea=d6.imageData.data,d9=d6.width*d6.height;if(d6.isRemote){throw"Image is loaded remotely. Cannot get pixels."}for(var d8=0,eb=0;d8<d9;d8++,eb+=4){d7.push((ea[eb+3]&255)<<24|(ea[eb]&255)<<16|(ea[eb+1]&255)<<8|ea[eb+2]&255)}return d7}}(d5),set:function(d6){return function(d7){var eb,ea,ec;if(this.isRemote){throw"Image is loaded remotely. Cannot set pixels."}ea=d6.imageData.data;for(var d8=0,d9=d7.length;d8<d9;d8++){ec=d7[d8];eb=d8*4;ea[eb+0]=ec>>16&255;ea[eb+1]=ec>>8&255;ea[eb+2]=ec&255;ea[eb+3]=ec>>24&255}d6.__isDirty=true}}(d5)}}var cB=function(d8,eb,d9){this.__isDirty=false;if(d8 instanceof HTMLImageElement){this.fromHTMLImageData(d8)}else{if(eb||d9){this.width=d8||1;this.height=eb||1;var d6=this.sourceImg=v.createElement("canvas");d6.width=this.width;d6.height=this.height;var ec=this.imageData=d6.getContext("2d").createImageData(this.width,this.height);this.format=d9===2||d9===4?d9:1;if(this.format===1){for(var d7=3,ea=this.imageData.data,d5=ea.length;d7<d5;d7+=4){ea[d7]=255}}this.__isDirty=true;this.updatePixels()}else{this.width=0;this.height=0;this.imageData=b7.createImageData(1,1);this.format=2}}this.pixels=bV(this)};cB.prototype={__isPImage:true,updatePixels:function(){var d5=this.sourceImg;if(d5&&d5 instanceof HTMLCanvasElement&&this.__isDirty){d5.getContext("2d").putImageData(this.imageData,0,0)}this.__isDirty=false},fromHTMLImageData:function(d5){var d6=bt(d5);try{var d8=d6.context.getImageData(0,0,d5.width,d5.height);this.fromImageData(d8)}catch(d7){if(d5.width&&d5.height){this.isRemote=true;this.width=d5.width;this.height=d5.height}}this.sourceImg=d5},get:function(d5,d8,d6,d7){if(!arguments.length){return cR.get(this)}if(arguments.length===2){return cR.get(d5,d8,this)}if(arguments.length===4){return cR.get(d5,d8,d6,d7,this)}},set:function(d5,d7,d6){cR.set(d5,d7,d6,this);this.__isDirty=true},blend:function(ed,d9,d8,d6,eb,ee,ec,ea,d5,d7){if(arguments.length===9){cR.blend(this,ed,d9,d8,d6,eb,ee,ec,ea,d5,this)}else{if(arguments.length===10){cR.blend(ed,d9,d8,d6,eb,ee,ec,ea,d5,d7,this)}}delete this.sourceImg},copy:function(ec,d9,d8,d7,d6,ed,eb,ea,d5){if(arguments.length===8){cR.blend(this,ec,d9,d8,d7,d6,ed,eb,ea,0,this)}else{if(arguments.length===9){cR.blend(ec,d9,d8,d7,d6,ed,eb,ea,d5,0,this)}}delete this.sourceImg},filter:function(d6,d5){if(arguments.length===2){cR.filter(d6,d5,this)}else{if(arguments.length===1){cR.filter(d6,null,this)}}delete this.sourceImg},save:function(d5){cR.save(d5,this)},resize:function(d5,d7){if(this.isRemote){throw"Image is loaded remotely. Cannot resize."}if(this.width!==0||this.height!==0){if(d5===0&&d7!==0){d5=p.floor(this.width/this.height*d7)}else{if(d7===0&&d5!==0){d7=p.floor(this.height/this.width*d5)}}var d6=bt(this.imageData).canvas;var d8=bt(d6,d5,d7).context.getImageData(0,0,d5,d7);this.fromImageData(d8)}},mask:function(d5){var d8=this.toImageData(),d7,d6;if(d5 instanceof cB||d5.__isPImage){if(d5.width===this.width&&d5.height===this.height){d5=d5.toImageData();for(d7=2,d6=this.width*this.height*4;d7<d6;d7+=4){d8.data[d7+1]=d5.data[d7]}}else{throw"mask must have the same dimensions as PImage."}}else{if(d5 instanceof Array){if(this.width*this.height===d5.length){for(d7=0,d6=d5.length;d7<d6;++d7){d8.data[d7*4+3]=d5[d7]}}else{throw"mask array must be the same length as PImage pixels array."}}}this.fromImageData(d8)},loadPixels:i,toImageData:function(){if(this.isRemote){return this.sourceImg}if(!this.__isDirty){return this.imageData}var d5=bt(this.sourceImg);return d5.context.getImageData(0,0,this.width,this.height)},toDataURL:function(){if(this.isRemote){throw"Image is loaded remotely. Cannot create dataURI."}var d5=bt(this.imageData);return d5.canvas.toDataURL()},fromImageData:function(d9){var d6=d9.width,d8=d9.height,d7=v.createElement("canvas"),d5=d7.getContext("2d");this.width=d7.width=d6;this.height=d7.height=d8;d5.putImageData(d9,0,0);this.format=2;this.imageData=d9;this.sourceImg=d7}};cR.PImage=cB;cR.createImage=function(d5,d6,d7){return new cB(d5,d6,d7)};cR.loadImage=function(d6,d7,d9){if(d7){d6=d6+"."+d7}var d8;if(cL.imageCache.images[d6]){d8=new cB(cL.imageCache.images[d6]);d8.loaded=true;return d8}d8=new cB;var d5=v.createElement("img");d8.sourceImg=d5;d5.onload=function(ed,eb,ea){var ee=ed;var ec=eb;var ef=ea;return function(){ec.fromHTMLImageData(ee);ec.loaded=true;if(ef){ef()}}}(d5,d8,d9);d5.src=d6;return d8};cR.requestImage=cR.loadImage;function c4(d5,d8){var d6;if(d5>=cR.width||d5<0||d8<0||d8>=cR.height){return 0}if(dQ){var d7=((0|d5)+cR.width*(0|d8))*4;d6=cR.imageData.data;return(d6[d7+3]&255)<<24|(d6[d7]&255)<<16|(d6[d7+1]&255)<<8|d6[d7+2]&255}d6=cR.toImageData(0|d5,0|d8,1,1).data;return(d6[3]&255)<<24|(d6[0]&255)<<16|(d6[1]&255)<<8|d6[2]&255}function c3(d5,d9,d6){if(d6.isRemote){throw"Image is loaded remotely. Cannot get x,y."}var d8=d9*d6.width*4+d5*4,d7=d6.imageData.data;return(d7[d8+3]&255)<<24|(d7[d8]&255)<<16|(d7[d8+1]&255)<<8|d7[d8+2]&255}function c1(d5,d9,d6,d7){var d8=new cB(d6,d7,2);d8.fromImageData(cR.toImageData(d5,d9,d6,d7));return d8}function c0(ea,d9,eb,eg,em){if(em.isRemote){throw"Image is loaded remotely. Cannot get x,y,w,h."}var ek=new cB(eb,eg,2),d7=ek.imageData.data,d8=em.width,eh=em.height,ej=em.imageData.data;var d5=p.max(0,-d9),d6=p.max(0,-ea),ec=p.min(eg,eh-d9),ed=p.min(eb,d8-ea);for(var ef=d5;ef<ec;++ef){var ei=((d9+ef)*d8+(ea+d6))*4;var el=(ef*eb+d6)*4;for(var ee=d6;ee<ed;++ee){d7[el++]=ej[ei++];d7[el++]=ej[ei++];d7[el++]=ej[ei++];d7[el++]=ej[ei++]}}ek.__isDirty=true;return ek}cR.get=function(d5,d9,d6,d8,d7){if(d7!==undefined){return c0(d5,d9,d6,d8,d7)}if(d8!==undefined){return c1(d5,d9,d6,d8)}if(d6!==undefined){return c3(d5,d9,d6)}if(d9!==undefined){return c4(d5,d9)}if(d5!==undefined){return c0(0,0,d5.width,d5.height,d5)}return c1(0,0,cR.width,cR.height)};cR.createGraphics=function(d5,d7,d6){var d8=new D;d8.size(d5,d7,d6);d8.background(0,0);return d8};function O(){if(dQ){d3=ae;dQ=false;cR.updatePixels()}}function cl(){function d6(ea,d8){function d9(){O();d3[d8].apply(d3,arguments)}ea[d8]=d9}function d5(eb,d9){function d8(){O();return d3[d9]}function ea(ec){O();d3[d9]=ec}cR.defineProperty(eb,d9,{get:d8,set:ea})}for(var d7 in d3){if(typeof d3[d7]==="function"){d6(this,d7)}else{d5(this,d7)}}}function cx(){if(dQ){return}cR.loadPixels();if(ci===null){ae=d3;ci=new cl}dQ=true;d3=ci;dY=0}function bs(d5,d7,d6){if(d5<cR.width&&d5>=0&&d7>=0&&d7<cR.height){cx();cR.pixels.setPixel((0|d5)+cR.width*(0|d7),d6);if(++dY>bU){O()}}}function bq(d5,eb,d8,d6){if(d6.isRemote){throw"Image is loaded remotely. Cannot set x,y."}var ea=cR.color.toArray(d8);var d9=eb*d6.width*4+d5*4;var d7=d6.imageData.data;d7[d9]=ea[0];d7[d9+1]=ea[1];d7[d9+2]=ea[2];d7[d9+3]=ea[3]}cR.set=function(d5,ea,d8,d7){var d6,d9;if(arguments.length===3){if(typeof d8==="number"){bs(d5,ea,d8)}else{if(d8 instanceof cB||d8.__isPImage){cR.image(d8,d5,ea)}}}else{if(arguments.length===4){bq(d5,ea,d8,d7)}}};cR.imageData={};cR.pixels={getLength:function(){return cR.imageData.data.length?cR.imageData.data.length/4:0},getPixel:function(d5){var d7=d5*4,d6=cR.imageData.data;return d6[d7+3]<<24&4278190080|d6[d7+0]<<16&16711680|d6[d7+1]<<8&65280|d6[d7+2]&255},setPixel:function(d5,d8){var d7=d5*4,d6=cR.imageData.data;d6[d7+0]=(d8&16711680)>>>16;d6[d7+1]=(d8&65280)>>>8;d6[d7+2]=d8&255;d6[d7+3]=(d8&4278190080)>>>24},toArray:function(){var d5=[],d7=cR.imageData.width*cR.imageData.height,d8=cR.imageData.data;for(var d6=0,d9=0;d6<d7;d6++,d9+=4){d5.push(d8[d9+3]<<24&4278190080|d8[d9+0]<<16&16711680|d8[d9+1]<<8&65280|d8[d9+2]&255)}return d5},set:function(d5){for(var d6=0,d7=d5.length;d6<d7;d6++){this.setPixel(d6,d5[d6])}}};cR.loadPixels=function(){cR.imageData=dT.$ensureContext().getImageData(0,0,cR.width,cR.height)};cR.updatePixels=function(){if(cR.imageData){dT.$ensureContext().putImageData(cR.imageData,0,0)}};cR.hint=function(d6){var d5=dT.$ensureContext();if(d6===4){d5.disable(d5.DEPTH_TEST);d5.depthMask(false);d5.clear(d5.DEPTH_BUFFER_BIT)}else{if(d6===-4){d5.enable(d5.DEPTH_TEST);d5.depthMask(true)}else{if(d6===-1||d6===2){dJ=true}else{if(d6===1){dJ=false}}}}};var bz=function(d8,d7,d6,d5){var d9;if(d8 instanceof cB||d8.__isPImage){d9=d8;if(!d9.loaded){throw"Error using image in background(): PImage not loaded."}if(d9.width!==cR.width||d9.height!==cR.height){throw"Background image must be the same dimensions as the canvas."}}else{d9=cR.color(d8,d7,d6,d5)}aZ=d9};bM.prototype.background=function(d8,d7,d6,d5){if(d8!==d){bz(d8,d7,d6,d5)}if(aZ instanceof cB||aZ.__isPImage){ay();d3.setTransform(1,0,0,1,0,0);cR.image(aZ,0,0);cK()}else{ay();d3.setTransform(1,0,0,1,0,0);if(cR.alpha(aZ)!==bP){d3.clearRect(0,0,cR.width,cR.height)}d3.fillStyle=cR.color.toString(aZ);d3.fillRect(0,0,cR.width,cR.height);al=true;cK()}};bw.prototype.background=function(d8,d7,d6,d5){if(arguments.length>0){bz(d8,d7,d6,d5)}var d9=cR.color.toGLArray(aZ);d3.clearColor(d9[0],d9[1],d9[2],d9[3]);d3.clear(d3.COLOR_BUFFER_BIT|d3.DEPTH_BUFFER_BIT)};bM.prototype.image=function(d8,ed,eb,ee,d9){ed=p.round(ed);eb=p.round(eb);if(d8.width>0){var ef=ee||d8.width;var ec=d9||d8.height;var d5=bf(ed||0,eb||0,ee||d8.width,d9||d8.height,arguments.length<4);var ea=!!d8.sourceImg&&ba===null;if(ea){var d6=d8.sourceImg;if(d8.__isDirty){d8.updatePixels()}d3.drawImage(d6,0,0,d6.width,d6.height,d5.x,d5.y,d5.w,d5.h)}else{var d7=d8.toImageData();if(ba!==null){ba(d7);d8.__isDirty=true}d3.drawImage(bt(d7).canvas,0,0,d8.width,d8.height,d5.x,d5.y,d5.w,d5.h)}}};bw.prototype.image=function(d7,d5,d9,d6,d8){if(d7.width>0){d5=p.round(d5);d9=p.round(d9);d6=d6||d7.width;d8=d8||d7.height;cR.beginShape(cR.QUADS);cR.texture(d7);cR.vertex(d5,d9,0,0,0);cR.vertex(d5,d9+d8,0,0,d8);cR.vertex(d5+d6,d9+d8,0,d6,d8);cR.vertex(d5+d6,d9,0,d6,0);cR.endShape()}};cR.tint=function(d8,d7,d5,ed){var ea=cR.color(d8,d7,d5,ed);var d6=cR.red(ea)/bE;var d9=cR.green(ea)/bD;var eb=cR.blue(ea)/bB;var ec=cR.alpha(ea)/bP;ba=function(eh){var eg=eh.data,ef=4*eh.width*eh.height;for(var ee=0;ee<ef;){eg[ee++]*=d6;eg[ee++]*=d9;eg[ee++]*=eb;eg[ee++]*=ec}};br=function(ef){for(var ee=0;ee<ef.length;){ef[ee++]=d6;ef[ee++]=d9;ef[ee++]=eb;ef[ee++]=ec}}};cR.noTint=function(){ba=null;br=null};cR.copy=function(d5,ea,d9,eb,d7,ed,ec,d6,d8){if(d8===d){d8=d6;d6=ec;ec=ed;ed=d7;d7=eb;eb=d9;d9=ea;ea=d5;d5=cR}cR.blend(d5,ea,d9,eb,d7,ed,ec,d6,d8,0)};cR.blend=function(d5,ef,ee,ei,ea,ek,ej,d6,ec,eb,d8){if(d5.isRemote){throw"Image is loaded remotely. Cannot blend image."}if(eb===d){eb=ec;ec=d6;d6=ej;ej=ek;ek=ea;ea=ei;ei=ee;ee=ef;ef=d5;d5=cR}var d7=ef+ei,ed=ee+ea,eh=ek+d6,d9=ej+ec,eg=d8||cR;if(d8===d||eb===d){cR.loadPixels()}d5.loadPixels();if(d5===cR&&cR.intersect(ef,ee,d7,ed,ek,ej,eh,d9)){cR.blit_resize(cR.get(ef,ee,d7-ef,ed-ee),0,0,d7-ef-1,ed-ee-1,eg.imageData.data,eg.width,eg.height,ek,ej,eh,d9,eb)}else{cR.blit_resize(d5,ef,ee,d7,ed,eg.imageData.data,eg.width,eg.height,ek,ej,eh,d9,eb)}if(d8===d){cR.updatePixels()}};var bk=function(d9){var d5=cR.floor(d9*3.5),d7,d6;d5=d5<1?1:d5<248?d5:248;if(cR.shared.blurRadius!==d5){cR.shared.blurRadius=d5;cR.shared.blurKernelSize=1+(cR.shared.blurRadius<<1);cR.shared.blurKernel=new e(cR.shared.blurKernelSize);var eb=cR.shared.blurKernel;var ea=cR.shared.blurKernelSize;var d8=cR.shared.blurRadius;for(d7=0;d7<ea;d7++){eb[d7]=0}var ec=(d5-1)*(d5-1);for(d7=1;d7<d5;d7++){eb[d5+d7]=eb[d6]=ec}eb[d5]=d5*d5}};var b2=function(ej,eo){var d7,ea,eg,el,em,ev,en;var eq,ei,eu,et,ek;var ed=eo.pixels.getLength();var ep=new e(ed);var ey=new e(ed);var ec=new e(ed);var ex=new e(ed);var ew=0;var ef,ee,es,d9;bk(ej);var d6=eo.height;var d5=eo.width;var er=cR.shared.blurKernelSize;var eh=cR.shared.blurRadius;var eb=cR.shared.blurKernel;var d8=eo.imageData.data;for(ee=0;ee<d6;ee++){for(ef=0;ef<d5;ef++){el=eg=ea=em=d7=0;eq=ef-eh;if(eq<0){ek=-eq;eq=0}else{if(eq>=d5){break}ek=0}for(es=ek;es<er;es++){if(eq>=d5){break}d9=(eq+ew)*4;en=eb[es];em+=en*d8[d9+3];ea+=en*d8[d9];eg+=en*d8[d9+1];el+=en*d8[d9+2];d7+=en;eq++}ei=ew+ef;ex[ei]=em/d7;ep[ei]=ea/d7;ey[ei]=eg/d7;ec[ei]=el/d7}ew+=d5}ew=0;eu=-eh;et=eu*d5;for(ee=0;ee<d6;ee++){for(ef=0;ef<d5;ef++){el=eg=ea=em=d7=0;if(eu<0){ek=ei=-eu;eq=ef}else{if(eu>=d6){break}ek=0;ei=eu;eq=ef+et}for(es=ek;es<er;es++){if(ei>=d6){break}en=eb[es];em+=en*ex[eq];ea+=en*ep[eq];eg+=en*ey[eq];el+=en*ec[eq];d7+=en;ei++;eq+=d5}d9=(ef+ew)*4;d8[d9]=ea/d7;d8[d9+1]=eg/d7;d8[d9+2]=el/d7;d8[d9+3]=em/d7}ew+=d5;et+=d5;eu++}};var ca=function(em,eg){var ec=0;var eq=eg.pixels.getLength();var eh=new n(eq);var ek,d6,ef,ee,d8;var el,d9,eb,ed,d7,ei,ep,d5,en,ea,eo,ej;if(!em){while(ec<eq){ek=ec;d6=ec+eg.width;while(ec<d6){ef=ee=eg.pixels.getPixel(ec);d9=ec-1;el=ec+1;eb=ec-eg.width;ed=ec+eg.width;if(d9<ek){d9=ec}if(el>=d6){el=ec}if(eb<0){eb=0}if(ed>=eq){ed=ec}ep=eg.pixels.getPixel(eb);ei=eg.pixels.getPixel(d9);d5=eg.pixels.getPixel(ed);d7=eg.pixels.getPixel(el);d8=77*(ef>>16&255)+151*(ef>>8&255)+28*(ef&255);ea=77*(ei>>16&255)+151*(ei>>8&255)+28*(ei&255);en=77*(d7>>16&255)+151*(d7>>8&255)+28*(d7&255);eo=77*(ep>>16&255)+151*(ep>>8&255)+28*(ep&255);ej=77*(d5>>16&255)+151*(d5>>8&255)+28*(d5&255);if(ea>d8){ee=ei;d8=ea}if(en>d8){ee=d7;d8=en}if(eo>d8){ee=ep;d8=eo}if(ej>d8){ee=d5;d8=ej}eh[ec++]=ee}}}else{while(ec<eq){ek=ec;d6=ec+eg.width;while(ec<d6){ef=ee=eg.pixels.getPixel(ec);d9=ec-1;el=ec+1;eb=ec-eg.width;ed=ec+eg.width;if(d9<ek){d9=ec}if(el>=d6){el=ec}if(eb<0){eb=0}if(ed>=eq){ed=ec}ep=eg.pixels.getPixel(eb);ei=eg.pixels.getPixel(d9);d5=eg.pixels.getPixel(ed);d7=eg.pixels.getPixel(el);d8=77*(ef>>16&255)+151*(ef>>8&255)+28*(ef&255);ea=77*(ei>>16&255)+151*(ei>>8&255)+28*(ei&255);en=77*(d7>>16&255)+151*(d7>>8&255)+28*(d7&255);eo=77*(ep>>16&255)+151*(ep>>8&255)+28*(ep&255);ej=77*(d5>>16&255)+151*(d5>>8&255)+28*(d5&255);if(ea<d8){ee=ei;d8=ea}if(en<d8){ee=d7;d8=en}if(eo<d8){ee=ep;d8=eo}if(ej<d8){ee=d5;d8=ej}eh[ec++]=ee}}}eg.pixels.set(eh)};cR.filter=function(ec,eb,d8){var ef,ea,d6,ee;if(arguments.length===3){d8.loadPixels();ef=d8}else{cR.loadPixels();ef=cR}if(eb===d){eb=null}if(ef.isRemote){throw"Image is loaded remotely. Cannot filter image."}var eg=ef.pixels.getLength();switch(ec){case 11:var eh=eb||1;b2(eh,ef);break;case 12:if(ef.format===4){for(ee=0;ee<eg;ee++){ea=255-ef.pixels.getPixel(ee);ef.pixels.setPixel(ee,4278190080|ea<<16|ea<<8|ea)}ef.format=1}else{for(ee=0;ee<eg;ee++){ea=ef.pixels.getPixel(ee);d6=77*(ea>>16&255)+151*(ea>>8&255)+28*(ea&255)>>8;ef.pixels.setPixel(ee,ea&4278190080|d6<<16|d6<<8|d6)}}break;case 13:for(ee=0;ee<eg;ee++){ef.pixels.setPixel(ee,ef.pixels.getPixel(ee)^16777215)}break;case 15:if(eb===null){throw"Use filter(POSTERIZE, int levels) instead of filter(POSTERIZE)"}var ek=cR.floor(eb);if(ek<2||ek>255){throw"Levels must be between 2 and 255 for filter(POSTERIZE, levels)"}var ed=ek-1;for(ee=0;ee<eg;ee++){var d5=ef.pixels.getPixel(ee)>>16&255;var ei=ef.pixels.getPixel(ee)>>8&255;var d7=ef.pixels.getPixel(ee)&255;d5=(d5*ek>>8)*255/ed;ei=(ei*ek>>8)*255/ed;d7=(d7*ek>>8)*255/ed;ef.pixels.setPixel(ee,4278190080&ef.pixels.getPixel(ee)|d5<<16|ei<<8|d7)}break;case 14:for(ee=0;ee<eg;ee++){ef.pixels.setPixel(ee,ef.pixels.getPixel(ee)|4278190080)}ef.format=1;break;case 16:if(eb===null){eb=0.5}if(eb<0||eb>1){throw"Level must be between 0 and 1 for filter(THRESHOLD, level)"}var d9=cR.floor(eb*255);for(ee=0;ee<eg;ee++){var ej=cR.max((ef.pixels.getPixel(ee)&16711680)>>16,cR.max((ef.pixels.getPixel(ee)&65280)>>8,ef.pixels.getPixel(ee)&255));ef.pixels.setPixel(ee,ef.pixels.getPixel(ee)&4278190080|(ej<d9?0:16777215))}break;case 17:ca(true,ef);break;case 18:ca(false,ef);break}ef.updatePixels()};cR.shared={fracU:0,ifU:0,fracV:0,ifV:0,u1:0,u2:0,v1:0,v2:0,sX:0,sY:0,iw:0,iw1:0,ih1:0,ul:0,ll:0,ur:0,lr:0,cUL:0,cLL:0,cUR:0,cLR:0,srcXOffset:0,srcYOffset:0,r:0,g:0,b:0,a:0,srcBuffer:null,blurRadius:0,blurKernelSize:0,blurKernel:null};cR.intersect=function(d7,ee,d6,ed,ei,eb,eh,ea){var eg=d6-d7+1;var d9=ed-ee+1;var d5=eh-ei+1;var ec=ea-eb+1;if(ei<d7){d5+=ei-d7;if(d5>eg){d5=eg}}else{var ef=eg+d7-ei;if(d5>ef){d5=ef}}if(eb<ee){ec+=eb-ee;if(ec>d9){ec=d9}}else{var d8=d9+ee-eb;if(ec>d8){ec=d8}}return !(d5<=0||ec<=0)};var dN={};dN[1]=cR.modes.blend;dN[2]=cR.modes.add;dN[4]=cR.modes.subtract;dN[8]=cR.modes.lightest;dN[16]=cR.modes.darkest;dN[0]=cR.modes.replace;dN[32]=cR.modes.difference;dN[64]=cR.modes.exclusion;dN[128]=cR.modes.multiply;dN[256]=cR.modes.screen;dN[512]=cR.modes.overlay;dN[1024]=cR.modes.hard_light;dN[2048]=cR.modes.soft_light;dN[4096]=cR.modes.dodge;dN[8192]=cR.modes.burn;cR.blit_resize=function(ei,eu,eo,et,en,ez,ee,em,es,ej,er,eh,ek){var ex,ew;if(eu<0){eu=0}if(eo<0){eo=0}if(et>=ei.width){et=ei.width-1}if(en>=ei.height){en=ei.height-1}var eD=et-eu;var eI=en-eo;var d5=er-es;var ef=eh-ej;if(d5<=0||ef<=0||eD<=0||eI<=0||es>=ee||ej>=em||eu>=ei.width||eo>=ei.height){return}var ec=p.floor(eD/d5*32768);var d9=p.floor(eI/ef*32768);var eB=cR.shared;eB.srcXOffset=p.floor(es<0?-es*ec:eu*32768);eB.srcYOffset=p.floor(ej<0?-ej*d9:eo*32768);if(es<0){d5+=es;es=0}if(ej<0){ef+=ej;ej=0}d5=p.min(d5,ee-es);ef=p.min(ef,em-ej);var ep=ej*ee+es;var eL;eB.srcBuffer=ei.imageData.data;eB.iw=ei.width;eB.iw1=ei.width-1;eB.ih1=ei.height-1;var eq=cR.filter_bilinear,eF=cR.filter_new_scanline,ed=dN[ek],eC,eH,eA,eE,d7,d8,d6=4278190080,eG=16711680,ev=65280,eb=255,eK=32767,ey=15,eg=1,el=9,ea=eB.srcBuffer,eJ=p.min;for(ew=0;ew<ef;ew++){eB.sX=eB.srcXOffset;eB.fracV=eB.srcYOffset&eK;eB.ifV=eK-eB.fracV;eB.v1=(eB.srcYOffset>>ey)*eB.iw;eB.v2=eJ((eB.srcYOffset>>ey)+1,eB.ih1)*eB.iw;for(ex=0;ex<d5;ex++){eH=(ep+ex)*4;eL=ez[eH+3]<<24&d6|ez[eH]<<16&eG|ez[eH+1]<<8&ev|ez[eH+2]&eb;eB.fracU=eB.sX&eK;eB.ifU=eK-eB.fracU;eB.ul=eB.ifU*eB.ifV>>ey;eB.ll=eB.ifU*eB.fracV>>ey;eB.ur=eB.fracU*eB.ifV>>ey;eB.lr=eB.fracU*eB.fracV>>ey;eB.u1=eB.sX>>ey;eB.u2=eJ(eB.u1+1,eB.iw1);eA=(eB.v1+eB.u1)*4;eE=(eB.v1+eB.u2)*4;d7=(eB.v2+eB.u1)*4;d8=(eB.v2+eB.u2)*4;eB.cUL=ea[eA+3]<<24&d6|ea[eA]<<16&eG|ea[eA+1]<<8&ev|ea[eA+2]&eb;eB.cUR=ea[eE+3]<<24&d6|ea[eE]<<16&eG|ea[eE+1]<<8&ev|ea[eE+2]&eb;eB.cLL=ea[d7+3]<<24&d6|ea[d7]<<16&eG|ea[d7+1]<<8&ev|ea[d7+2]&eb;eB.cLR=ea[d8+3]<<24&d6|ea[d8]<<16&eG|ea[d8+1]<<8&ev|ea[d8+2]&eb;eB.r=eB.ul*((eB.cUL&eG)>>16)+eB.ll*((eB.cLL&eG)>>16)+eB.ur*((eB.cUR&eG)>>16)+eB.lr*((eB.cLR&eG)>>16)<<eg&eG;eB.g=eB.ul*(eB.cUL&ev)+eB.ll*(eB.cLL&ev)+eB.ur*(eB.cUR&ev)+eB.lr*(eB.cLR&ev)>>>ey&ev;eB.b=eB.ul*(eB.cUL&eb)+eB.ll*(eB.cLL&eb)+eB.ur*(eB.cUR&eb)+eB.lr*(eB.cLR&eb)>>>ey;eB.a=eB.ul*((eB.cUL&d6)>>>24)+eB.ll*((eB.cLL&d6)>>>24)+eB.ur*((eB.cUR&d6)>>>24)+eB.lr*((eB.cLR&d6)>>>24)<<el&d6;eC=ed(eL,eB.a|eB.r|eB.g|eB.b);ez[eH]=(eC&eG)>>>16;ez[eH+1]=(eC&ev)>>>8;ez[eH+2]=eC&eb;ez[eH+3]=(eC&d6)>>>24;eB.sX+=ec}ep+=ee;eB.srcYOffset+=d9}};cR.loadFont=function(d6,d7){if(d6===d){throw"font name required in loadFont."}if(d6.indexOf(".svg")===-1){if(d7===d){d7=R.size}return g.get(d6,d7)}var d5=cR.loadGlyphs(d6);return{name:d6,css:"12px sans-serif",glyph:true,units_per_em:d5.units_per_em,horiz_adv_x:1/d5.units_per_em*d5.horiz_adv_x,ascent:d5.ascent,descent:d5.descent,width:function(ec){var ea=0;var d8=ec.length;for(var d9=0;d9<d8;d9++){try{ea+=parseFloat(cR.glyphLook(cR.glyphTable[d6],ec[d9]).horiz_adv_x)}catch(eb){D.debug(eb)}}return ea/cR.glyphTable[d6].units_per_em}}};cR.createFont=function(d5,d6){return cR.loadFont(d5,d6)};cR.textFont=function(d5,d7){if(d7!==d){if(!d5.glyph){d5=g.get(d5.name,d7)}dV=d7}R=d5;T=R.name;aY=R.ascent;dv=R.descent;d2=R.leading;var d6=dT.$ensureContext();d6.font=R.css};cR.textSize=function(d6){R=g.get(T,d6);dV=d6;aY=R.ascent;dv=R.descent;d2=R.leading;var d5=dT.$ensureContext();d5.font=R.css};cR.textAscent=function(){return aY};cR.textDescent=function(){return dv};cR.textLeading=function(d5){d2=d5};cR.textAlign=function(d6,d5){I=d6;cW=d5||0};function bp(d5){if(d5 instanceof String){return d5}if(typeof d5==="number"){if(d5===(0|d5)){return d5.toString()}return cR.nf(d5,0,3)}if(d5===null||d5===d){return""}return d5.toString()}bM.prototype.textWidth=function(d9){var d5=bp(d9).split(/\r?\n/g),d7=0;var d6,d8=d5.length;d3.font=R.css;for(d6=0;d6<d8;++d6){d7=p.max(d7,R.measureTextWidth(d5[d6]))}return d7|0};bw.prototype.textWidth=function(ea){var d5=bp(ea).split(/\r?\n/g),d8=0;var d7,d9=d5.length;if(cz===d){cz=v.createElement("canvas")}var d6=cz.getContext("2d");d6.font=R.css;for(d7=0;d7<d9;++d7){d8=p.max(d8,d6.measureText(d5[d7]).width)}return d8|0};cR.glyphLook=function(d5,d6){try{switch(d6){case"1":return d5.one;case"2":return d5.two;case"3":return d5.three;case"4":return d5.four;case"5":return d5.five;case"6":return d5.six;case"7":return d5.seven;case"8":return d5.eight;case"9":return d5.nine;case"0":return d5.zero;case" ":return d5.space;case"$":return d5.dollar;case"!":return d5.exclam;case'"':return d5.quotedbl;case"#":return d5.numbersign;case"%":return d5.percent;case"&":return d5.ampersand;case"'":return d5.quotesingle;case"(":return d5.parenleft;case")":return d5.parenright;case"*":return d5.asterisk;case"+":return d5.plus;case",":return d5.comma;case"-":return d5.hyphen;case".":return d5.period;case"/":return d5.slash;case"_":return d5.underscore;case":":return d5.colon;case";":return d5.semicolon;case"<":return d5.less;case"=":return d5.equal;case">":return d5.greater;case"?":return d5.question;case"@":return d5.at;case"[":return d5.bracketleft;case"\\":return d5.backslash;case"]":return d5.bracketright;case"^":return d5.asciicircum;case"`":return d5.grave;case"{":return d5.braceleft;case"|":return d5.bar;case"}":return d5.braceright;case"~":return d5.asciitilde;default:return d5[d6]}}catch(d7){D.debug(d7)}};bM.prototype.text$line=function(ed,eg,ef,ee,ea){var ec=0,eb=0;if(!R.glyph){if(ed&&"fillText" in d3){if(al){d3.fillStyle=cR.color.toString(aW);al=false}if(ea===39||ea===3){ec=R.measureTextWidth(ed);if(ea===39){eb=-ec}else{eb=-ec/2}}d3.fillText(ed,eg+eb,ef)}}else{var d5=cR.glyphTable[T];ay();d3.translate(eg,ef+dV);if(ea===39||ea===3){ec=d5.width(ed);if(ea===39){eb=-ec}else{eb=-ec/2}}var eh=d5.units_per_em,d9=1/eh*dV;d3.scale(d9,d9);for(var d6=0,d7=ed.length;d6<d7;d6++){try{cR.glyphLook(d5,ed[d6]).draw()}catch(d8){D.debug(d8)}}cK()}};bw.prototype.text$line=function(ec,eg,ef,ed,ea){if(cz===d){cz=v.createElement("canvas")}var d6=d3;d3=cz.getContext("2d");d3.font=R.css;var eb=R.measureTextWidth(ec);cz.width=eb;cz.height=dV;d3=cz.getContext("2d");d3.font=R.css;d3.textBaseline="top";bM.prototype.text$line(ec,0,0,0,37);var d5=cz.width/cz.height;d3=d6;d3.bindTexture(d3.TEXTURE_2D,bN);d3.texImage2D(d3.TEXTURE_2D,0,d3.RGBA,d3.RGBA,d3.UNSIGNED_BYTE,cz);d3.texParameteri(d3.TEXTURE_2D,d3.TEXTURE_MAG_FILTER,d3.LINEAR);d3.texParameteri(d3.TEXTURE_2D,d3.TEXTURE_MIN_FILTER,d3.LINEAR);d3.texParameteri(d3.TEXTURE_2D,d3.TEXTURE_WRAP_T,d3.CLAMP_TO_EDGE);d3.texParameteri(d3.TEXTURE_2D,d3.TEXTURE_WRAP_S,d3.CLAMP_TO_EDGE);var d9=0;if(ea===39){d9=-eb}else{if(ea===3){d9=-eb/2}}var d7=new aK;var d8=dV*0.5;d7.translate(eg+d9-d8/2,ef-d8,ed);d7.scale(-d5*d8,-d8,d8);d7.translate(-1,-1,-1);d7.transpose();var ee=new aK;ee.scale(1,-1,1);ee.apply(dE.array());ee.transpose();d3.useProgram(dL);c7("aVertex2d",dL,"aVertex",3,cC);c7("aTextureCoord2d",dL,"aTextureCoord",2,X);dU("uSampler2d",dL,"uSampler",[0]);dU("uIsDrawingText2d",dL,"uIsDrawingText",true);a4("uModel2d",dL,"uModel",false,d7.array());a4("uView2d",dL,"uView",false,ee.array());dX("uColor2d",dL,"uColor",bj);d3.bindBuffer(d3.ELEMENT_ARRAY_BUFFER,M);d3.drawElements(d3.TRIANGLES,6,d3.UNSIGNED_SHORT,0)};function bd(d8,eb,ea,d9){var ed,d7;if(d8.indexOf("\n")<0){ed=[d8];d7=1}else{ed=d8.split(/\r?\n/g);d7=ed.length}var d5=0;if(cW===101){d5=aY+dv}else{if(cW===3){d5=aY/2-(d7-1)*d2/2}else{if(cW===102){d5=-(dv+(d7-1)*d2)}}}for(var d6=0;d6<d7;++d6){var ec=ed[d6];dT.text$line(ec,eb,ea+d5,d9,I);d5+=d2}}function a8(el,eg,ef,ek,ei,ee){if(el.length===0||ek===0||ei===0){return}if(dV>ei){return}var eh=-1;var d9=0;var d5=0;var eb=[];for(var ea=0,en=el.length;ea<en;ea++){var ec=el[ea];var eq=ec===" ";var ej=R.measureTextWidth(ec);if(ec!=="\n"&&d5+ej<=ek){if(eq){eh=ea}d5+=ej}else{if(eh+1===d9){if(ea>0){eh=ea}else{return}}if(ec==="\n"){eb.push({text:el.substring(d9,ea),width:d5});d9=ea+1}else{eb.push({text:el.substring(d9,eh+1),width:d5});d9=eh+1}d5=0;ea=d9-1}}if(d9<en){eb.push({text:el.substring(d9),width:d5})}var ep=1,ed=aY;if(I===3){ep=ek/2}else{if(I===39){ep=ek}}var em=eb.length,d6=p.min(em,p.floor(ei/d2));if(cW===101){ed=aY+dv}else{if(cW===3){ed=ei/2-d2*(d6/2-1)}else{if(cW===102){ed=dv+d2}}}var d7,d8,eo;for(d7=0;d7<em;d7++){eo=d7*d2;if(ed+eo>ei-dv){break}d8=eb[d7];dT.text$line(d8.text,eg+ep,ef+ed+eo,ee,I)}}cR.text=function(){if(cD===5){return}if(arguments.length===3){bd(bp(arguments[0]),arguments[1],arguments[2],0)}else{if(arguments.length===4){bd(bp(arguments[0]),arguments[1],arguments[2],arguments[3])}else{if(arguments.length===5){a8(bp(arguments[0]),arguments[1],arguments[2],arguments[3],arguments[4],0)}else{if(arguments.length===6){a8(bp(arguments[0]),arguments[1],arguments[2],arguments[3],arguments[4],arguments[5])}}}}};cR.textMode=function(d5){cD=d5};cR.loadGlyphs=function(eb){var ed,ec,d9,d7,ek,ej,ei,el,ef,em,eg,eh="[0-9\\-]+",ee;var ea=function(es,er){var ep=0,eo=[],en,eq=new RegExp(es,"g");en=eo[ep]=eq.exec(er);while(en){ep++;en=eo[ep]=eq.exec(er)}return eo};var d6=function(es){var et=ea("[A-Za-z][0-9\\- ]+|Z",es);var er=function(){ay();return dT.$ensureContext()};var ep=function(){bi();c8();cK()};ee="return {draw:function(){var curContext=beforePathDraw();curContext.beginPath();";ed=0;ec=0;d9=0;d7=0;ek=0;ej=0;es=0;el=0;ef="";em=et.length-1;for(var eo=0;eo<em;eo++){var en=et[eo][0],eq=ea(eh,en);switch(en[0]){case"M":ed=parseFloat(eq[0][0]);ec=parseFloat(eq[1][0]);ee+="curContext.moveTo("+ed+","+-ec+");";break;case"L":ed=parseFloat(eq[0][0]);ec=parseFloat(eq[1][0]);ee+="curContext.lineTo("+ed+","+-ec+");";break;case"H":ed=parseFloat(eq[0][0]);ee+="curContext.lineTo("+ed+","+-ec+");";break;case"V":ec=parseFloat(eq[0][0]);ee+="curContext.lineTo("+ed+","+-ec+");";break;case"T":ek=parseFloat(eq[0][0]);ej=parseFloat(eq[1][0]);if(ef==="Q"||ef==="T"){es=p.sqrt(p.pow(ed-d9,2)+p.pow(d7-ec,2));el=p.PI+p.atan2(d9-ed,d7-ec);d9=ed+p.sin(el)*es;d7=ec+p.cos(el)*es}else{d9=ed;d7=ec}ee+="curContext.quadraticCurveTo("+d9+","+-d7+","+ek+","+-ej+");";ed=ek;ec=ej;break;case"Q":d9=parseFloat(eq[0][0]);d7=parseFloat(eq[1][0]);ek=parseFloat(eq[2][0]);ej=parseFloat(eq[3][0]);ee+="curContext.quadraticCurveTo("+d9+","+-d7+","+ek+","+-ej+");";ed=ek;ec=ej;break;case"Z":ee+="curContext.closePath();";break}ef=en[0]}ee+="afterPathDraw();";ee+="curContext.translate("+eg+",0);";ee+="}}";return(new Function("beforePathDraw","afterPathDraw",ee))(er,ep)};var d5=function(eq){var ep=eq.getElementsByTagName("font");cR.glyphTable[eb].horiz_adv_x=ep[0].getAttribute("horiz-adv-x");var es=eq.getElementsByTagName("font-face")[0];cR.glyphTable[eb].units_per_em=parseFloat(es.getAttribute("units-per-em"));cR.glyphTable[eb].ascent=parseFloat(es.getAttribute("ascent"));cR.glyphTable[eb].descent=parseFloat(es.getAttribute("descent"));var eu=eq.getElementsByTagName("glyph"),eo=eu.length;for(var et=0;et<eo;et++){var en=eu[et].getAttribute("unicode");var er=eu[et].getAttribute("glyph-name");eg=eu[et].getAttribute("horiz-adv-x");if(eg===null){eg=cR.glyphTable[eb].horiz_adv_x}ei=eu[et].getAttribute("d");if(ei!==d){ee=d6(ei);cR.glyphTable[eb][er]={name:er,unicode:en,horiz_adv_x:eg,draw:ee.draw}}}};var d8=function(){var ep;try{ep=v.implementation.createDocument("","",null)}catch(er){D.debug(er.message);return}try{ep.async=false;ep.load(eb);d5(ep.getElementsByTagName("svg")[0])}catch(eo){D.debug(eo);try{var en=new m.XMLHttpRequest;en.open("GET",eb,false);en.send(null);d5(en.responseXML.documentElement)}catch(eq){D.debug(eo)}}};cR.glyphTable[eb]={};d8(eb);return cR.glyphTable[eb]};cR.param=function(d7){var d6="data-processing-"+d7;if(Z.hasAttribute(d6)){return Z.getAttribute(d6)}for(var d8=0,d5=Z.childNodes.length;d8<d5;++d8){var d9=Z.childNodes.item(d8);if(d9.nodeType!==1||d9.tagName.toLowerCase()!=="param"){continue}if(d9.getAttribute("name")===d7){return d9.getAttribute("value")}}if(cL.params.hasOwnProperty(d7)){return cL.params[d7]}return null};function cG(d6){if(d6==="3D"){dT=new bw}else{if(d6==="2D"){dT=new bM}else{dT=new b5}}for(var d5 in b5.prototype){if(b5.prototype.hasOwnProperty(d5)&&d5.indexOf("$")<0){cR[d5]=dT[d5]}}dT.$init()}function cP(d5){return function(){cG("2D");return dT[d5].apply(this,arguments)}}b5.prototype.translate=cP("translate");b5.prototype.transform=cP("transform");b5.prototype.scale=cP("scale");b5.prototype.pushMatrix=cP("pushMatrix");b5.prototype.popMatrix=cP("popMatrix");b5.prototype.resetMatrix=cP("resetMatrix");b5.prototype.applyMatrix=cP("applyMatrix");b5.prototype.rotate=cP("rotate");b5.prototype.rotateZ=cP("rotateZ");b5.prototype.shearX=cP("shearX");b5.prototype.shearY=cP("shearY");b5.prototype.redraw=cP("redraw");b5.prototype.toImageData=cP("toImageData");b5.prototype.ambientLight=cP("ambientLight");b5.prototype.directionalLight=cP("directionalLight");b5.prototype.lightFalloff=cP("lightFalloff");b5.prototype.lightSpecular=cP("lightSpecular");b5.prototype.pointLight=cP("pointLight");b5.prototype.noLights=cP("noLights");b5.prototype.spotLight=cP("spotLight");b5.prototype.beginCamera=cP("beginCamera");b5.prototype.endCamera=cP("endCamera");b5.prototype.frustum=cP("frustum");b5.prototype.box=cP("box");b5.prototype.sphere=cP("sphere");b5.prototype.ambient=cP("ambient");b5.prototype.emissive=cP("emissive");b5.prototype.shininess=cP("shininess");b5.prototype.specular=cP("specular");b5.prototype.fill=cP("fill");b5.prototype.stroke=cP("stroke");b5.prototype.strokeWeight=cP("strokeWeight");b5.prototype.smooth=cP("smooth");b5.prototype.noSmooth=cP("noSmooth");b5.prototype.point=cP("point");b5.prototype.vertex=cP("vertex");b5.prototype.endShape=cP("endShape");b5.prototype.bezierVertex=cP("bezierVertex");b5.prototype.curveVertex=cP("curveVertex");b5.prototype.curve=cP("curve");b5.prototype.line=cP("line");b5.prototype.bezier=cP("bezier");b5.prototype.rect=cP("rect");b5.prototype.ellipse=cP("ellipse");b5.prototype.background=cP("background");b5.prototype.image=cP("image");b5.prototype.textWidth=cP("textWidth");b5.prototype.text$line=cP("text$line");b5.prototype.$ensureContext=cP("$ensureContext");b5.prototype.$newPMatrix=cP("$newPMatrix");b5.prototype.size=function(d5,d7,d6){cG(d6===2?"3D":"2D");cR.size(d5,d7,d6)};b5.prototype.$init=i;bM.prototype.$init=function(){cR.size(cR.width,cR.height);d3.lineCap="round";cR.noSmooth();cR.disableContextMenu()};bw.prototype.$init=function(){cR.use3DContext=true;cR.disableContextMenu()};dm.prototype.$ensureContext=function(){return d3};function dt(d6,d8){var d7=d6,d5=0,d9=0;cR.pmouseX=cR.mouseX;cR.pmouseY=cR.mouseY;if(d7.offsetParent){do{d5+=d7.offsetLeft;d9+=d7.offsetTop}while(!!(d7=d7.offsetParent))}d7=d6;do{d5-=d7.scrollLeft||0;d9-=d7.scrollTop||0}while(!!(d7=d7.parentNode));d5+=Y;d9+=dj;d5+=aP;d9+=bS;d5+=m.pageXOffset;d9+=m.pageYOffset;return{X:d5,Y:d9}}function aD(d5,d6){var d7=dt(d5,d6);cR.mouseX=d6.pageX-d7.X;cR.mouseY=d6.pageY-d7.Y}function cp(d6){var d8=dt(d6.changedTouches[0].target,d6.changedTouches[0]),d5;for(d5=0;d5<d6.touches.length;d5++){var ea=d6.touches[d5];ea.offsetX=ea.pageX-d8.X;ea.offsetY=ea.pageY-d8.Y}for(d5=0;d5<d6.targetTouches.length;d5++){var d7=d6.targetTouches[d5];d7.offsetX=d7.pageX-d8.X;d7.offsetY=d7.pageY-d8.Y}for(d5=0;d5<d6.changedTouches.length;d5++){var d9=d6.changedTouches[d5];d9.offsetX=d9.pageX-d8.X;d9.offsetY=d9.pageY-d8.Y}return d6}bJ(Z,"touchstart",function(d7){Z.setAttribute("style","-webkit-user-select: none");Z.setAttribute("onclick","void(0)");Z.setAttribute("style","-webkit-tap-highlight-color:rgba(0,0,0,0)");for(var d6=0,d5=ao.length;d6<d5;d6++){var d8=ao[d6].type;if(d8==="mouseout"||d8==="mousemove"||d8==="mousedown"||d8==="mouseup"||d8==="DOMMouseScroll"||d8==="mousewheel"||d8==="touchstart"){c9(ao[d6])}}if(cR.touchStart!==d||cR.touchMove!==d||cR.touchEnd!==d||cR.touchCancel!==d){bJ(Z,"touchstart",function(d9){if(cR.touchStart!==d){d9=cp(d9);cR.touchStart(d9)}});bJ(Z,"touchmove",function(d9){if(cR.touchMove!==d){d9.preventDefault();d9=cp(d9);cR.touchMove(d9)}});bJ(Z,"touchend",function(d9){if(cR.touchEnd!==d){d9=cp(d9);cR.touchEnd(d9)}});bJ(Z,"touchcancel",function(d9){if(cR.touchCancel!==d){d9=cp(d9);cR.touchCancel(d9)}})}else{bJ(Z,"touchstart",function(d9){aD(Z,d9.touches[0]);cR.__mousePressed=true;cR.mouseDragging=false;cR.mouseButton=37;if(typeof cR.mousePressed==="function"){cR.mousePressed()}});bJ(Z,"touchmove",function(d9){d9.preventDefault();aD(Z,d9.touches[0]);if(typeof cR.mouseMoved==="function"&&!cR.__mousePressed){cR.mouseMoved()}if(typeof cR.mouseDragged==="function"&&cR.__mousePressed){cR.mouseDragged();cR.mouseDragging=true}});bJ(Z,"touchend",function(d9){cR.__mousePressed=false;if(typeof cR.mouseClicked==="function"&&!cR.mouseDragging){cR.mouseClicked()}if(typeof cR.mouseReleased==="function"){cR.mouseReleased()}})}Z.dispatchEvent(d7)});(function(){var d5=true,d6=function(d7){d7.preventDefault();d7.stopPropagation()};cR.disableContextMenu=function(){if(!d5){return}bJ(Z,"contextmenu",d6);d5=false};cR.enableContextMenu=function(){if(d5){return}c9({elem:Z,type:"contextmenu",fn:d6});d5=true}})();bJ(Z,"mousemove",function(d5){aD(Z,d5);if(typeof cR.mouseMoved==="function"&&!cR.__mousePressed){cR.mouseMoved()}if(typeof cR.mouseDragged==="function"&&cR.__mousePressed){cR.mouseDragged();cR.mouseDragging=true}});bJ(Z,"mouseout",function(d5){if(typeof cR.mouseOut==="function"){cR.mouseOut()}});bJ(Z,"mouseover",function(d5){aD(Z,d5);if(typeof cR.mouseOver==="function"){cR.mouseOver()}});Z.onmousedown=function(){Z.focus();return false};bJ(Z,"mousedown",function(d5){cR.__mousePressed=true;cR.mouseDragging=false;switch(d5.which){case 1:cR.mouseButton=37;break;case 2:cR.mouseButton=3;break;case 3:cR.mouseButton=39;break}if(typeof cR.mousePressed==="function"){cR.mousePressed()}});bJ(Z,"mouseup",function(d5){cR.__mousePressed=false;if(typeof cR.mouseClicked==="function"&&!cR.mouseDragging){cR.mouseClicked()}if(typeof cR.mouseReleased==="function"){cR.mouseReleased()}});var ai=function(d5){var d6=0;if(d5.wheelDelta){d6=d5.wheelDelta/120;if(m.opera){d6=-d6}}else{if(d5.detail){d6=-d5.detail/3}}cR.mouseScroll=d6;if(d6&&typeof cR.mouseScrolled==="function"){cR.mouseScrolled()}};bJ(v,"DOMMouseScroll",ai);bJ(v,"mousewheel",ai);if(!Z.getAttribute("tabindex")){Z.setAttribute("tabindex",0)}function dy(d6){var d5=d6.which||d6.keyCode;switch(d5){case 13:return 10;case 91:case 93:case 224:return 157;case 57392:return 17;case 46:return 127;case 45:return 155}return d5}function cw(d6){var d7=d6.which||d6.keyCode;var d5=d6.shiftKey||d6.ctrlKey||d6.altKey||d6.metaKey;switch(d7){case 13:d7=d5?13:10;break;case 8:d7=d5?127:8;break}return new bK(d7)}function cM(d5){if(typeof d5.preventDefault==="function"){d5.preventDefault()}else{if(typeof d5.stopPropagation==="function"){d5.stopPropagation()}}return false}function dB(){var d5;for(d5 in ab){if(ab.hasOwnProperty(d5)){cR.__keyPressed=true;return}}cR.__keyPressed=false}function cs(){cR.__keyPressed=false;ab=[];dD=null}function bl(d5,d6){ab[d5]=d6;dD=null;cR.key=d6;cR.keyCode=d5;cR.keyPressed();cR.keyCode=0;cR.keyTyped();dB()}function cu(d6){var d5=dy(d6);if(d5===127){bl(d5,new bK(127));return}if(dS.indexOf(d5)<0){dD=d5;return}var d7=new bK(65535);cR.key=d7;cR.keyCode=d5;ab[d5]=d7;cR.keyPressed();dD=null;dB();return cM(d6)}function dq(d6){if(dD===null){return}var d5=dD,d7=cw(d6);bl(d5,d7);return cM(d6)}function ck(d6){var d5=dy(d6),d7=ab[d5];if(d7===d){return}cR.key=d7;cR.keyCode=d5;cR.keyReleased();delete ab[d5];dB()}if(!cQ){if(a5 instanceof D.Sketch){cL=a5}else{if(typeof a5==="function"){cL=new D.Sketch(a5)}else{if(!a5){cL=new D.Sketch(function(){})}else{throw"PJS compile is not supported"}}}cR.externals.sketch=cL;cG();Z.onfocus=function(){cR.focused=true};Z.onblur=function(){cR.focused=false;if(!cL.options.globalKeyEvents){cs()}};if(cL.options.pauseOnBlur){bJ(m,"focus",function(){if(ax){cR.loop()}});bJ(m,"blur",function(){if(ax&&ar){cR.noLoop();ax=true}cs()})}var aQ=cL.options.globalKeyEvents?m:Z;bJ(aQ,"keydown",cu);bJ(aQ,"keypress",dq);bJ(aQ,"keyup",ck);for(var cZ in D.lib){if(D.lib.hasOwnProperty(cZ)){if(D.lib[cZ].hasOwnProperty("attach")){D.lib[cZ].attach(cR)}else{if(D.lib[cZ] instanceof Function){D.lib[cZ].call(this)}}}}var dw=100;var b1=function(d8){if(!(cL.imageCache.pending||g.preloading.pending(dw))){if(m.opera){var d7,d6,d5=cL.imageCache.operaCache;for(d7 in d5){if(d5.hasOwnProperty(d7)){d6=d5[d7];if(d6!==null){v.body.removeChild(d6)}delete d5[d7]}}}cL.attach(d8,c);cL.onLoad(d8);if(d8.setup){d8.setup();d8.resetMatrix();cL.onSetup()}O();if(d8.draw){if(!ax){d8.redraw()}else{d8.loop()}}}else{m.setTimeout(function(){b1(d8)},dw)}};w(this);b1(cR)}else{cL=new D.Sketch;cG();cR.size=function(d5,d7,d6){if(d6&&d6===2){cG("3D")}else{cG("2D")}cR.size(d5,d7,d6)}}};D.debug=t;D.prototype=c;var G=function(){var O={},L="undefined",M="function",I=!1,N=!0,J=512,K="log";if(typeof tinylog!==L&&typeof tinylog[K]===M){O[K]=tinylog[K]}else{if(typeof v!==L&&!v.fake){(function(){var aj=v,ah="div",X="style",ab="title",W={zIndex:10000,position:"fixed",bottom:"0px",width:"100%",height:"15%",fontFamily:"sans-serif",color:"#ccc",backgroundColor:"black"},Z={position:"relative",fontFamily:"monospace",overflow:"auto",height:"100%",paddingTop:"5px"},ad={height:"5px",marginTop:"-5px",cursor:"n-resize",backgroundColor:"darkgrey"},ai={position:"absolute",top:"5px",right:"20px",color:"#111",MozBorderRadius:"4px",webkitBorderRadius:"4px",borderRadius:"4px",cursor:"pointer",fontWeight:"normal",textAlign:"center",padding:"3px 5px",backgroundColor:"#333",fontSize:"12px"},T={minHeight:"16px"},aa={fontSize:"12px",margin:"0 8px 0 8px",maxWidth:"100%",whiteSpace:"pre-wrap",overflow:"auto"},Y=aj.defaultView,ag=aj.documentElement,P=ag[X],R=function(){var al=arguments.length,ak,an,am;while(al--){an=arguments[al--];ak=arguments[al][X];for(am in an){if(an.hasOwnProperty(am)){ak[am]=an[am]}}}},ae=function(am,al,ak){if(am.addEventListener){am.addEventListener(al,ak,I)}else{if(am.attachEvent){am.attachEvent("on"+al,ak)}}return[am,al,ak]},Q=function(am,al,ak){if(am.removeEventListener){am.removeEventListener(al,ak,I)}else{if(am.detachEvent){am.detachEvent("on"+al,ak)}}},V=function(al){var ak=al.childNodes,am=ak.length;while(am--){al.removeChild(ak.item(0))}},af=function(al,ak){return al.appendChild(ak)},ac=function(ak){return aj.createElement(ak)},U=function(ak){return aj.createTextNode(ak)},S=O[K]=function(az){var aq,ar=P.paddingBottom,am=ac(ah),aw=am[X],ax=af(am,ac(ah)),ao=af(am,ac(ah)),an=af(am,ac(ah)),ay=I,ap=I,al=I,at=0,ak=function(){P.paddingBottom=am.clientHeight+"px"},av=function(aA){var aB=Y.innerHeight,aC=ax.clientHeight;if(aA<0){aA=0}else{if(aA+aC>aB){aA=aB-aC}}aw.height=aA/aB*100+"%";ak()},au=[ae(aj,"mousemove",function(aA){if(ay){av(Y.innerHeight-aA.clientY);ao.scrollTop=al}}),ae(aj,"mouseup",function(){if(ay){ay=al=I}}),ae(ax,"dblclick",function(aA){aA.preventDefault();if(ap){av(ap);ap=I}else{ap=am.clientHeight;aw.height="0px"}}),ae(ax,"mousedown",function(aA){aA.preventDefault();ay=N;al=ao.scrollTop}),ae(ax,"contextmenu",function(){ay=I}),ae(an,"click",function(){aq()})];aq=function(){var aA=au.length;while(aA--){Q.apply(O,au[aA])}ag.removeChild(am);P.paddingBottom=ar;V(ao);V(am);O[K]=S};R(am,W,ao,Z,ax,ad,an,ai);an[ab]="Close Log";af(an,U("\u2716"));ax[ab]="Double-click to toggle log minimization";ag.insertBefore(am,ag.firstChild);O[K]=function(aC){if(at===J){ao.removeChild(ao.firstChild)}else{at++}var aB=af(ao,ac(ah)),aA=af(aB,ac(ah));aB[ab]=(new Date).toLocaleTimeString();R(aB,T,aA,aa);af(aA,U(aC));ao.scrollTop=ao.scrollHeight};O[K](az);ak()}})()}else{if(typeof print===M){O[K]=print}}}return O}();D.logger=G;D.version="1.4.1-API";D.lib={};D.registerLibrary=function(I,J){D.lib[I]=J;if(J.hasOwnProperty("init")){J.init(c)}};D.instances=A;D.getInstanceById=function(I){return A[h[I]]};D.Sketch=function(I){this.attachFunction=I;this.options={pauseOnBlur:false,globalKeyEvents:false};this.onLoad=i;this.onSetup=i;this.onPause=i;this.onLoop=i;this.onFrameStart=i;this.onFrameEnd=i;this.onExit=i;this.params={};this.imageCache={pending:0,images:{},operaCache:{},add:function(K,J){if(this.images[K]){return}if(!H){this.images[K]=null}if(!J){J=new Image;J.onload=function(M){return function(){M.pending--}}(this);this.pending++;J.src=K}this.images[K]=J;if(m.opera){var L=v.createElement("div");L.appendChild(J);L.style.position="absolute";L.style.opacity=0;L.style.width="1px";L.style.height="1px";if(!this.operaCache[K]){v.body.appendChild(L);this.operaCache[K]=L}}}};this.sourceCode=undefined;this.attach=function(K){if(typeof this.attachFunction==="function"){this.attachFunction(K)}else{if(this.sourceCode){var J=(new Function("return ("+this.sourceCode+");"))();J(K);this.attachFunction=J}else{throw"Unable to attach sketch to the processing instance"}}}};if(H){m.Processing=D}else{this.Processing=D}})(window,window.document,Math);