(function() {
  var sketchAttach;

  sketchAttach = function(p) {
    var draw, gfx, keys, player, preload, sfx, time, track;
    sfx = (function() {
      var boost, crash, drone, drone_stop, file, files, jump, obj, objects, pause, play, preload, set_looping, track, track_stop, _i, _len;
      files = ["sfx/boost2.wav", "sfx/jump1.wav", "sfx/death.wav", "sfx/drone.mp3", "sfx/track1v2.mp3"];
      objects = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = files.length; _i < _len; _i++) {
          file = files[_i];
          _results.push(new Audio(file));
        }
        return _results;
      })();
      play = function(n) {
        if (objects[n].currentTime !== 0) objects[n].currentTime = 0;
        objects[n].play();
      };
      pause = function(n) {
        return objects[n].pause();
      };
      set_looping = function(n) {
        return objects[n].addEventListener('ended', (function() {
          return play(n);
        }));
      };
      preload = function(obj) {
        return obj.addEventListener('loaded', (function() {
          return console.log("loaded", obj);
        }));
      };
      for (_i = 0, _len = objects.length; _i < _len; _i++) {
        obj = objects[_i];
        preload(obj);
      }
      crash = function() {
        return play(2);
      };
      jump = function() {
        return play(1);
      };
      boost = function() {
        return play(0);
      };
      set_looping(3);
      drone = function() {
        return play(3);
      };
      drone_stop = function() {
        return pause(3);
      };
      set_looping(4);
      track = function() {
        return play(4);
      };
      track_stop = function() {
        return pause(4);
      };
      return {
        crash: crash,
        boost: boost,
        jump: jump,
        drone: drone,
        drone_stop: drone_stop,
        track: track,
        track_stop: track_stop
      };
    })();
    gfx = (function() {
      var boost_empty, boost_full, car, car_shadow, files, get, imgname, logo, objects, preview, space, street, streets;
      files = ["gfx/test-street2.png", "gfx/test-warn.png", "gfx/test-boost2.png", "gfx/car2x32.png", "gfx/shadow3.png", "gfx/logo320b.png", "gfx/boost-empty.png", "gfx/boost-full.png"];
      objects = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = files.length; _i < _len; _i++) {
          imgname = files[_i];
          _results.push(p.loadImage(imgname));
        }
        return _results;
      })();
      preview = function() {
        var img, previewsize, x, _len;
        previewsize = 32;
        p.stroke(0, 0, 100);
        p.fill(0, 0, 100);
        for (x = 0, _len = objects.length; x < _len; x++) {
          img = objects[x];
          p.image(img, x * previewsize, 0, previewsize, previewsize);
        }
      };
      get = function(n) {
        return objects[n];
      };
      car = function() {
        return get(3);
      };
      car_shadow = function() {
        return get(4);
      };
      logo = function() {
        return get(5);
      };
      boost_full = function() {
        return get(7);
      };
      boost_empty = function() {
        return get(6);
      };
      space = function() {
        return get(8);
      };
      streets = [0, 1, 2];
      street = function(n) {
        return get(streets[n]);
      };
      return {
        preview: preview,
        car: car,
        car_shadow: car_shadow,
        logo: logo,
        boost_full: boost_full,
        boost_empty: boost_empty,
        space: space,
        street: street
      };
    })();
    time = (function() {
      var delta, get_delta, now, previous, update;
      now = previous = delta = 0;
      update = function() {
        previous = now;
        now = p.millis();
        delta = (now - previous) / 1000;
      };
      get_delta = function() {
        return delta;
      };
      return {
        update: update,
        delta: get_delta
      };
    })();
    track = (function() {
      var boostify, comp_fast_perlin_snake, comp_three_straight, delay, depth_iter, diam_scale, draw, mod, move, plot_sprite, plot_sprites, put_at_depth, shunt, src_line, src_perlin, src_straight, step_scale, street_at, street_count, street_gap, track_depth, track_scale, wallify, zerofy;
      track_depth = 3000;
      street_count = 32;
      street_gap = track_depth / street_count;
      depth_iter = function(i, offset) {
        if (offset === void 0) offset = 0;
        return offset + (i * street_gap);
      };
      track_scale = 1200;
      src_perlin = function(scale, offset, size) {
        if (scale == null) scale = track_scale;
        if (offset == null) offset = 0;
        if (size == null) size = 100;
        return function(step) {
          return [(p.noise(step + offset) - 0.3) * scale, (p.noise(step + 211 + offset) - 0.3) * scale, size, 0];
        };
      };
      src_straight = function() {
        return function() {
          return [0, 0, 100, 0];
        };
      };
      src_line = function(seeda, seedb, len) {
        return function(step) {
          var x;
          x = step / len;
          return [p.lerp(p.noise(seeda), p.noise(seedb), x), p.lerp(p.noise(seeda + 211), p.noise(seedb + 211), x), 100, 0];
        };
      };
      zerofy = function(range, track) {
        return function(step) {
          var t;
          t = track(step);
          t[0] *= p.min(1, step / range);
          t[1] *= p.min(1, step / range);
          return t;
        };
      };
      track_scale = function(scale, track) {
        return function(step) {
          var t;
          t = track(step);
          t[0] *= scale;
          t[1] *= scale;
          return t;
        };
      };
      step_scale = function(scale, track) {
        return function(step) {
          return track(step * scale);
        };
      };
      diam_scale = function(scale, track) {
        return function(step) {
          var t;
          t = track(step);
          t[2] *= scale;
          return t;
        };
      };
      wallify = function(mod, offset, track) {
        return function(step) {
          var t;
          t = track(step);
          if (((step + offset) % mod) < street_gap * 3) {
            t[2] = 220;
            t[3] = 1;
          }
          return t;
        };
      };
      boostify = function(mod, offset, track) {
        return function(step) {
          var t;
          t = track(step);
          if (((step + offset) % mod) < street_gap * 3) t[3] = 2;
          return t;
        };
      };
      move = function(x, y, track) {
        return function(step) {
          var t;
          t = track(step);
          t[0] += x;
          t[1] += y;
          return t;
        };
      };
      delay = function(d, track) {
        return function(step) {
          return track(step - d);
        };
      };
      mod = function(m, track) {
        return function(step) {
          return track(step % m);
        };
      };
      shunt = function(dist, tracka, trackb) {
        return function(step) {
          if (step < dist) {
            return tracka(step);
          } else {
            return trackb(step);
          }
        };
      };
      comp_three_straight = function() {
        return function(step) {
          var length;
          length = 7200;
          return wallify(length, length / 2.3, boostify(length, length / 12, mod(length / 3, shunt(length / 6, move(0, 9000, src_straight()), src_straight()))))(step);
        };
      };
      comp_fast_perlin_snake = function(offset, size) {
        if (offset == null) offset = 0;
        if (size == null) size = 100;
        return function(stepo) {
          var length, offlen, src, sscale, step, tscale;
          length = 6000;
          step = stepo + (offset * length);
          sscale = 0.0004;
          tscale = 1300;
          src = step_scale(sscale, src_perlin(tscale, offset * 120000, size));
          offlen = offset * length;
          if (step % length < length / 2) {
            return boostify(length / 2, 0, src)(step);
          } else {
            return wallify(length / 2, 0, src)(step);
          }
        };
      };
      street_at = function(step) {
        return [comp_fast_perlin_snake(0)(step), comp_fast_perlin_snake(0.3)(step), comp_fast_perlin_snake(0.6)(step)];
      };
      put_at_depth = function(depth, draw_fn) {
        p.pushMatrix();
        p.translate(0, 0, depth);
        p.fill(0, 0, 100 - p.abs(depth / track_depth * 100));
        draw_fn();
        p.popMatrix();
      };
      plot_sprite = function(street) {
        p.image(gfx.street(street[3]), street[0] - (street[2] / 2), street[1] - (street[2] / 2), street[2], street[2]);
        return p.translate(0, 0, 1);
      };
      plot_sprites = function(streets) {
        return function() {
          var street, _i, _len, _results;
          _results = [];
          for (_i = 0, _len = streets.length; _i < _len; _i++) {
            street = streets[_i];
            _results.push(plot_sprite(street));
          }
          return _results;
        };
      };
      draw = function() {
        var i, offset, rest, _ref, _results;
        offset = player.depth() % street_gap;
        rest = player.depth() - offset;
        p.noStroke();
        p.fill(0, 0, 100);
        _results = [];
        for (i = _ref = street_count - 1; i >= 0; i += -1) {
          _results.push(put_at_depth(depth_iter(-i, offset), plot_sprites(track.street_at(depth_iter(i, rest)))));
        }
        return _results;
      };
      return {
        street_at: street_at,
        draw: draw
      };
    })();
    player = (function() {
      var adjust_forces_to, alive, apply_forces, boost, cam, camAhead, camY, camZ, closest_street, crash, crash_tolerance, depth, draw, drive, driveSpeed, find_shadow, floor_contact, force, get_depth, get_position, has_alive, hover_downto, hover_escape, hover_upto, jump, jumpforce, jumppotencial, jumptime, jumpvector, plot_circle, position, shadow, sinkforce, sinkpotential, sinktime, start, turnSpeed, update, upforce, upvector;
      alive = false;
      turnSpeed = 600;
      driveSpeed = 1000;
      camY = 60;
      camZ = 80;
      camAhead = 100;
      boost = (function() {
        var add, count, draw, get_count, held, hold, release, reset, spend;
        count = 1;
        hold = false;
        add = function() {
          if (count < 3) {
            count += 1;
            sfx.boost();
          }
          hold = true;
        };
        held = function() {
          return hold;
        };
        release = function() {
          return hold = false;
        };
        draw = function() {
          var ww, x, _ref, _ref2, _ref3, _ref4;
          ww = p.width / 8;
          for (x = _ref = ww * 2.5, _ref2 = ww * 4.5; _ref <= _ref2 ? x <= _ref2 : x >= _ref2; x += ww) {
            p.image(gfx.boost_empty(), x, 0, ww, ww);
          }
          if (count > 0) {
            for (x = _ref3 = ww * 2.5, _ref4 = ww * (2.5 + count - 1); _ref3 <= _ref4 ? x <= _ref4 : x >= _ref4; x += ww) {
              p.image(gfx.boost_full(), x, 0, ww, ww);
            }
          }
        };
        get_count = function() {
          return count;
        };
        spend = function() {
          if (count > 0) {
            count -= 1;
            return true;
          } else {
            return false;
          }
        };
        reset = function() {
          return count = 1;
        };
        return {
          add: add,
          spend: spend,
          held: held,
          release: release,
          draw: draw,
          count: get_count,
          reset: reset
        };
      })();
      position = new p.PVector(0, -200);
      shadow = 0;
      force = new p.PVector(0, 0);
      upvector = new p.PVector(0, 1);
      upforce = new p.PVector(0, 1);
      depth = 0;
      jumpvector = new p.PVector(0, 0);
      jumppotencial = 30;
      jumptime = 0.4;
      jumpforce = 0;
      sinkpotential = 100;
      sinktime = 2;
      sinkforce = 0;
      floor_contact = false;
      hover_escape = 50;
      hover_downto = 10;
      hover_upto = 10;
      crash_tolerance = 20;
      get_position = function() {
        return position;
      };
      get_depth = function() {
        return depth;
      };
      crash = function() {
        if (alive) {
          sfx.crash();
          sfx.drone();
          sfx.track_stop();
          boost.reset();
          return alive = false;
        }
      };
      start = function() {
        alive = true;
        sfx.drone_stop();
        return sfx.track();
      };
      has_alive = function() {
        return alive;
      };
      closest_street = function(streets) {
        var d, dists, i, min, street;
        dists = (function() {
          var _i, _len, _results;
          _results = [];
          for (_i = 0, _len = streets.length; _i < _len; _i++) {
            street = streets[_i];
            _results.push((p.dist(position.x, position.y, street[0], street[1])) - (street[2] / 2));
          }
          return _results;
        })();
        min = Math.min.apply(Math, dists);
        return ((function() {
          var _len, _results;
          _results = [];
          for (i = 0, _len = dists.length; i < _len; i++) {
            d = dists[i];
            if (d === min) _results.push(streets[i]);
          }
          return _results;
        })())[0];
      };
      find_shadow = function(street) {
        var length, shadow_vector, surface;
        shadow_vector = new p.PVector(street[0] - position.x, street[1] - position.y);
        length = shadow_vector.mag();
        surface = street[2] / 2;
        return shadow = p.PVector.limit(shadow_vector, length - surface).mag();
      };
      adjust_forces_to = function(street, dt) {
        var length, surface, vector;
        vector = new p.PVector(street[0] - position.x, street[1] - position.y);
        upforce.set(vector);
        upforce.normalize();
        length = vector.mag();
        surface = street[2] / 2;
        force.set(0, 0, 0);
        if (jumpforce > 0) {
          if (floor_contact === true) jumpvector.set(upforce);
          force.set(p.PVector.mult(jumpvector, -jumpforce));
          jumpforce = p.max(jumpforce - (jumppotencial / jumptime * dt), 0);
          floor_contact = false;
        } else if (length > (surface + hover_escape)) {
          force.set(p.PVector.mult(upforce, sinkforce));
          force.limit(length - (surface + hover_downto));
          sinkforce = p.min(sinkforce + (sinkpotential / sinktime * dt), sinkpotential);
          floor_contact = false;
        } else if (length > (surface + hover_downto)) {
          vector.limit(length - (surface + hover_downto));
          force.set(vector);
          floor_contact = true;
        } else if (length < (surface + hover_upto)) {
          vector.normalize();
          vector.mult(((surface + hover_upto) - length) * -1);
          force.set(vector);
          floor_contact = true;
        }
        if (length < (surface - crash_tolerance)) crash();
        if (floor_contact === true) sinkforce = 0;
      };
      apply_forces = function(dt) {
        upvector.add(p.PVector.mult(upforce, dt * 5));
        upvector.normalize();
        position.add(force);
      };
      drive = function(x, y, dt) {
        position.add(upvector.y * x * turnSpeed * dt, upvector.x * -x * turnSpeed * dt, 0);
        depth += alive ? y * driveSpeed * dt : y * driveSpeed * dt / 10;
      };
      jump = function() {
        if (floor_contact && boost.spend()) {
          jumpforce = jumppotencial;
          sfx.jump();
        }
      };
      update = function(dt) {
        var closest;
        closest = closest_street(track.street_at(depth));
        if (closest[3] === 2 && floor_contact && alive) {
          if (!boost.held()) boost.add();
        } else {
          boost.release();
        }
        adjust_forces_to(closest, dt);
        apply_forces(dt);
        find_shadow(closest);
      };
      plot_circle = function(circle) {
        p.ellipse(circle[0], circle[1], circle[2], circle[2]);
      };
      draw = function() {
        p.pushMatrix();
        p.translate(position.x, position.y);
        p.rotateZ((p.atan2(upforce.y, upforce.x)) - p.HALF_PI);
        if (alive) {
          p.noStroke();
          p.fill(0, 0, 100);
          p.scale(0.5);
          p.image(gfx.car_shadow(), -16, -8 + shadow, 32, 32);
          p.scale(0.6);
          p.image(gfx.car(), -64, -64, 128, 128);
          p.popMatrix();
        }
        p.camera();
        p.hint(p.DISABLE_DEPTH_TEST);
        if (alive) {
          boost.draw();
        } else {
          p.image(gfx.logo(), 0, 0);
        }
      };
      cam = function() {
        p.camera(position.x - (upvector.x * camY), position.y - (upvector.y * camY), camZ, position.x, position.y, -camAhead, upvector.x, upvector.y, 0);
        p.perspective(p.PI / 3.0, p.width / p.height, 10, 3000);
      };
      return {
        position: get_position,
        depth: get_depth,
        drive: drive,
        jump: jump,
        update: update,
        draw: draw,
        cam: cam,
        alive: has_alive,
        start: start
      };
    })();
    keys = (function() {
      var get_state, set, state;
      state = {
        ff: false,
        left: false,
        right: false,
        jump: false
      };
      set = function(keyCode, nustate) {
        var abort;
        switch (keyCode) {
          case p.LEFT:
            state.left = nustate;
            break;
          case p.RIGHT:
            state.right = nustate;
            break;
          case p.UP:
            state.jump = nustate;
            break;
          case p.DOWN:
            state.start = nustate;
            break;
          case 8:
            abort = true;
        }
      };
      get_state = function() {
        return state;
      };
      return {
        set: set,
        state: get_state
      };
    })();
    p.setup = function() {
      p.size(320, 240, p.OPENGL);
      canvas.style.width = "640px";
      canvas.style.height = "480px";
      p.frameRate(30);
      p.rectMode(p.CENTER);
      p.ellipseMode(p.CENTER);
      p.colorMode(p.HSB, 100);
      p.noiseDetail(2);
      sfx.drone();
    };
    draw = function() {
      time.update();
      if (player.alive()) {
        player.drive((keys.state().left ? -1 : keys.state().right), 1, time.delta());
        if (keys.state().jump) player.jump();
      } else {
        player.drive(0, 1, time.delta());
        if (keys.state().start) player.start();
      }
      player.update(time.delta());
      p.background(0);
      player.cam();
      track.draw();
      player.draw();
    };
    preload = function() {
      p.background(0);
      gfx.preview();
      return p.draw = draw;
    };
    p.draw = preload;
    p.keyPressed = function() {
      return keys.set(p.keyCode, true);
    };
    p.keyReleased = function() {
      return keys.set(p.keyCode, false);
    };
  };

  window.onload = function() {
    var canvas, imgs, p5, sketch, x, _i, _len;
    canvas = document.getElementById("canvas");
    sketch = new Processing.Sketch();
    imgs = ["gfx/test-street2.png", "gfx/test-warn.png", "gfx/test-boost2.png", "gfx/car2x32.png", "gfx/shadow3.png", "gfx/logo320b.png", "gfx/boost-empty.png", "gfx/boost-full.png"];
    for (_i = 0, _len = imgs.length; _i < _len; _i++) {
      x = imgs[_i];
      sketch.imageCache.add(x);
    }
    sketch.attachFunction = sketchAttach;
    p5 = new Processing(canvas, sketch);
  };

}).call(this);
